/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.DefaultEncryptingOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rs.security.oauth2.utils.crypto.ModelEncryptionSupport;

public class DefaultEncryptingCodeDataProvider
extends DefaultEncryptingOAuthDataProvider
implements AuthorizationCodeDataProvider {
    private long grantLifetime;
    private Set<String> grants = Collections.synchronizedSet(new HashSet());

    public DefaultEncryptingCodeDataProvider(String algo, int keySize) {
        super(algo, keySize);
    }

    public DefaultEncryptingCodeDataProvider(KeyProperties props) {
        super(props);
    }

    public DefaultEncryptingCodeDataProvider(SecretKey key) {
        super(key);
    }

    @Override
    public Client removeClient(String clientId) {
        Client c = super.removeClient(clientId);
        this.removeClientCodeGrants(c);
        return c;
    }

    protected void removeClientCodeGrants(Client c) {
        for (ServerAuthorizationCodeGrant grant : this.getCodeGrants(c)) {
            this.removeCodeGrant(grant.getCode());
        }
    }

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.doCreateCodeGrant(reg);
        this.saveAuthorizationGrant(grant);
        return grant;
    }

    public List<ServerAuthorizationCodeGrant> getCodeGrants(Client c) {
        ArrayList<ServerAuthorizationCodeGrant> list = new ArrayList<ServerAuthorizationCodeGrant>(this.grants.size());
        for (String key : this.grants) {
            ServerAuthorizationCodeGrant grant = this.getCodeGrant(key);
            if (!grant.getClient().getClientId().equals(c.getClientId())) continue;
            list.add(grant);
        }
        return list;
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        this.grants.remove(code);
        return ModelEncryptionSupport.decryptCodeGrant((OAuthDataProvider)this, code, this.key);
    }

    public ServerAuthorizationCodeGrant getCodeGrant(String code) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = ModelEncryptionSupport.decryptCodeGrant((OAuthDataProvider)this, code, this.key);
        if (grant != null) {
            this.grants.remove(code);
        }
        return grant;
    }

    protected ServerAuthorizationCodeGrant doCreateCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = new ServerAuthorizationCodeGrant(reg.getClient(), this.getCode(reg), this.getGrantLifetime(), this.getIssuedAt());
        grant.setApprovedScopes(this.getApprovedScopes(reg));
        grant.setAudience(reg.getAudience());
        grant.setClientCodeChallenge(reg.getClientCodeChallenge());
        grant.setSubject(reg.getSubject());
        grant.setRedirectUri(reg.getRedirectUri());
        return grant;
    }

    protected List<String> getApprovedScopes(AuthorizationCodeRegistration reg) {
        return reg.getApprovedScope();
    }

    protected String getCode(AuthorizationCodeRegistration reg) {
        return OAuthUtils.generateRandomTokenKey();
    }

    public long getGrantLifetime() {
        return this.grantLifetime;
    }

    public void setGrantLifetime(long lifetime) {
        this.grantLifetime = lifetime;
    }

    protected long getIssuedAt() {
        return OAuthUtils.getIssuedAt();
    }

    protected void saveAuthorizationGrant(ServerAuthorizationCodeGrant grant) {
        String encrypted = ModelEncryptionSupport.encryptCodeGrant(grant, this.key);
        grant.setCode(encrypted);
        this.grants.add(encrypted);
    }
}

