/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationCodeRequestFilter;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationCodeResponseFilter;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.OOBResponseDeliverer;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;

@Path(value="/authorize")
public class AuthorizationCodeGrantService
extends RedirectionBasedGrantService {
    private boolean canSupportPublicClients;
    private OOBResponseDeliverer oobDeliverer;
    private AuthorizationCodeRequestFilter codeRequestFilter;
    private AuthorizationCodeResponseFilter codeResponseFilter;

    public AuthorizationCodeGrantService() {
        super("code", "authorization_code");
    }

    @Override
    protected Response startAuthorization(MultivaluedMap<String, String> params, UserSubject userSubject, Client client) {
        if (this.codeRequestFilter != null) {
            params = this.codeRequestFilter.process(params, userSubject, client);
        }
        return super.startAuthorization(params, userSubject, client);
    }

    @Override
    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, UserSubject subject, String redirectUri, List<OAuthPermission> perms) {
        OAuthAuthorizationData secData = super.createAuthorizationData(client, params, subject, redirectUri, perms);
        AuthorizationCodeGrantService.setCodeQualifier(secData, params);
        return secData;
    }

    private static void setCodeQualifier(OAuthAuthorizationData data, MultivaluedMap<String, String> params) {
        data.setClientCodeChallenge((String)params.getFirst((Object)"code_challenge"));
    }

    @Override
    protected Response createGrant(MultivaluedMap<String, String> params, Client client, String redirectUri, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preauthorizedToken) {
        AuthorizationCodeRegistration codeReg = new AuthorizationCodeRegistration();
        codeReg.setClient(client);
        codeReg.setRedirectUri(redirectUri);
        codeReg.setRequestedScope(requestedScope);
        codeReg.setApprovedScope(approvedScope);
        codeReg.setSubject(userSubject);
        codeReg.setAudience((String)params.getFirst((Object)"audience"));
        codeReg.setClientCodeChallenge((String)params.getFirst((Object)"code_challenge"));
        ServerAuthorizationCodeGrant grant = null;
        try {
            grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).createCodeGrant(codeReg);
        }
        catch (OAuthServiceException ex) {
            return this.createErrorResponse(params, redirectUri, "access_denied");
        }
        String grantCode = this.processCodeGrant(client, grant.getCode(), grant.getSubject());
        if (redirectUri == null) {
            OOBAuthorizationResponse oobResponse = new OOBAuthorizationResponse();
            oobResponse.setClientId(client.getClientId());
            oobResponse.setAuthorizationCode(grant.getCode());
            oobResponse.setUserId(userSubject.getLogin());
            oobResponse.setExpiresIn(grant.getExpiresIn());
            return this.deliverOOBResponse(oobResponse);
        }
        UriBuilder ub = this.getRedirectUriBuilder((String)params.getFirst((Object)"state"), redirectUri);
        ub.queryParam("code", new Object[]{grantCode});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    protected String processCodeGrant(Client client, String code, UserSubject endUser) {
        if (this.codeResponseFilter != null) {
            return this.codeResponseFilter.process(client, code, endUser);
        }
        return code;
    }

    protected Response deliverOOBResponse(OOBAuthorizationResponse response) {
        if (this.oobDeliverer != null) {
            return this.oobDeliverer.deliver(response);
        }
        return Response.ok((Object)response).type("text/html").build();
    }

    @Override
    protected Response createErrorResponse(MultivaluedMap<String, String> params, String redirectUri, String error) {
        if (redirectUri == null) {
            return Response.status((int)401).entity((Object)error).build();
        }
        UriBuilder ub = this.getRedirectUriBuilder((String)params.getFirst((Object)"state"), redirectUri);
        ub.queryParam("error", new Object[]{error});
        return Response.seeOther((URI)ub.build(new Object[0])).build();
    }

    protected UriBuilder getRedirectUriBuilder(String state, String redirectUri) {
        UriBuilder ub = UriBuilder.fromUri((String)redirectUri);
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub;
    }

    @Override
    protected boolean canSupportPublicClient(Client c) {
        return this.canSupportPublicClients && !c.isConfidential() && c.getClientSecret() == null;
    }

    @Override
    protected boolean canRedirectUriBeEmpty(Client c) {
        return this.canSupportPublicClient(c) && c.getRedirectUris().isEmpty();
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public void setCodeResponseFilter(AuthorizationCodeResponseFilter filter) {
        this.codeResponseFilter = filter;
    }

    public void setCodeRequestFilter(AuthorizationCodeRequestFilter codeRequestFilter) {
        this.codeRequestFilter = codeRequestFilter;
    }
}

