/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.CodeVerifierTransformer;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class AuthorizationCodeGrantHandler
extends AbstractGrantHandler {
    private CodeVerifierTransformer codeVerifierTransformer;
    private boolean expectCodeVerifierForPublicClients;

    public AuthorizationCodeGrantHandler() {
        super("authorization_code");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String clientCodeChallenge;
        String codeValue = (String)params.getFirst((Object)"code");
        ServerAuthorizationCodeGrant grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).removeCodeGrant(codeValue);
        if (grant == null) {
            return null;
        }
        if (OAuthUtils.isExpired(grant.getIssuedAt(), grant.getExpiresIn())) {
            throw new OAuthServiceException("invalid_grant");
        }
        if (!grant.getClient().getClientId().equals(client.getClientId())) {
            throw new OAuthServiceException("invalid_grant");
        }
        String expectedRedirectUri = grant.getRedirectUri();
        String providedRedirectUri = (String)params.getFirst((Object)"redirect_uri");
        if (providedRedirectUri != null ? expectedRedirectUri == null || !providedRedirectUri.equals(expectedRedirectUri) : expectedRedirectUri == null && !this.isCanSupportPublicClients() || expectedRedirectUri != null && (client.getRedirectUris().size() != 1 || !client.getRedirectUris().contains(expectedRedirectUri))) {
            throw new OAuthServiceException("invalid_request");
        }
        String clientCodeVerifier = (String)params.getFirst((Object)"code_verifier");
        if (!this.compareCodeVerifierWithChallenge(client, clientCodeVerifier, clientCodeChallenge = grant.getClientCodeChallenge())) {
            throw new OAuthServiceException("invalid_grant");
        }
        return this.doCreateAccessToken(client, grant.getSubject(), this.getSingleGrantType(), grant.getRequestedScopes(), grant.getApprovedScopes(), grant.getAudience(), clientCodeVerifier);
    }

    private boolean compareCodeVerifierWithChallenge(Client c, String clientCodeVerifier, String clientCodeChallenge) {
        if (clientCodeChallenge == null && clientCodeChallenge == null && (c.isConfidential() || !this.expectCodeVerifierForPublicClients)) {
            return true;
        }
        if (clientCodeChallenge != null && clientCodeChallenge == null || clientCodeChallenge == null && clientCodeChallenge != null) {
            return false;
        }
        String transformedCodeVerifier = this.codeVerifierTransformer == null ? clientCodeVerifier : this.codeVerifierTransformer.transformCodeVerifier(clientCodeVerifier);
        return clientCodeChallenge.equals(transformedCodeVerifier);
    }

    public void setCodeVerifierTransformer(CodeVerifierTransformer codeVerifier) {
        this.codeVerifierTransformer = codeVerifier;
    }

    public void setExpectCodeVerifierForPublicClients(boolean expectCodeVerifierForPublicClients) {
        this.expectCodeVerifierForPublicClients = expectCodeVerifierForPublicClients;
    }
}

