/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractAccessTokenValidator {
    private static final String DEFAULT_AUTH_SCHEME = "Bearer";
    protected Set<String> supportedSchemes = new HashSet<String>();
    protected String realm;
    private MessageContext mc;
    private List<AccessTokenValidator> tokenHandlers = Collections.emptyList();
    private List<String> audiences = new LinkedList<String>();
    private OAuthDataProvider dataProvider;

    public void setTokenValidator(AccessTokenValidator validator) {
        this.setTokenValidators(Collections.singletonList(validator));
    }

    public void setTokenValidators(List<AccessTokenValidator> validators) {
        this.tokenHandlers = validators;
        for (AccessTokenValidator handler : validators) {
            this.supportedSchemes.addAll(handler.getSupportedAuthorizationSchemes());
        }
    }

    public void setDataProvider(OAuthDataProvider provider) {
        this.dataProvider = provider;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public MessageContext getMessageContext() {
        return this.mc != null ? this.mc : new MessageContextImpl(PhaseInterceptorChain.getCurrentMessage());
    }

    protected AccessTokenValidator findTokenValidator(String authScheme) {
        for (AccessTokenValidator handler : this.tokenHandlers) {
            List<String> handlerSchemes = handler.getSupportedAuthorizationSchemes();
            if ((handlerSchemes.size() != 1 || !"*".equals(handlerSchemes.get(0))) && !handlerSchemes.contains(authScheme)) continue;
            return handler;
        }
        return null;
    }

    protected AccessTokenValidation getAccessTokenValidation(String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps) {
        AccessTokenValidation accessTokenV = null;
        if (this.dataProvider == null && this.tokenHandlers.isEmpty()) {
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        AccessTokenValidator handler = this.findTokenValidator(authScheme);
        if (handler != null) {
            try {
                accessTokenV = handler.validateAccessToken(this.getMessageContext(), authScheme, authSchemeData, extraProps);
            }
            catch (OAuthServiceException ex) {
                AuthorizationUtils.throwAuthorizationFailure(Collections.singleton(authScheme), this.realm);
            }
        }
        ServerAccessToken localAccessToken = null;
        if (accessTokenV == null && this.dataProvider != null && authScheme.equals(DEFAULT_AUTH_SCHEME)) {
            try {
                localAccessToken = this.dataProvider.getAccessToken(authSchemeData);
            }
            catch (OAuthServiceException oAuthServiceException) {
                // empty catch block
            }
            if (localAccessToken == null) {
                AuthorizationUtils.throwAuthorizationFailure(Collections.singleton(authScheme), this.realm);
            }
            accessTokenV = new AccessTokenValidation(localAccessToken);
        }
        if (accessTokenV == null) {
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        if (OAuthUtils.isExpired(accessTokenV.getTokenIssuedAt(), accessTokenV.getTokenLifetime())) {
            if (localAccessToken != null) {
                this.dataProvider.removeAccessToken(localAccessToken);
            }
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        if (!this.validateAudience(accessTokenV.getAudience())) {
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        return accessTokenV;
    }

    protected boolean validateAudience(String audience) {
        return OAuthUtils.validateAudience(audience, this.audiences);
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }
}

