/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.jwt;

import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.NoneJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;

public final class JwtAccessTokenUtils {
    private JwtAccessTokenUtils() {
    }

    public static ServerAccessToken encryptToAccessToken(JwtToken jwt, Client client, SecretKey key) {
        DirectKeyJweEncryption jweEncryption = JweUtils.getDirectKeyJweEncryption((SecretKey)key, (String)Algorithm.A128GCM.getJwtName());
        return JwtAccessTokenUtils.encryptToAccessToken(jwt, client, (JweEncryptionProvider)jweEncryption);
    }

    public static ServerAccessToken encryptToAccessToken(JwtToken jwt, Client client, JweEncryptionProvider jweEncryption) {
        String jwtString = new JwsJwtCompactProducer(jwt).signWith((JwsSignatureProvider)new NoneJwsSignatureProvider());
        String tokenId = jweEncryption.encrypt(JwtAccessTokenUtils.getBytes(jwtString), null);
        return JwtAccessTokenUtils.toAccessToken(jwt, client, tokenId);
    }

    private static ServerAccessToken toAccessToken(JwtToken jwt, Client client, String tokenId) {
        JwtClaims claims = jwt.getClaims();
        JwtAccessTokenUtils.validateJwtSubjectAndAudience(claims, client);
        Long issuedAt = claims.getIssuedAt();
        Long notBefore = claims.getNotBefore();
        Long expiresIn = notBefore - issuedAt;
        return new BearerAccessToken(client, tokenId, (long)issuedAt, (long)expiresIn);
    }

    public static JwtToken decryptFromfromAccessToken(String tokenId, SecretKey key) {
        DirectKeyJweDecryption jweDecryption = JweUtils.getDirectKeyJweDecryption((SecretKey)key, (String)Algorithm.A128GCM.getJwtName());
        return JwtAccessTokenUtils.decryptFromAccessToken(tokenId, (JweDecryptionProvider)jweDecryption);
    }

    public static JwtToken decryptFromAccessToken(String tokenId, JweDecryptionProvider jweDecryption) {
        String decrypted = jweDecryption.decrypt(tokenId).getContentText();
        JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(decrypted);
        return consumer.getJwtToken();
    }

    public static ServerAccessToken signToAccessToken(JwtToken jwt, Client client, RSAPrivateKey key) {
        JwsSignatureProvider jws = JwsUtils.getRSAKeySignatureProvider((RSAPrivateKey)key, (String)"RS256");
        return JwtAccessTokenUtils.signToAccessToken(jwt, client, jws);
    }

    public static ServerAccessToken signToAccessToken(JwtToken jwt, Client client, JwsSignatureProvider jws) {
        String jwtString = new JwsJwtCompactProducer(jwt).signWith(jws);
        return JwtAccessTokenUtils.toAccessToken(jwt, client, jwtString);
    }

    public static JwtToken verifyAccessToken(String tokenId, RSAPublicKey key) {
        JwsSignatureVerifier jws = JwsUtils.getRSAKeySignatureVerifier((RSAPublicKey)key, (String)"RS256");
        return JwtAccessTokenUtils.verifyAccessToken(tokenId, jws);
    }

    public static JwtToken verifyAccessToken(String tokenId, JwsSignatureVerifier jws) {
        JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(tokenId);
        if (consumer.verifySignatureWith(jws)) {
            return consumer.getJwtToken();
        }
        throw new SecurityException();
    }

    public static void validateJwtClaims(JwtClaims claims, Client c) {
        JwtAccessTokenUtils.validateJwtSubjectAndAudience(claims, c);
        JwtUtils.validateJwtTimeClaims((JwtClaims)claims);
    }

    private static void validateJwtSubjectAndAudience(JwtClaims claims, Client c) {
        if (claims.getSubject() == null || !claims.getSubject().equals(c.getClientId())) {
            throw new SecurityException("Invalid subject");
        }
        String aud = claims.getAudience();
        if (aud == null || !c.getRegisteredAudiences().isEmpty() && !c.getRegisteredAudiences().contains(aud)) {
            throw new SecurityException("Invalid audience");
        }
    }

    private static byte[] getBytes(String str) {
        return StringUtils.toBytesUTF8((String)str);
    }
}

