/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenResponseFilter;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.idp.AbstractJwsJweProducer;
import org.apache.cxf.rs.security.oidc.idp.UserInfoProvider;

public class UserInfoCodeResponseFilter
extends AbstractJwsJweProducer
implements AccessTokenResponseFilter {
    private UserInfoProvider userInfoProvider;
    private String issuer;

    public void process(ClientAccessToken ct, ServerAccessToken st) {
        IdToken token = this.userInfoProvider.getIdToken(st.getClient().getClientId(), st.getSubject(), st.getScopes());
        token.setIssuer(this.issuer);
        token.setAudience(st.getClient().getClientId());
        JwsJwtCompactProducer producer = new JwsJwtCompactProducer((JwtClaims)token);
        JwsSignatureProvider theSigProvider = this.getInitializedSigProvider(st.getClient(), true);
        String idToken = producer.signWith(theSigProvider);
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider(st.getClient(), false);
        if (theEncryptionProvider != null) {
            idToken = theEncryptionProvider.encrypt(StringUtils.toBytesUTF8((String)idToken), null);
        }
        ct.getParameters().put("id_token", idToken);
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setUserInfoProvider(UserInfoProvider userInfoProvider) {
        this.userInfoProvider = userInfoProvider;
    }
}

