/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;

public abstract class AbstractTokenValidator {
    private JweDecryptionProvider jweDecryptor;
    private JwsSignatureVerifier jwsVerifier;
    private String issuerId;
    private int issuedAtRange;
    private WebClient jwkSetClient;
    private ConcurrentHashMap<String, JsonWebKey> keyMap = new ConcurrentHashMap();

    protected JwtToken getJwtToken(String wrappedJwtToken, String clientId, String idTokenKid, boolean jweOnly) {
        if (wrappedJwtToken == null) {
            throw new SecurityException("ID Token is missing");
        }
        JweDecryptionProvider theJweDecryptor = this.getInitializedDecryptionProvider(jweOnly);
        if (theJweDecryptor != null) {
            if (jweOnly) {
                return new JweJwtCompactConsumer(wrappedJwtToken).decryptWith(this.jweDecryptor);
            }
            wrappedJwtToken = this.jweDecryptor.decrypt(wrappedJwtToken).getContentText();
        }
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(wrappedJwtToken);
        JwtToken jwt = jwtConsumer.getJwtToken();
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier(jwt, idTokenKid);
        return this.validateToken(jwtConsumer, jwt, theSigVerifier);
    }

    protected void validateJwtClaims(JwtClaims claims, String clientId, boolean validateClaimsAlways) {
        if (claims.getSubject() == null) {
            throw new SecurityException("Invalid subject");
        }
        String aud = claims.getAudience();
        if (aud == null && validateClaimsAlways || aud != null && !clientId.equals(aud)) {
            throw new SecurityException("Invalid audience");
        }
        String issuer = claims.getIssuer();
        if (issuer == null && validateClaimsAlways || issuer != null && !issuer.equals(this.issuerId)) {
            throw new SecurityException("Invalid provider");
        }
        JwtUtils.validateJwtTimeClaims((JwtClaims)claims, (int)this.issuedAtRange, (boolean)validateClaimsAlways);
    }

    protected JwtToken validateToken(JwsJwtCompactConsumer consumer, JwtToken jwt, JwsSignatureVerifier jws) {
        if (!consumer.verifySignatureWith(jws)) {
            throw new SecurityException("Invalid Signature");
        }
        return jwt;
    }

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    public void setJweVerifier(JwsSignatureVerifier theJwsVerifier) {
        this.jwsVerifier = theJwsVerifier;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public void setJwkSetClient(WebClient jwkSetClient) {
        this.jwkSetClient = jwkSetClient;
    }

    public void setIssuedAtRange(int issuedAtRange) {
        this.issuedAtRange = issuedAtRange;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(boolean jweOnly) {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        return JweUtils.loadDecryptionProvider((boolean)jweOnly);
    }

    protected JwsSignatureVerifier getInitializedSigVerifier(JwtToken jwt, String idTokenKid) {
        JsonWebKey key;
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        JwsSignatureVerifier theJwsVerifier = JwsUtils.loadSignatureVerifier((boolean)false);
        if (theJwsVerifier != null) {
            return theJwsVerifier;
        }
        if (this.jwkSetClient == null) {
            throw new SecurityException("Provider Jwk Set Client is not available");
        }
        String keyId = idTokenKid != null ? idTokenKid : jwt.getHeaders().getKeyId();
        JsonWebKey jsonWebKey = key = keyId != null ? this.keyMap.get(keyId) : null;
        if (key == null) {
            JsonWebKeys keys = (JsonWebKeys)this.jwkSetClient.get(JsonWebKeys.class);
            if (keyId != null) {
                key = keys.getKey(keyId);
            } else if (keys.getKeys().size() == 1) {
                key = (JsonWebKey)keys.getKeys().get(0);
            }
            this.keyMap.putAll(keys.getKeyIdMap());
        }
        if (key == null) {
            throw new SecurityException("JWK key with the key id: \"" + keyId + "\" is not available");
        }
        theJwsVerifier = JwsUtils.getSignatureVerifier((JsonWebKey)key);
        if (this.jwkSetClient == null) {
            throw new SecurityException();
        }
        return theJwsVerifier;
    }
}

