/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.AbstractTokenValidator;
import org.apache.cxf.rs.security.oidc.utils.OidcUtils;

public class IdTokenValidator
extends AbstractTokenValidator {
    private boolean requireAtHash = true;

    public IdToken getIdToken(ClientAccessToken at, String clientId) {
        JwtToken jwt = this.getIdJwtToken(at, clientId);
        return this.getIdTokenFromJwt(jwt, clientId);
    }

    public IdToken getIdTokenFromJwt(JwtToken jwt, String clientId) {
        return new IdToken(jwt.getClaims().asMap());
    }

    public JwtToken getIdJwtToken(ClientAccessToken at, String clientId) {
        String idJwtToken = (String)at.getParameters().get("id_token");
        JwtToken jwt = this.getJwtToken(idJwtToken, clientId, null, false);
        this.validateJwtClaims(jwt.getClaims(), clientId, true);
        OidcUtils.validateAccessTokenHash(at, jwt, this.requireAtHash);
        return jwt;
    }

    public void setRequireAtHash(boolean requireAtHash) {
        this.requireAtHash = requireAtHash;
    }
}

