/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.common;

import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oidc.common.UserAddress;

public class UserInfo
extends JwtClaims {
    public static final String NAME_CLAIM = "name";
    public static final String PROFILE_CLAIM = "profile";
    public static final String EMAIL_CLAIM = "email";
    public static final String EMAIL_VERIFIED_CLAIM = "email_verified";
    public static final String BIRTHDATE_CLAIM = "birthdate";
    public static final String PHONE_CLAIM = "phone_number";
    public static final String ADDRESS_CLAIM = "address";

    public UserInfo() {
    }

    public UserInfo(Map<String, Object> claims) {
        super(claims);
    }

    public void setName(String name) {
        this.setProperty(NAME_CLAIM, name);
    }

    public String getName() {
        return (String)this.getProperty(NAME_CLAIM);
    }

    public void setProfile(String name) {
        this.setProperty(PROFILE_CLAIM, name);
    }

    public String getProfile() {
        return (String)this.getProperty(PROFILE_CLAIM);
    }

    public void setEmail(String name) {
        this.setProperty(EMAIL_CLAIM, name);
    }

    public String getEmail() {
        return (String)this.getProperty(EMAIL_CLAIM);
    }

    public void setEmailVerified(Boolean verified) {
        this.setProperty(EMAIL_VERIFIED_CLAIM, verified);
    }

    public Boolean getEmailVerified() {
        return this.getBooleanProperty(EMAIL_VERIFIED_CLAIM);
    }

    public void setBirthDate(String date) {
        this.setProperty(BIRTHDATE_CLAIM, date);
    }

    public String getBirthdate() {
        return (String)this.getProperty(BIRTHDATE_CLAIM);
    }

    public String getPhoneNumber() {
        return (String)this.getProperty(PHONE_CLAIM);
    }

    public void setPhoneNumber(String name) {
        this.setProperty(PHONE_CLAIM, name);
    }

    public UserAddress getUserAddress() {
        Object value = this.getProperty(ADDRESS_CLAIM);
        if (value instanceof UserAddress) {
            return (UserAddress)((Object)value);
        }
        if (value instanceof Map) {
            Map map = CastUtils.cast((Map)((Map)value));
            return new UserAddress(map);
        }
        return null;
    }

    public void setUserAddressNumber(UserAddress address) {
        this.setProperty(ADDRESS_CLAIM, (Object)address);
    }
}

