/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.rs.security.saml.AbstractSamlOutInterceptor;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Element;

public class SamlFormOutInterceptor
extends AbstractSamlOutInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SamlFormOutInterceptor.class);
    private static final String SAML_ELEMENT = "SAMLToken";

    public void handleMessage(Message message) throws Fault {
        Form form = this.getRequestForm(message);
        if (form == null) {
            return;
        }
        try {
            Element samlToken = (Element)message.getContextualProperty("rs-security.saml.token.element");
            AssertionWrapper assertionWrapper = samlToken != null ? new AssertionWrapper(samlToken) : this.createAssertion(message);
            String encodedToken = this.encodeToken(assertionWrapper.assertionToString());
            this.updateForm(form, encodedToken);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    protected void updateForm(Form form, String encodedToken) {
        form.set(SAML_ELEMENT, (Object)encodedToken);
    }

    protected Form getRequestForm(Message message) {
        Object ct = message.get((Object)"Content-Type");
        if (ct == null || !"application/x-www-form-urlencoded".equalsIgnoreCase(ct.toString())) {
            return null;
        }
        MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
        if (objs != null && objs.size() == 1) {
            Object obj = objs.get(0);
            if (obj instanceof Form) {
                return (Form)obj;
            }
            if (obj instanceof MultivaluedMap) {
                return new Form((MultivaluedMap)obj);
            }
        }
        return null;
    }
}

