/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import com.wordnik.swagger.jaxrs.config.BeanConfig;
import com.wordnik.swagger.jaxrs.listing.ApiDeclarationProvider;
import com.wordnik.swagger.jaxrs.listing.ApiListingResourceJSON;
import com.wordnik.swagger.jaxrs.listing.ResourceListingProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.SetScannerInterceptor;

public class SwaggerFeature
extends AbstractFeature {
    private String resourcePackage;
    private String version = "1.0.0";
    private String basePath;
    private String title = "Sample REST Application";
    private String description = "The Application";
    private String contact = "committer@apache.org";
    private String license = "Apache 2.0 License";
    private String licenseUrl = "http://www.apache.org/licenses/LICENSE-2.0.html";
    private boolean scan = true;
    private boolean runAsFilter;

    public void initialize(Server server, Bus bus) {
        this.calculateDefaultResourcePackage(server);
        this.calculateDefaultBasePath(server);
        ApiListingResourceJSON apiListingResource = new ApiListingResourceJSON();
        if (!this.runAsFilter) {
            ArrayList<ApiListingResourceJSON> serviceBeans = new ArrayList<ApiListingResourceJSON>();
            serviceBeans.add(apiListingResource);
            ((JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName())).setResourceClassesFromBeans(serviceBeans);
        }
        ArrayList<SwaggerContainerRequestFilter> providers = new ArrayList<SwaggerContainerRequestFilter>();
        if (this.runAsFilter) {
            providers.add(new SwaggerContainerRequestFilter(apiListingResource));
        }
        providers.add((SwaggerContainerRequestFilter)new ResourceListingProvider());
        providers.add((SwaggerContainerRequestFilter)new ApiDeclarationProvider());
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setVersion(this.getVersion());
        beanConfig.setBasePath(this.getBasePath());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setScan(this.isScan());
        this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
        server.getEndpoint().getInInterceptors().add(new SetScannerInterceptor("pre-invoke", beanConfig));
    }

    private void calculateDefaultResourcePackage(Server server) {
        JAXRSServiceFactoryBean serviceFactoryBean = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        AbstractResourceInfo resourceInfo = (AbstractResourceInfo)serviceFactoryBean.getClassResourceInfo().get(0);
        if (resourceInfo != null && (this.getResourcePackage() == null || this.getResourcePackage().length() == 0)) {
            this.setResourcePackage(resourceInfo.getResourceClass().getPackage().getName());
        }
    }

    private void calculateDefaultBasePath(Server server) {
        if (this.getBasePath() == null || this.getBasePath().length() == 0) {
            String address = server.getEndpoint().getEndpointInfo().getAddress();
            this.setBasePath(address);
        }
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    public boolean isRunAsFilter() {
        return this.runAsFilter;
    }

    public void setRunAsFilter(boolean runAsFilter) {
        this.runAsFilter = runAsFilter;
    }

    @PreMatching
    private static class SwaggerContainerRequestFilter
    implements ContainerRequestFilter {
        private static final String APIDOCS_LISTING_PATH = "api-docs";
        private static final Pattern APIDOCS_RESOURCE_PATH = Pattern.compile("api-docs(/.+)");
        private ApiListingResourceJSON apiListingResource;
        @Context
        private MessageContext mc;

        public SwaggerContainerRequestFilter(ApiListingResourceJSON apiListingResource) {
            this.apiListingResource = apiListingResource;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH)) {
                Response r = this.apiListingResource.resourceListing(null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                requestContext.abortWith(r);
            } else {
                Matcher matcher = APIDOCS_RESOURCE_PATH.matcher(ui.getPath());
                if (matcher.find()) {
                    Response r = this.apiListingResource.apiDeclaration(matcher.group(1), null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                    requestContext.abortWith(r);
                }
            }
        }
    }
}

