/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import com.wordnik.swagger.jaxrs.config.BeanConfig;
import com.wordnik.swagger.jaxrs.listing.ApiDeclarationProvider;
import com.wordnik.swagger.jaxrs.listing.ApiListingResourceJSON;
import com.wordnik.swagger.jaxrs.listing.ResourceListingProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.BeanConfigWrapper;
import org.apache.cxf.jaxrs.swagger.SetScannerInterceptor;

public class SwaggerFeature
extends AbstractFeature {
    private String resourcePackage;
    private String version = "1.0.0";
    private String basePath;
    private String title = "Sample REST Application";
    private String description = "The Application";
    private String contact = "committer@apache.org";
    private String license = "Apache 2.0 License";
    private String licenseUrl = "http://www.apache.org/licenses/LICENSE-2.0.html";
    private boolean scan = true;
    private boolean runAsFilter;

    public void initialize(Server server, Bus bus) {
        this.calculateDefaultResourcePackage(server);
        this.calculateDefaultBasePath(server);
        ApiListingResourceJSON apiListingResource = new ApiListingResourceJSON();
        if (!this.runAsFilter) {
            ArrayList<ApiListingResourceJSON> serviceBeans = new ArrayList<ApiListingResourceJSON>();
            serviceBeans.add(apiListingResource);
            ((JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName())).setResourceClassesFromBeans(serviceBeans);
        }
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new ResourceListingProvider());
        providers.add(new ApiDeclarationProvider());
        BeanConfigWrapper beanConfigWrapper = new BeanConfigWrapper();
        beanConfigWrapper.setResourcePackage(this.getResourcePackage());
        beanConfigWrapper.setVersion(this.getVersion());
        beanConfigWrapper.setBasePath(this.getBasePath());
        beanConfigWrapper.setTitle(this.getTitle());
        beanConfigWrapper.setDescription(this.getDescription());
        beanConfigWrapper.setContact(this.getContact());
        beanConfigWrapper.setLicense(this.getLicense());
        beanConfigWrapper.setLicenseUrl(this.getLicenseUrl());
        beanConfigWrapper.setScan(this.isScan());
        this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
        server.getEndpoint().getInInterceptors().add(new SetScannerInterceptor("pre-invoke", beanConfigWrapper));
        if (this.runAsFilter) {
            providers.add(new SwaggerContainerRequestFilter(apiListingResource, beanConfigWrapper));
        }
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
    }

    private void calculateDefaultResourcePackage(Server server) {
        JAXRSServiceFactoryBean serviceFactoryBean = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        AbstractResourceInfo resourceInfo = (AbstractResourceInfo)serviceFactoryBean.getClassResourceInfo().get(0);
        if (resourceInfo != null && (this.getResourcePackage() == null || this.getResourcePackage().length() == 0)) {
            this.setResourcePackage(resourceInfo.getResourceClass().getPackage().getName());
        }
    }

    private void calculateDefaultBasePath(Server server) {
        if (this.getBasePath() == null || this.getBasePath().length() == 0) {
            String address = server.getEndpoint().getEndpointInfo().getAddress();
            this.setBasePath(address);
        }
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    public boolean isRunAsFilter() {
        return this.runAsFilter;
    }

    public void setRunAsFilter(boolean runAsFilter) {
        this.runAsFilter = runAsFilter;
    }

    @PreMatching
    private static class SwaggerContainerRequestFilter
    implements ContainerRequestFilter {
        private static final String APIDOCS_LISTING_PATH = "api-docs";
        private static final Pattern APIDOCS_RESOURCE_PATH = Pattern.compile("api-docs(/.+)");
        private ApiListingResourceJSON apiListingResource;
        private BeanConfigWrapper beanConfigWrapper;
        @Context
        private MessageContext mc;

        public SwaggerContainerRequestFilter(ApiListingResourceJSON apiListingResource, BeanConfigWrapper beanConfigWrapper) {
            this.apiListingResource = apiListingResource;
            this.beanConfigWrapper = beanConfigWrapper;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            BeanConfig beanConfig = new BeanConfig();
            beanConfig.setResourcePackage(this.beanConfigWrapper.getResourcePackage());
            beanConfig.setVersion(this.beanConfigWrapper.getVersion());
            beanConfig.setBasePath(this.beanConfigWrapper.getBasePath());
            beanConfig.setTitle(this.beanConfigWrapper.getTitle());
            beanConfig.setDescription(this.beanConfigWrapper.getDescription());
            beanConfig.setContact(this.beanConfigWrapper.getContact());
            beanConfig.setLicense(this.beanConfigWrapper.getLicense());
            beanConfig.setLicenseUrl(this.beanConfigWrapper.getLicenseUrl());
            beanConfig.setScan(this.beanConfigWrapper.isScan());
            this.mc.getServletContext().setAttribute("SCANNER", (Object)beanConfig);
            ServletConfig sc = this.mc.getServletConfig();
            if (sc == null) {
                sc = new ServletConfig(){

                    public String getServletName() {
                        return null;
                    }

                    public ServletContext getServletContext() {
                        return SwaggerContainerRequestFilter.this.mc.getServletContext();
                    }

                    public String getInitParameter(String name) {
                        return null;
                    }

                    public Enumeration<String> getInitParameterNames() {
                        return null;
                    }
                };
            }
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH)) {
                Response r = this.apiListingResource.resourceListing(null, sc, this.mc.getHttpHeaders(), ui);
                requestContext.abortWith(r);
            } else {
                Matcher matcher = APIDOCS_RESOURCE_PATH.matcher(ui.getPath());
                if (matcher.find()) {
                    Response r = this.apiListingResource.apiDeclaration(matcher.group(1), null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                    requestContext.abortWith(r);
                }
            }
        }
    }
}

