/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZIPInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ORIGINAL_INPUT_STREAM_KEY = GZIPInInterceptor.class.getName() + ".originalInputStream";
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(GZIPInInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(GZIPInInterceptor.class);
    private GZIPInEndingInterceptor ending = new GZIPInEndingInterceptor();

    public GZIPInInterceptor() {
        super("receive");
        this.addBefore(AttachmentInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        List contentEncoding;
        Map protocolHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (protocolHeaders != null && (contentEncoding = CastUtils.cast((List)HttpHeaderHelper.getHeader((Map)protocolHeaders, (String)"Content-Encoding"))) != null && (contentEncoding.contains("gzip") || contentEncoding.contains("x-gzip"))) {
            try {
                LOG.fine("Uncompressing response");
                InputStream is = (InputStream)message.getContent(InputStream.class);
                message.put((Object)ORIGINAL_INPUT_STREAM_KEY, (Object)is);
                GZIPInputStream zipInput = new GZIPInputStream(is);
                message.setContent(InputStream.class, (Object)zipInput);
                for (String key : protocolHeaders.keySet()) {
                    if (!key.equalsIgnoreCase("Content-Encoding")) continue;
                    protocolHeaders.remove(key);
                    break;
                }
                message.getInterceptorChain().add((Interceptor)this.ending);
            }
            catch (IOException ex) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_UNZIP", BUNDLE, new Object[0]), (Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GZIPInEndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public GZIPInEndingInterceptor() {
            super("post-invoke");
        }

        public void handleMessage(Message message) throws Fault {
            InputStream originalIn = (InputStream)message.get((Object)ORIGINAL_INPUT_STREAM_KEY);
            message.setContent(InputStream.class, (Object)originalIn);
        }
    }
}

