/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionInfo;
import org.apache.cxf.transport.https.CertificateHostnameVerifier;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;
import org.apache.cxf.transport.https.SSLUtils;

public final class HttpsURLConnectionFactory
implements HttpURLConnectionFactory {
    public static final String HTTPS_URL_PROTOCOL_ID = "https";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static boolean weblogicWarned;
    HTTPConduit conduit;
    TLSClientParameters tlsClientParameters;
    SSLSocketFactory socketFactory;

    public HttpsURLConnectionFactory(TLSClientParameters params) {
        this.tlsClientParameters = params;
        assert (this.tlsClientParameters != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection createConnection(java.net.Proxy proxy, URL url) throws IOException {
        HttpURLConnection connection;
        block8: {
            if (!url.getProtocol().equals(HTTPS_URL_PROTOCOL_ID)) {
                throw new IOException("Illegal Protocol " + url.getProtocol() + " for HTTPS URLConnection Factory.");
            }
            connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            if (this.tlsClientParameters != null) {
                Exception ex = null;
                try {
                    this.decorateWithTLS(connection);
                }
                catch (Exception e) {
                    ex = e;
                    return ex;
                }
                finally {
                    if (ex == null) break block8;
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    IOException ioException = new IOException("Error while initializing secure socket");
                    ioException.initCause(ex);
                    throw ioException;
                }
            }
        }
        return connection;
    }

    protected synchronized void decorateWithTLS(HttpURLConnection connection) throws GeneralSecurityException {
        if (this.tlsClientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
            this.socketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        } else if (this.tlsClientParameters.getSSLSocketFactory() != null) {
            this.socketFactory = this.tlsClientParameters.getSSLSocketFactory();
        } else if (this.socketFactory == null) {
            String provider = this.tlsClientParameters.getJsseProvider();
            String protocol = this.tlsClientParameters.getSecureSocketProtocol() != null ? this.tlsClientParameters.getSecureSocketProtocol() : "TLS";
            SSLContext ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            ctx.getClientSessionContext().setSessionTimeout(this.tlsClientParameters.getSslCacheTimeout());
            ctx.init(this.tlsClientParameters.getKeyManagers(), this.tlsClientParameters.getTrustManagers(), this.tlsClientParameters.getSecureRandom());
            String[] cipherSuites = SSLUtils.getCiphersuites(this.tlsClientParameters.getCipherSuites(), SSLUtils.getSupportedCipherSuites(ctx), this.tlsClientParameters.getCipherSuitesFilter(), LOG, false);
            this.socketFactory = new SSLSocketFactoryWrapper(ctx.getSocketFactory(), cipherSuites, this.tlsClientParameters.getSecureSocketProtocol());
        }
        HostnameVerifier verifier = this.tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier() ? HttpsURLConnection.getDefaultHostnameVerifier() : (this.tlsClientParameters.isDisableCNCheck() ? CertificateHostnameVerifier.ALLOW_ALL : CertificateHostnameVerifier.DEFAULT);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection conn = (HttpsURLConnection)connection;
            conn.setHostnameVerifier(verifier);
            conn.setSSLSocketFactory(this.socketFactory);
        } else {
            try {
                Method method = connection.getClass().getMethod("getHostnameVerifier", new Class[0]);
                ReflectionInvokationHandler handler = new ReflectionInvokationHandler(verifier){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        try {
                            return super.invoke(proxy, method, args);
                        }
                        catch (Exception ex) {
                            return true;
                        }
                    }
                };
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)handler);
                method = connection.getClass().getMethod("setHostnameVerifier", method.getReturnType());
                method.invoke((Object)connection, proxy);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                Method getSSLSocketFactory = connection.getClass().getMethod("getSSLSocketFactory", new Class[0]);
                Method setSSLSocketFactory = connection.getClass().getMethod("setSSLSocketFactory", getSSLSocketFactory.getReturnType());
                if (getSSLSocketFactory.getReturnType().isInstance(this.socketFactory)) {
                    setSSLSocketFactory.invoke((Object)connection, this.socketFactory);
                } else {
                    Constructor<?> c = getSSLSocketFactory.getReturnType().getDeclaredConstructor(SSLSocketFactory.class);
                    c.setAccessible(true);
                    setSSLSocketFactory.invoke((Object)connection, c.newInstance(this.socketFactory));
                }
            }
            catch (Exception ex) {
                if (connection.getClass().getName().contains("weblogic")) {
                    if (!weblogicWarned) {
                        weblogicWarned = true;
                        LOG.warning("Could not configure SSLSocketFactory on Weblogic.   Use the Weblogic control panel to configure the SSL settings.");
                    }
                    return;
                }
                throw new IllegalArgumentException("Error decorating connection class " + connection.getClass().getName(), ex);
            }
        }
    }

    protected void addLogHandler(Handler handler) {
        LOG.addHandler(handler);
    }

    public HttpURLConnectionInfo getConnectionInfo(HttpURLConnection connection) throws IOException {
        return new HttpsURLConnectionInfo(connection);
    }

    public String getProtocol() {
        return HTTPS_URL_PROTOCOL_ID;
    }
}

