/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSProviderHub;
import org.apache.cxf.transport.jms.JMSTransportBase;
import org.apache.cxf.transport.jms.PooledSession;
import org.apache.cxf.transport.jms.ServiceModelJMSConfigurationProvider;
import org.apache.cxf.transport.jms.conduit.JMSConduitConfigBean;
import org.apache.cxf.transports.jms.JMSClientBehaviorPolicyType;
import org.apache.cxf.transports.jms.context.JMSMessageHeadersType;
import org.apache.cxf.transports.jms.jms_conf.JMSClientConfig;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JMSConduit
extends JMSTransportBase
implements Conduit {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    protected JMSConduitConfigBean jmsConduitConfigBean;
    private MessageObserver incomingObserver;
    private EndpointReferenceType target;

    public JMSConduit(Bus b, EndpointInfo endpointInfo) {
        this(b, endpointInfo, null);
    }

    public JMSConduit(Bus b, EndpointInfo endpointInfo, EndpointReferenceType target) {
        super(b, endpointInfo, false);
        this.initConfig();
    }

    public String getBeanName() {
        return this.endpointInfo.getName().toString() + ".jms-conduit-base";
    }

    public void send(Message message) throws IOException {
        LOG.log(Level.FINE, "JMSConduit send message");
        try {
            if (null == this.sessionFactory) {
                JMSProviderHub.connect(this, null);
            }
        }
        catch (JMSException jmsex) {
            LOG.log(Level.WARNING, "JMS connect failed with JMSException : ", jmsex);
            throw new IOException(jmsex.toString());
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "JMS connect failed with NamingException : ", ne);
            throw new IOException(ne.toString());
        }
        if (this.sessionFactory == null) {
            throw new IllegalStateException("JMSClientTransport not connected");
        }
        try {
            boolean isOneWay = false;
            Exchange ex = message.getExchange();
            if (null != ex) {
                isOneWay = ex.isOneWay();
            }
            PooledSession pooledSession = this.sessionFactory.get(!isOneWay);
            message.put((Object)"jms.pooled.session", (Object)pooledSession);
        }
        catch (JMSException jmsex) {
            throw new IOException(jmsex.getMessage());
        }
        message.setContent(OutputStream.class, (Object)new JMSOutputStream(message));
    }

    public void close(Message message) throws IOException {
        ((OutputStream)message.getContent(OutputStream.class)).close();
    }

    public EndpointReferenceType getTarget() {
        return this.target;
    }

    public Destination getBackChannel() {
        return null;
    }

    public void close() {
        LOG.log(Level.FINE, "JMSConduit closed ");
        if (this.sessionFactory != null) {
            this.sessionFactory.shutdown();
        }
    }

    public void setMessageObserver(MessageObserver observer) {
        this.incomingObserver = observer;
        LOG.info("registering incoming observer: " + this.incomingObserver);
    }

    private Object receive(PooledSession pooledSession, Message outMessage) throws JMSException {
        Object result = null;
        long timeout = this.jmsConduitConfigBean.getClientConfig().getClientReceiveTimeout();
        Long receiveTimeout = (Long)outMessage.get((Object)"org.apache.cxf.jms.client.timeout");
        if (receiveTimeout != null) {
            timeout = receiveTimeout;
        }
        javax.jms.Message jmsMessage = pooledSession.consumer().receive(timeout);
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        if (jmsMessage != null) {
            this.populateIncomingContext(jmsMessage, outMessage, "org.apache.cxf.jms.client.response.headers");
            String messageType = jmsMessage instanceof TextMessage ? "text" : "binary";
            result = this.unmarshal(jmsMessage, messageType);
            return result;
        }
        String error = "JMSClientTransport.receive() timed out. No message available.";
        LOG.log(Level.SEVERE, error);
        throw new JMSException(error);
    }

    private void initConfig() {
        final class JMSConduitConfiguration
        extends JMSConduitConfigBean {
            JMSConduitConfiguration() {
            }

            public String getBeanName() {
                return JMSConduit.this.endpointInfo.getName().toString() + ".jms-conduit";
            }
        }
        JMSConduitConfiguration bean = new JMSConduitConfiguration();
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)bean);
        }
        if (!bean.isSetClient()) {
            bean.setClient(new JMSClientBehaviorPolicyType());
        }
        if (!bean.isSetClientConfig()) {
            bean.setClientConfig(new JMSClientConfig());
        }
        ServiceModelJMSConfigurationProvider p = new ServiceModelJMSConfigurationProvider(this.endpointInfo);
        List<ServiceModelJMSConfigurationProvider> providers = this.getOverwriteProviders();
        if (null == providers) {
            providers = new ArrayList<ServiceModelJMSConfigurationProvider>();
        }
        providers.add(p);
        this.setOverwriteProviders(providers);
        providers = bean.getOverwriteProviders();
        if (null == providers) {
            providers = new ArrayList();
        }
        providers.add(p);
        bean.setOverwriteProviders(providers);
        this.jmsConduitConfigBean = bean;
    }

    private boolean isTextPayload() {
        return "text".equals(this.jmsConduitConfigBean.getClient().getMessageType().value());
    }

    protected class DecoupledDestination
    implements Destination {
        protected MessageObserver decoupledMessageObserver;
        private EndpointReferenceType address;

        DecoupledDestination(EndpointReferenceType ref, MessageObserver incomingObserver) {
            this.address = ref;
            this.decoupledMessageObserver = incomingObserver;
        }

        public EndpointReferenceType getAddress() {
            return this.address;
        }

        public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType addr) throws IOException {
            return null;
        }

        public void shutdown() {
        }

        public synchronized void setMessageObserver(MessageObserver observer) {
            this.decoupledMessageObserver = observer;
        }

        protected synchronized MessageObserver getMessageObserver() {
            return this.decoupledMessageObserver;
        }
    }

    private class JMSOutputStream
    extends AbstractCachedOutputStream {
        private Message outMessage;
        private javax.jms.Message jmsMessage;
        private PooledSession pooledSession;
        private boolean isOneWay;

        public JMSOutputStream(Message m) {
            this.outMessage = m;
            this.pooledSession = (PooledSession)this.outMessage.get((Object)"jms.pooled.session");
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            try {
                this.isOneWay = this.outMessage.getExchange().isOneWay();
                this.commitOutputMessage();
                if (!this.isOneWay) {
                    this.handleResponse();
                }
                JMSConduit.this.sessionFactory.recycle(this.pooledSession);
            }
            catch (JMSException jmsex) {
                LOG.log(Level.WARNING, "JMS connect failed with JMSException : ", jmsex);
                throw new IOException(jmsex.toString());
            }
        }

        protected void onWrite() throws IOException {
        }

        private void commitOutputMessage() throws JMSException {
            String id;
            Object request = null;
            request = JMSConduit.this.isTextPayload() ? this.currentStream.toString() : (Object)((ByteArrayOutputStream)this.currentStream).toByteArray();
            LOG.log(Level.FINE, "Conduit Request is :[" + request + "]");
            javax.jms.Destination replyTo = this.pooledSession.destination();
            if (this.isOneWay && JMSConduit.this.getAddressPolicy().getJndiReplyDestinationName() == null) {
                replyTo = null;
            }
            this.jmsMessage = JMSConduit.this.marshal(request, this.pooledSession.session(), replyTo, JMSConduit.this.jmsConduitConfigBean.getClient().getMessageType().value());
            JMSMessageHeadersType headers = (JMSMessageHeadersType)this.outMessage.get((Object)"org.apache.cxf.jms.client.request.headers");
            int deliveryMode = JMSConduit.this.getJMSDeliveryMode(headers);
            int priority = JMSConduit.this.getJMSPriority(headers);
            String correlationID = JMSConduit.this.getCorrelationId(headers);
            long ttl = JMSConduit.this.getTimeToLive(headers);
            if (ttl <= 0L) {
                ttl = JMSConduit.this.jmsConduitConfigBean.getClientConfig().getMessageTimeToLive();
            }
            JMSConduit.this.setMessageProperties(headers, this.jmsMessage);
            if (!this.isOneWay && (id = this.pooledSession.getCorrelationID()) != null) {
                if (correlationID != null) {
                    String error = "User cannot set JMSCorrelationID when making a request/reply invocation using a static replyTo Queue.";
                    throw new JMSException(error);
                }
                correlationID = id;
            }
            if (correlationID != null) {
                this.jmsMessage.setJMSCorrelationID(correlationID);
            }
            LOG.log(Level.FINE, "client sending request: ", this.jmsMessage);
            if (JMSConduit.this.isDestinationStyleQueue()) {
                QueueSender sender = (QueueSender)this.pooledSession.producer();
                sender.setTimeToLive(ttl);
                sender.send((Queue)JMSConduit.this.targetDestination, this.jmsMessage, deliveryMode, priority, ttl);
            } else {
                TopicPublisher publisher = (TopicPublisher)this.pooledSession.producer();
                publisher.setTimeToLive(ttl);
                publisher.publish((Topic)JMSConduit.this.targetDestination, this.jmsMessage, deliveryMode, priority, ttl);
            }
        }

        private void handleResponse() throws IOException {
            Object response = null;
            MessageImpl inMessage = new MessageImpl();
            this.outMessage.getExchange().setInMessage((Message)inMessage);
            try {
                response = JMSConduit.this.receive(this.pooledSession, this.outMessage);
            }
            catch (JMSException jmsex) {
                LOG.log(Level.FINE, "JMS connect failed with JMSException : ", jmsex);
                throw new IOException(jmsex.toString());
            }
            inMessage.put((Object)"org.apache.cxf.jms.client.response.headers", this.outMessage.get((Object)"org.apache.cxf.jms.client.response.headers"));
            LOG.log(Level.FINE, "The Response Message is : [" + response + "]");
            byte[] bytes = null;
            if (response instanceof String) {
                String requestString = (String)response;
                bytes = requestString.getBytes();
            } else {
                bytes = (byte[])response;
            }
            inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes));
            LOG.log(Level.FINE, "incoming observer is " + JMSConduit.this.incomingObserver);
            JMSConduit.this.incomingObserver.onMessage((Message)inMessage);
        }
    }
}

