/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.JMSSessionFactory;
import org.apache.cxf.transport.jms.base.JMSTransportBaseConfigBean;
import org.apache.cxf.transports.jms.JMSAddressPolicyType;
import org.apache.cxf.transports.jms.context.JMSMessageHeadersType;
import org.apache.cxf.transports.jms.context.JMSPropertyType;
import org.apache.cxf.transports.jms.jms_conf.JMSSessionPoolConfigPolicy;

public class JMSTransportBase
extends JMSTransportBaseConfigBean {
    protected Destination targetDestination;
    protected Destination replyDestination;
    protected JMSSessionFactory sessionFactory;
    protected Bus bus;
    protected EndpointInfo endpointInfo;

    public JMSTransportBase(Bus b, EndpointInfo endpoint, boolean isServer) {
        this.bus = b;
        this.endpointInfo = endpoint;
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)this);
        }
        if (!this.isSetSessionPoolConfig()) {
            this.setSessionPoolConfig(new JMSSessionPoolConfigPolicy());
        }
        if (!this.isSetAddressPolicy()) {
            this.setAddressPolicy(new JMSAddressPolicyType());
        }
    }

    protected void connected(Destination target, Destination reply, JMSSessionFactory factory) {
        this.targetDestination = target;
        this.replyDestination = reply;
        this.sessionFactory = factory;
    }

    protected javax.jms.Message marshal(Object payload, Session session, Destination replyTo, String messageType) throws JMSException {
        ObjectMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else {
            message = session.createObjectMessage();
            message.setObject((Serializable)((byte[])payload));
        }
        if (replyTo != null) {
            message.setJMSReplyTo(replyTo);
        }
        return message;
    }

    protected Object unmarshal(javax.jms.Message message, String messageType) throws JMSException {
        Object ret = null;
        ret = "text".equals(messageType) ? ((TextMessage)message).getText() : (Object)((byte[])((ObjectMessage)message).getObject());
        return ret;
    }

    protected JMSMessageHeadersType populateIncomingContext(javax.jms.Message message, Message inMessage, String headerType) throws JMSException {
        JMSMessageHeadersType headers = null;
        headers = (JMSMessageHeadersType)inMessage.get((Object)headerType);
        if (headers == null) {
            headers = new JMSMessageHeadersType();
            inMessage.put((Object)headerType, (Object)headers);
        }
        headers.setJMSCorrelationID(message.getJMSCorrelationID());
        headers.setJMSDeliveryMode(new Integer(message.getJMSDeliveryMode()));
        headers.setJMSExpiration(new Long(message.getJMSExpiration()));
        headers.setJMSMessageID(message.getJMSMessageID());
        headers.setJMSPriority(new Integer(message.getJMSPriority()));
        headers.setJMSRedelivered(message.getJMSRedelivered());
        headers.setJMSTimeStamp(new Long(message.getJMSTimestamp()));
        headers.setJMSType(message.getJMSType());
        List<JMSPropertyType> props = headers.getProperty();
        Enumeration enm = message.getPropertyNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String val = message.getStringProperty(name);
            JMSPropertyType prop = new JMSPropertyType();
            prop.setName(name);
            prop.setValue(val);
            props.add(prop);
        }
        return headers;
    }

    protected int getJMSDeliveryMode(JMSMessageHeadersType headers) {
        int deliveryMode = 2;
        if (headers != null && headers.isSetJMSDeliveryMode()) {
            deliveryMode = headers.getJMSDeliveryMode();
        }
        return deliveryMode;
    }

    protected int getJMSPriority(JMSMessageHeadersType headers) {
        int priority = 4;
        if (headers != null && headers.isSetJMSPriority()) {
            priority = headers.getJMSPriority();
        }
        return priority;
    }

    protected long getTimeToLive(JMSMessageHeadersType headers) {
        long ttl = -1L;
        if (headers != null && headers.isSetTimeToLive()) {
            ttl = headers.getTimeToLive();
        }
        return ttl;
    }

    protected String getCorrelationId(JMSMessageHeadersType headers) {
        String correlationId = null;
        if (headers != null && headers.isSetJMSCorrelationID()) {
            correlationId = headers.getJMSCorrelationID();
        }
        return correlationId;
    }

    protected void setMessageProperties(JMSMessageHeadersType headers, javax.jms.Message message) throws JMSException {
        if (headers != null && headers.isSetProperty()) {
            List<JMSPropertyType> props = headers.getProperty();
            for (int x = 0; x < props.size(); ++x) {
                message.setStringProperty(props.get(x).getName(), props.get(x).getValue());
            }
        }
    }

    protected String getAddrUriFromJMSAddrPolicy() {
        JMSAddressPolicyType jmsAddressPolicy = this.getAddressPolicy();
        return "jms:" + jmsAddressPolicy.getJndiConnectionFactoryName() + "#" + jmsAddressPolicy.getJndiDestinationName();
    }

    protected String getReplyTotAddrUriFromJMSAddrPolicy() {
        JMSAddressPolicyType jmsAddressPolicy = this.getAddressPolicy();
        return "jms:" + jmsAddressPolicy.getJndiConnectionFactoryName() + "#" + jmsAddressPolicy.getJndiReplyDestinationName();
    }

    protected boolean isDestinationStyleQueue() {
        return "queue".equals(this.getAddressPolicy().getDestinationStyle().value());
    }
}

