/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.addressing.v200408.AttributedURI;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionInterceptor;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;

public class RMOutInterceptor
extends AbstractRMInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(RMOutInterceptor.class);

    public RMOutInterceptor() {
        this.addAfter(MAPAggregator.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(Message message) throws SequenceFault, RMException {
        RMProperties rmpsOut;
        if (this.isRuntimeFault(message)) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"RUNTIME_FAULT_MSG");
            return;
        }
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, true);
        if (null == maps) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"MAPS_RETRIEVAL_FAILURE_MSG");
            return;
        }
        RMContextUtils.ensureExposedVersion((AddressingProperties)maps);
        Source source = this.getManager().getSource(message);
        Destination destination = this.getManager().getDestination(message);
        String action = null;
        if (maps != null && null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        boolean isPartialResponse = MessageUtils.isPartialResponse((Message)message);
        boolean isLastMessage = RMConstants.getLastMessageAction().equals(action);
        if (isApplicationMessage && !isPartialResponse) {
            RetransmissionInterceptor ri = new RetransmissionInterceptor();
            ri.setManager(this.getManager());
            message.getInterceptorChain().add((Interceptor)ri);
            LOG.fine("Added RetransmissionInterceptor to chain.");
            this.getManager().getRetransmissionQueue().start();
        }
        if (null == (rmpsOut = RMContextUtils.retrieveRMProperties(message, true))) {
            rmpsOut = new RMProperties();
            RMContextUtils.storeRMProperties(message, rmpsOut, true);
        }
        RMProperties rmpsIn = null;
        Identifier inSeqId = null;
        BigInteger inMessageNumber = null;
        if (isApplicationMessage && null != (rmpsIn = RMContextUtils.retrieveRMProperties(message, false)) && null != rmpsIn.getSequence()) {
            inSeqId = rmpsIn.getSequence().getIdentifier();
            inMessageNumber = rmpsIn.getSequence().getMessageNumber();
        }
        if ((isApplicationMessage || isLastMessage) && !isPartialResponse) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("inbound sequence: " + (null == inSeqId ? "null" : inSeqId.getValue()));
            }
            Source source2 = source;
            synchronized (source2) {
                SourceSequence seq = null;
                if (isLastMessage) {
                    Map invocationContext = (Map)message.get((Object)"org.apache.cxf.invocation.context");
                    seq = (SourceSequence)invocationContext.get(SourceSequence.class.getName());
                } else {
                    seq = this.getManager().getSequence(inSeqId, message, (AddressingProperties)maps);
                }
                assert (null != seq);
                seq.nextMessageNumber(inSeqId, inMessageNumber, isLastMessage);
                rmpsOut.setSequence(seq);
                if (seq.isLastMessage()) {
                    source.setCurrent(null);
                }
            }
        } else if (!MessageUtils.isRequestor((Message)message) && RMConstants.getCreateSequenceAction().equals(action)) {
            maps.getAction().setValue(RMConstants.getCreateSequenceResponseAction());
        }
        if (isApplicationMessage || RMConstants.getSequenceAcknowledgmentAction().equals(action)) {
            AttributedURI to = VersionTransformer.convert((AttributedURIType)maps.getTo());
            assert (null != to);
            this.addAcknowledgements(destination, rmpsOut, inSeqId, to);
        }
        if (RMConstants.getSequenceAckAction().equals(action) || RMConstants.getTerminateSequenceAction().equals(action)) {
            maps.setReplyTo(RMUtils.createNoneReference());
        }
        this.assertReliability(message);
    }

    void addAcknowledgements(Destination destination, RMProperties rmpsOut, Identifier inSeqId, AttributedURI to) {
        for (DestinationSequence seq : destination.getAllSequences()) {
            if (!seq.sendAcknowledgement()) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("no need to add acknowledgements for sequence " + seq.getIdentifier().getValue());
                continue;
            }
            if (!to.getValue().equals(seq.getAcksTo().getAddress().getValue())) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequences acksTo address (" + seq.getAcksTo().getAddress().getValue() + ") does not match to address (" + to.getValue() + ")");
                continue;
            }
            if (RMConstants.getAnonymousAddress().equals(seq.getAcksTo().getAddress().getValue()) && !AbstractSequence.identifierEquals(seq.getIdentifier(), inSeqId)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequence identifier does not match inbound sequence identifier");
                continue;
            }
            rmpsOut.addAck(seq);
        }
        if (LOG.isLoggable(Level.FINE)) {
            Collection<SequenceAcknowledgement> acks = rmpsOut.getAcks();
            if (null == acks) {
                LOG.fine("No acknowledgements added.");
            } else {
                LOG.fine("Added " + acks.size() + " acknowledgements.");
            }
        }
    }

    boolean isRuntimeFault(Message message) {
        FaultMode mode = MessageUtils.getFaultMode((Message)message);
        if (null == mode) {
            return false;
        }
        return FaultMode.CHECKED_APPLICATION_FAULT != mode;
    }
}

