/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.v200408.EndpointReferenceType;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.CreateSequenceType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Expires;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.OfferType;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.TerminateSequenceType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy {
    private static final Logger LOG = LogUtils.getL7dLogger(Proxy.class);
    private RMEndpoint reliableEndpoint;
    private Identifier offeredIdentifier;

    public Proxy(RMEndpoint rme) {
        this.reliableEndpoint = rme;
    }

    RMEndpoint getReliableEndpoint() {
        return this.reliableEndpoint;
    }

    void acknowledge(DestinationSequence ds) throws IOException {
        if (RMConstants.getAnonymousAddress().equals(ds.getAcksTo().getAddress().getValue())) {
            LOG.log(Level.WARNING, "STANDALONE_ANON_ACKS_NOT_SUPPORTED");
            return;
        }
        OperationInfo oi = this.reliableEndpoint.getService().getServiceInfo().getInterface().getOperation(RMConstants.getSequenceAckOperationName());
        this.invoke(oi, new Object[0], null);
    }

    void terminate(SourceSequence ss) throws IOException {
        OperationInfo oi = this.reliableEndpoint.getService().getServiceInfo().getInterface().getOperation(RMConstants.getTerminateSequenceOperationName());
        TerminateSequenceType ts = RMUtils.getWSRMFactory().createTerminateSequenceType();
        ts.setIdentifier(ss.getIdentifier());
        this.invoke(oi, new Object[]{ts}, null);
    }

    void createSequenceResponse(final CreateSequenceResponseType createResponse) {
        LOG.fine("sending CreateSequenceResponse from client side");
        final OperationInfo oi = this.reliableEndpoint.getService().getServiceInfo().getInterface().getOperation(RMConstants.getCreateSequenceResponseOnewayOperationName());
        Runnable r = new Runnable(){

            public void run() {
                Proxy.this.invoke(oi, new Object[]{createResponse}, null);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public CreateSequenceResponseType createSequence(org.apache.cxf.ws.addressing.EndpointReferenceType to, EndpointReferenceType defaultAcksTo, RelatesToType relatesTo, boolean isServer) throws IOException {
        OperationInfo oi;
        SourcePolicyType sp = this.reliableEndpoint.getManager().getSourcePolicy();
        final CreateSequenceType create = RMUtils.getWSRMFactory().createCreateSequenceType();
        String address = sp.getAcksTo();
        EndpointReferenceType acksTo = null;
        acksTo = null != address ? RMUtils.createReference2004(address) : defaultAcksTo;
        create.setAcksTo(acksTo);
        Duration d = sp.getSequenceExpiration();
        if (null != d) {
            Expires expires = RMUtils.getWSRMFactory().createExpires();
            expires.setValue(d);
            create.setExpires(expires);
        }
        if (sp.isIncludeOffer()) {
            OfferType offer = RMUtils.getWSRMFactory().createOfferType();
            d = sp.getOfferedSequenceExpiration();
            if (null != d) {
                Expires expires = RMUtils.getWSRMFactory().createExpires();
                expires.setValue(d);
                offer.setExpires(expires);
            }
            offer.setIdentifier(this.reliableEndpoint.getSource().generateSequenceIdentifier());
            create.setOffer(offer);
            this.setOfferedIdentifier(offer);
        }
        InterfaceInfo ii = this.reliableEndpoint.getService().getServiceInfo().getInterface();
        OperationInfo operationInfo = oi = isServer ? ii.getOperation(RMConstants.getCreateSequenceOnewayOperationName()) : ii.getOperation(RMConstants.getCreateSequenceOperationName());
        if (isServer) {
            Runnable r = new Runnable(){

                public void run() {
                    Proxy.this.invoke(oi, new Object[]{create}, null);
                }
            };
            Thread t = new Thread(r);
            t.start();
            return null;
        }
        return (CreateSequenceResponseType)this.invoke(oi, new Object[]{create}, null);
    }

    void lastMessage(SourceSequence s) throws IOException {
    }

    Identifier getOfferedIdentifier() {
        return this.offeredIdentifier;
    }

    void setOfferedIdentifier(OfferType offer) {
        if (offer != null) {
            this.offeredIdentifier = offer.getIdentifier();
        }
    }

    Object invoke(OperationInfo oi, Object[] params, Map<String, Object> context) {
        LOG.log(Level.INFO, "Invoking out-of-band RM protocol message {0} on thread " + Thread.currentThread(), oi == null ? null : oi.getName());
        RMManager manager = this.reliableEndpoint.getManager();
        Bus bus = manager.getBus();
        Endpoint endpoint = this.reliableEndpoint.getEndpoint();
        BindingInfo bi = this.reliableEndpoint.getBindingInfo();
        RMClient client = new RMClient(bus, endpoint);
        BindingOperationInfo boi = bi.getOperation(oi);
        try {
            LOG.fine("invoking on client");
            Object[] result = client.invoke(boi, params, context);
            LOG.fine("Returned from client invocation");
            if (result != null && result.length > 0) {
                return result[0];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    class RMClient
    extends ClientImpl {
        RMClient(Bus bus, Endpoint endpoint) {
            super(bus, endpoint);
        }

        protected PhaseInterceptorChain setupInterceptorChain() {
            Endpoint originalEndpoint = this.getEndpoint();
            this.setEndpoint(Proxy.this.reliableEndpoint.getApplicationEndpoint());
            PhaseInterceptorChain chain = super.setupInterceptorChain();
            this.setEndpoint(originalEndpoint);
            return chain;
        }

        protected synchronized Conduit getConduit() {
            Conduit c = null;
            if (null != Proxy.this.reliableEndpoint.getApplicationReplyTo()) {
                String address = Proxy.this.reliableEndpoint.getApplicationReplyTo().getAddress().getValue();
                this.getEndpoint().getEndpointInfo().setAddress(address);
                c = super.getConduit();
            } else {
                Endpoint oe = this.getEndpoint();
                this.setEndpoint(Proxy.this.reliableEndpoint.getApplicationEndpoint());
                c = super.getConduit();
                this.setEndpoint(oe);
            }
            return c;
        }

        public void onMessage(Message m) {
            m.getExchange().put(Endpoint.class, (Object)Proxy.this.reliableEndpoint.getApplicationEndpoint());
            super.onMessage(m);
        }
    }
}

