/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.CreateSequenceType;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.SequenceFaultType;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.TerminateSequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMEndpoint {
    private static final QName SERVICE_NAME = new QName(RMConstants.getWsdlNamespace(), "SequenceAbstractService");
    private static final QName INTERFACE_NAME = new QName(RMConstants.getWsdlNamespace(), "SequenceAbstractPortType");
    private static final QName BINDING_NAME = new QName(RMConstants.getWsdlNamespace(), "SequenceAbstractSoapBinding");
    private static final QName PORT_NAME = new QName(RMConstants.getWsdlNamespace(), "SequenceAbstractSoapPort");
    private static final QName CREATE_PART_NAME = new QName(RMConstants.getWsdlNamespace(), "create");
    private static final QName CREATE_RESPONSE_PART_NAME = new QName(RMConstants.getWsdlNamespace(), "createResponse");
    private static final QName TERMINATE_PART_NAME = new QName(RMConstants.getWsdlNamespace(), "terminate");
    private final RMManager manager;
    private final Endpoint applicationEndpoint;
    private EndpointReferenceType applicationReplyTo;
    private Source source;
    private Destination destination;
    private Service service;
    private Endpoint endpoint;
    private Proxy proxy;
    private Servant servant;
    private boolean unwrapped;

    public RMEndpoint(RMManager m, Endpoint ae) {
        this.manager = m;
        this.applicationEndpoint = ae;
        this.source = new Source(this);
        this.destination = new Destination(this);
        this.proxy = new Proxy(this);
        this.servant = new Servant(this);
    }

    public QName getName() {
        return this.applicationEndpoint.getEndpointInfo().getName();
    }

    public RMManager getManager() {
        return this.manager;
    }

    public Endpoint getApplicationEndpoint() {
        return this.applicationEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Service getService() {
        return this.service;
    }

    public BindingInfo getBindingInfo() {
        return this.service.getServiceInfo().getBinding(BINDING_NAME);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Servant getServant() {
        return this.servant;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    EndpointReferenceType getApplicationReplyTo() {
        return this.applicationReplyTo;
    }

    void initialise(EndpointReferenceType replyTo) {
        this.applicationReplyTo = replyTo;
        this.createService();
        this.createEndpoint();
    }

    void createService() {
        ServiceInfo si = new ServiceInfo();
        si.setName(SERVICE_NAME);
        this.buildInterfaceInfo(si);
        this.buildBindingInfo(si);
        this.service = new ServiceImpl(si);
        JAXBDataBinding dataBinding = null;
        try {
            dataBinding = new JAXBDataBinding(new Class[]{CreateSequenceType.class, CreateSequenceResponseType.class, TerminateSequenceType.class, SequenceFaultType.class});
        }
        catch (JAXBException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        this.service.setDataBinding((DataBinding)dataBinding);
        this.service.setInvoker((Invoker)this.servant);
    }

    void createEndpoint() {
        ServiceInfo si = this.service.getServiceInfo();
        this.buildBindingInfo(si);
        String transportId = this.applicationEndpoint.getEndpointInfo().getTransportId();
        EndpointInfo ei = new EndpointInfo(si, transportId);
        ei.setAddress(this.applicationEndpoint.getEndpointInfo().getAddress());
        ei.setName(PORT_NAME);
        ei.setBinding(si.getBinding(BINDING_NAME));
        Object ua = this.getUsingAddressing(this.applicationEndpoint.getEndpointInfo());
        if (null != ua) {
            ei.addExtensor(ua);
        }
        si.addEndpoint(ei);
        try {
            JaxWsEndpointImpl e = new JaxWsEndpointImpl(this.manager.getBus(), this.service, ei);
            e.setOutInterceptors(this.applicationEndpoint.getOutInterceptors());
            e.setOutFaultInterceptors(this.applicationEndpoint.getOutFaultInterceptors());
            e.setInInterceptors(this.applicationEndpoint.getInInterceptors());
            e.setInFaultInterceptors(this.applicationEndpoint.getInFaultInterceptors());
            this.endpoint = e;
        }
        catch (EndpointException ex) {
            throw new RuntimeException(ex);
        }
        this.service.setExecutor(this.applicationEndpoint.getService().getExecutor());
    }

    void buildInterfaceInfo(ServiceInfo si) {
        InterfaceInfo ii = new InterfaceInfo(si, INTERFACE_NAME);
        this.buildOperationInfo(ii);
    }

    void buildOperationInfo(InterfaceInfo ii) {
        this.buildCreateSequenceOperationInfo(ii);
        this.buildTerminateSequenceOperationInfo(ii);
        this.buildSequenceAckOperationInfo(ii);
    }

    void buildCreateSequenceOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessagePartInfo partInfo = null;
        UnwrappedOperationInfo unwrappedOperationInfo = null;
        MessageInfo messageInfo = null;
        MessageInfo unwrappedMessageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getCreateSequenceOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceOperationName());
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceType.class);
        if (this.unwrapped) {
            unwrappedMessageInfo = new MessageInfo(operationInfo, messageInfo.getName());
            unwrappedOperationInfo = new UnwrappedOperationInfo(operationInfo);
            operationInfo.setUnwrappedOperation((OperationInfo)unwrappedOperationInfo);
            unwrappedOperationInfo.setInput(operationInfo.getInputName(), unwrappedMessageInfo);
            partInfo = unwrappedMessageInfo.addMessagePart("create");
            partInfo.setElementQName(RMConstants.getCreateSequenceOperationName());
            partInfo.setElement(true);
            partInfo.setTypeClass(CreateSequenceType.class);
        }
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceResponseOperationName());
        operationInfo.setOutput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceResponseOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceResponseType.class);
        partInfo.setIndex(-1);
        if (this.unwrapped) {
            unwrappedMessageInfo = new MessageInfo(operationInfo, messageInfo.getName());
            unwrappedOperationInfo.setOutput(operationInfo.getOutputName(), unwrappedMessageInfo);
            partInfo = unwrappedMessageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
            partInfo.setElementQName(RMConstants.getCreateSequenceResponseOperationName());
            partInfo.setElement(true);
            partInfo.setTypeClass(CreateSequenceResponseType.class);
        }
        operationInfo = ii.addOperation(RMConstants.getCreateSequenceOnewayOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceOperationName());
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceType.class);
        if (this.unwrapped) {
            unwrappedMessageInfo = new MessageInfo(operationInfo, messageInfo.getName());
            unwrappedOperationInfo = new UnwrappedOperationInfo(operationInfo);
            operationInfo.setUnwrappedOperation((OperationInfo)unwrappedOperationInfo);
            unwrappedOperationInfo.setInput(operationInfo.getInputName(), unwrappedMessageInfo);
            partInfo = unwrappedMessageInfo.addMessagePart(CREATE_PART_NAME);
            partInfo.setElementQName(RMConstants.getCreateSequenceOperationName());
            partInfo.setElement(true);
            partInfo.setTypeClass(CreateSequenceType.class);
        }
        operationInfo = ii.addOperation(RMConstants.getCreateSequenceResponseOnewayOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceResponseOperationName());
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceResponseOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceResponseType.class);
        if (this.unwrapped) {
            unwrappedMessageInfo = new MessageInfo(operationInfo, messageInfo.getName());
            unwrappedOperationInfo = new UnwrappedOperationInfo(operationInfo);
            operationInfo.setUnwrappedOperation((OperationInfo)unwrappedOperationInfo);
            unwrappedOperationInfo.setInput(operationInfo.getInputName(), unwrappedMessageInfo);
            partInfo = unwrappedMessageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
            partInfo.setElementQName(RMConstants.getCreateSequenceResponseOperationName());
            partInfo.setElement(true);
            partInfo.setTypeClass(CreateSequenceResponseType.class);
        }
    }

    void buildTerminateSequenceOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessagePartInfo partInfo = null;
        UnwrappedOperationInfo unwrappedOperationInfo = null;
        MessageInfo messageInfo = null;
        MessageInfo unwrappedMessageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getTerminateSequenceOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getTerminateSequenceOperationName());
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(TERMINATE_PART_NAME);
        partInfo.setElementQName(RMConstants.getTerminateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(TerminateSequenceType.class);
        if (this.unwrapped) {
            unwrappedMessageInfo = new MessageInfo(operationInfo, messageInfo.getName());
            unwrappedOperationInfo = new UnwrappedOperationInfo(operationInfo);
            operationInfo.setUnwrappedOperation((OperationInfo)unwrappedOperationInfo);
            unwrappedOperationInfo.setInput(operationInfo.getInputName(), unwrappedMessageInfo);
            partInfo = unwrappedMessageInfo.addMessagePart(TERMINATE_PART_NAME);
            partInfo.setElementQName(RMConstants.getTerminateSequenceOperationName());
            partInfo.setElement(true);
            partInfo.setTypeClass(TerminateSequenceType.class);
        }
    }

    void buildSequenceAckOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        UnwrappedOperationInfo unwrappedOperationInfo = null;
        MessageInfo messageInfo = null;
        MessageInfo unwrappedMessageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getSequenceAckOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getSequenceAckOperationName());
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        if (this.unwrapped) {
            unwrappedMessageInfo = new MessageInfo(operationInfo, messageInfo.getName());
            unwrappedOperationInfo = new UnwrappedOperationInfo(operationInfo);
            operationInfo.setUnwrappedOperation((OperationInfo)unwrappedOperationInfo);
            unwrappedOperationInfo.setInput(operationInfo.getInputName(), unwrappedMessageInfo);
        }
    }

    void buildBindingInfo(ServiceInfo si) {
        if (null != this.applicationEndpoint) {
            String bindingId = this.applicationEndpoint.getEndpointInfo().getBinding().getBindingId();
            SoapBindingInfo bi = new SoapBindingInfo(si, bindingId);
            bi.setName(BINDING_NAME);
            BindingOperationInfo boi = null;
            SoapOperationInfo soi = null;
            boi = bi.buildOperation(RMConstants.getCreateSequenceOperationName(), RMConstants.getCreateSequenceOperationName().getLocalPart(), null);
            soi = new SoapOperationInfo();
            soi.setAction(RMConstants.getCreateSequenceAction());
            boi.addExtensor((Object)soi);
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getTerminateSequenceOperationName(), RMConstants.getTerminateSequenceOperationName().getLocalPart(), null);
            soi = new SoapOperationInfo();
            soi.setAction(RMConstants.getTerminateSequenceAction());
            boi.addExtensor((Object)soi);
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getSequenceAckOperationName(), null, null);
            assert (null != boi);
            soi = new SoapOperationInfo();
            soi.setAction(RMConstants.getSequenceAckAction());
            boi.addExtensor((Object)soi);
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getCreateSequenceOnewayOperationName(), RMConstants.getCreateSequenceOperationName().getLocalPart(), null);
            soi = new SoapOperationInfo();
            soi.setAction(RMConstants.getCreateSequenceAction());
            boi.addExtensor((Object)soi);
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getCreateSequenceResponseOnewayOperationName(), RMConstants.getCreateSequenceResponseOperationName().getLocalPart(), null);
            soi = new SoapOperationInfo();
            soi.setAction(RMConstants.getCreateSequenceResponseAction());
            boi.addExtensor((Object)soi);
            bi.addOperation(boi);
            si.addBinding((BindingInfo)bi);
        }
    }

    Object getUsingAddressing(EndpointInfo endpointInfo) {
        if (null == endpointInfo) {
            return null;
        }
        Object ua = null;
        List exts = endpointInfo.getExtensors(ExtensibilityElement.class);
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        exts = endpointInfo.getBinding() != null ? endpointInfo.getBinding().getExtensors(ExtensibilityElement.class) : null;
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        exts = endpointInfo.getService() != null ? endpointInfo.getService().getExtensors(ExtensibilityElement.class) : null;
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        return ua;
    }

    Object getUsingAddressing(List<ExtensibilityElement> exts) {
        ExtensibilityElement ua = null;
        if (exts != null) {
            for (ExtensibilityElement ext : exts) {
                if (!Names.WSAW_USING_ADDRESSING_QNAME.equals(ext.getElementType())) continue;
                ua = ext;
            }
        }
        return ua;
    }
}

