/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.SequenceType;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.SourceSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMInInterceptor
extends AbstractRMInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(RMInInterceptor.class);
    private Set<String> before = Collections.singleton(MAPAggregator.class.getName());

    public Set<String> getBefore() {
        return this.before;
    }

    public Set<String> getAfter() {
        return CastUtils.cast((Set)Collections.EMPTY_SET);
    }

    public String getId() {
        return RMInInterceptor.class.getName();
    }

    @Override
    void handleMessage(Message message, boolean isFault) throws SequenceFault {
        Object originalRequestor;
        LOG.entering(this.getClass().getName(), "handleMessage");
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        message.getExchange().put(Bus.class, (Object)this.getBus());
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, false);
        assert (null != maps);
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        if (null != (originalRequestor = message.get((Object)"org.apache.cxf.client.original"))) {
            LOG.fine("Restoring original requestor role to: " + originalRequestor);
            message.put((Object)"org.apache.cxf.client", originalRequestor);
        }
        boolean isServer = RMContextUtils.isServerSide(message);
        LOG.fine("isServerSide: " + isServer);
        if (RMConstants.getCreateSequenceAction().equals(action) && !isServer) {
            LOG.fine("Processing inbound CreateSequence on client side.");
            RMEndpoint rme = this.getManager().getReliableEndpoint(message);
            Servant servant = rme.getServant();
            CreateSequenceResponseType csr = servant.createSequence(message);
            Proxy proxy = rme.getProxy();
            proxy.createSequenceResponse(csr);
            return;
        }
        if (RMConstants.getCreateSequenceAction().equals(action) || RMConstants.getCreateSequenceResponseAction().equals(action) || RMConstants.getTerminateSequenceAction().equals(action)) {
            return;
        }
        if (RMConstants.getSequenceAckAction().equals(action)) {
            this.processAcknowledgments(rmps);
            return;
        }
        Destination destination = this.getManager().getDestination(message);
        if (null != rmps) {
            this.processAcknowledgments(rmps);
            this.processAcknowledgmentRequests(rmps);
            this.processSequence(destination, rmps, (AddressingProperties)maps);
            this.processDeliveryAssurance(rmps);
        }
    }

    void processAcknowledgments(RMProperties rmps) throws SequenceFault {
        Collection<SequenceAcknowledgement> acks = rmps.getAcks();
        if (null != acks) {
            for (SequenceAcknowledgement ack : acks) {
                Identifier id = ack.getIdentifier();
                SourceSequence ss = this.getManager().getSourceSequence(id);
                if (null != ss) {
                    ss.setAcknowledged(ack);
                    continue;
                }
                throw new SequenceFaultFactory().createUnknownSequenceFault(id);
            }
        }
    }

    void processAcknowledgmentRequests(RMProperties rmps) {
    }

    void processSequence(Destination destination, RMProperties rmps, AddressingProperties maps) throws SequenceFault {
        SequenceType s = rmps.getSequence();
        if (null == s) {
            return;
        }
        destination.acknowledge(s, null == maps.getReplyTo() ? null : maps.getReplyTo().getAddress().getValue());
    }

    void processDeliveryAssurance(RMProperties rmps) {
    }
}

