/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.WrappedInInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.AckRequestedType;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultType;
import org.apache.cxf.ws.rm.SequenceType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMSoapInterceptor
extends AbstractSoapInterceptor {
    protected static JAXBContext jaxbContext;
    private static final Logger LOG;
    private static final String WS_RM_PACKAGE;

    public RMSoapInterceptor() {
        super("pre-protocol");
        this.addAfter(MAPCodec.class.getName());
    }

    public Set<QName> getUnderstoodHeaders() {
        return RMConstants.getHeaders();
    }

    public void handleMessage(SoapMessage message) throws Fault {
        this.mediate(message);
    }

    void mediate(SoapMessage message) {
        if (MessageUtils.isOutbound((Message)message)) {
            this.encode(message);
        } else {
            this.decode(message);
            this.updateServiceModelInfo(message);
        }
    }

    void encode(SoapMessage message) {
        Exception ex;
        RMProperties rmps = RMContextUtils.retrieveRMProperties((Message)message, true);
        if (null != rmps) {
            RMSoapInterceptor.encode(message, rmps);
        } else if (MessageUtils.isFault((Message)message) && (ex = (Exception)message.getContent(Exception.class)) instanceof SoapFault && ex.getCause() instanceof SequenceFault) {
            RMSoapInterceptor.encodeFault(message, (SequenceFault)ex.getCause());
        }
    }

    public static void encode(SoapMessage message, RMProperties rmps) {
        if (null == rmps) {
            return;
        }
        LOG.log(Level.FINE, "encoding RMPs in SOAP headers");
        try {
            Collection<AckRequestedType> requested;
            Collection<SequenceAcknowledgement> acks;
            List header = message.getHeaders();
            RMSoapInterceptor.discardRMHeaders(header);
            Document doc = DOMUtils.createDocument();
            Soap11 version = Soap11.getInstance();
            Element hdr = doc.createElementNS(version.getHeader().getNamespaceURI(), version.getHeader().getLocalPart());
            Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + RMConstants.getNamespacePrefix());
            attr.setValue(RMConstants.getNamespace());
            hdr.setAttributeNodeNS(attr);
            Marshaller marshaller = RMSoapInterceptor.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            SequenceType seq = rmps.getSequence();
            if (null != seq) {
                RMSoapInterceptor.encodeProperty(seq, RMConstants.getSequenceQName(), SequenceType.class, hdr, marshaller);
            }
            if (null != (acks = rmps.getAcks())) {
                for (SequenceAcknowledgement ack : acks) {
                    RMSoapInterceptor.encodeProperty(ack, RMConstants.getSequenceAckQName(), SequenceAcknowledgement.class, hdr, marshaller);
                }
            }
            if (null != (requested = rmps.getAcksRequested())) {
                for (AckRequestedType ar : requested) {
                    RMSoapInterceptor.encodeProperty(ar, RMConstants.getAckRequestedQName(), AckRequestedType.class, hdr, marshaller);
                }
            }
            for (int i = 0; i < hdr.getChildNodes().getLength(); ++i) {
                Node node = hdr.getChildNodes().item(i);
                Header holder = new Header(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node);
                header.add(holder);
            }
        }
        catch (SOAPException se) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", se);
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    public static void encodeFault(SoapMessage message, SequenceFault sf) {
        if (null == sf.getSequenceFault()) {
            return;
        }
        LOG.log(Level.FINE, "Encoding SequenceFault in SOAP header");
        try {
            List header = message.getHeaders();
            RMSoapInterceptor.discardRMHeaders(header);
            Document doc = DOMUtils.createDocument();
            SoapVersion version = message.getVersion();
            Element hdr = doc.createElementNS(version.getHeader().getNamespaceURI(), version.getHeader().getLocalPart());
            Marshaller marshaller = RMSoapInterceptor.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            RMSoapInterceptor.encodeProperty(sf.getSequenceFault(), RMConstants.getSequenceFaultQName(), SequenceFaultType.class, hdr, marshaller);
            Node node = hdr.getFirstChild();
            if (node instanceof Element) {
                Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + RMConstants.getNamespacePrefix());
                attr.setValue(RMConstants.getNamespace());
                ((Element)node).setAttributeNodeNS(attr);
            }
            header.add(new Header(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node));
        }
        catch (SOAPException se) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", se);
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    void decode(SoapMessage message) {
        RMProperties rmps = this.unmarshalRMProperties(message);
        RMContextUtils.storeRMProperties((Message)message, rmps, false);
    }

    public RMProperties unmarshalRMProperties(SoapMessage message) {
        RMProperties rmps = new RMProperties();
        try {
            ArrayList<SequenceAcknowledgement> acks = new ArrayList<SequenceAcknowledgement>();
            ArrayList<AckRequestedType> requested = new ArrayList<AckRequestedType>();
            List header = message.getHeaders();
            if (header != null) {
                Unmarshaller unmarshaller = RMSoapInterceptor.getJAXBContext().createUnmarshaller();
                Iterator iter = header.iterator();
                while (iter.hasNext()) {
                    Element elem;
                    Object node = ((Header)iter.next()).getObject();
                    if (!(node instanceof Element) || 1 != (elem = (Element)node).getNodeType()) continue;
                    String headerURI = elem.getNamespaceURI();
                    String localName = elem.getLocalName();
                    if (!RMConstants.getNamespace().equals(headerURI)) continue;
                    LOG.log(Level.FINE, "decoding RM header {0}", localName);
                    if (RMConstants.getSequenceName().equals(localName)) {
                        SequenceType s = RMSoapInterceptor.decodeProperty(SequenceType.class, elem, unmarshaller);
                        rmps.setSequence(s);
                        continue;
                    }
                    if (RMConstants.getSequenceAckName().equals(localName)) {
                        SequenceAcknowledgement ack = RMSoapInterceptor.decodeProperty(SequenceAcknowledgement.class, elem, unmarshaller);
                        acks.add(ack);
                        continue;
                    }
                    if (!RMConstants.getAckRequestedName().equals(localName)) continue;
                    AckRequestedType ar = RMSoapInterceptor.decodeProperty(AckRequestedType.class, elem, unmarshaller);
                    requested.add(ar);
                }
                if (acks.size() > 0) {
                    rmps.setAcks(acks);
                }
                if (requested.size() > 0) {
                    rmps.setAcksRequested(requested);
                }
            }
        }
        catch (JAXBException ex) {
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", ex);
        }
        return rmps;
    }

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)WS_RM_PACKAGE, (ClassLoader)SequenceAcknowledgement.class.getClassLoader());
        }
        return jaxbContext;
    }

    private static <T> void encodeProperty(T value, QName qname, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value != null) {
            LOG.log(Level.FINE, "encoding " + value + " into RM header {0}", qname);
            marshaller.marshal((Object)new JAXBElement(qname, clz, value), (Node)header);
        }
    }

    public static <T> T decodeProperty(Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        if (null == unmarshaller) {
            unmarshaller = RMSoapInterceptor.getJAXBContext().createUnmarshaller();
        }
        JAXBElement element = unmarshaller.unmarshal((Node)headerElement, clz);
        return (T)element.getValue();
    }

    private static void discardRMHeaders(List<Header> header) throws SOAPException {
        Iterator<Header> iter = header.iterator();
        while (iter.hasNext()) {
            Header hdr = iter.next();
            if (!RMConstants.getNamespace().equals(hdr.getName().getNamespaceURI())) continue;
            iter.remove();
        }
    }

    private void updateServiceModelInfo(SoapMessage message) {
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs((Message)message, false, false);
        AttributedURIType actionURI = null == maps ? null : maps.getAction();
        String action = null == actionURI ? null : actionURI.getValue().trim();
        LOG.fine("action: " + action);
        if (!(RMConstants.getCreateSequenceAction().equals(action) || RMConstants.getCreateSequenceResponseAction().equals(action) || RMConstants.getTerminateSequenceAction().equals(action) || RMConstants.getSequenceAckAction().equals(action) || RMConstants.getLastMessageAction().equals(action))) {
            return;
        }
        LOG.info("Updating service model info in exchange");
        RMManager manager = this.getManager(message);
        assert (manager != null);
        RMEndpoint rme = manager.getReliableEndpoint((Message)message);
        Exchange exchange = message.getExchange();
        exchange.put(Endpoint.class, (Object)rme.getEndpoint());
        exchange.put(Service.class, (Object)rme.getService());
        exchange.put(Binding.class, (Object)rme.getEndpoint().getBinding());
        BindingInfo bi = rme.getEndpoint().getEndpointInfo().getBinding();
        BindingOperationInfo boi = null;
        boolean isOneway = true;
        if (RMConstants.getCreateSequenceAction().equals(action)) {
            if (RMContextUtils.isServerSide((Message)message)) {
                boi = bi.getOperation(RMConstants.getCreateSequenceOperationName());
                isOneway = false;
            } else {
                boi = bi.getOperation(RMConstants.getCreateSequenceOnewayOperationName());
            }
        } else if (RMConstants.getCreateSequenceResponseAction().equals(action)) {
            if (RMContextUtils.isServerSide((Message)message)) {
                boi = bi.getOperation(RMConstants.getCreateSequenceResponseOnewayOperationName());
            } else {
                boi = bi.getOperation(RMConstants.getCreateSequenceOperationName());
                isOneway = false;
            }
        } else if (RMConstants.getSequenceAckAction().equals(action)) {
            boi = bi.getOperation(RMConstants.getSequenceAckOperationName());
        } else if (RMConstants.getTerminateSequenceAction().equals(action)) {
            boi = bi.getOperation(RMConstants.getTerminateSequenceOperationName());
        } else if (RMConstants.getLastMessageAction().equals(action)) {
            boi = bi.getOperation(RMConstants.getLastMessageOperationName());
        }
        assert (boi != null);
        exchange.put(BindingOperationInfo.class, (Object)boi);
        exchange.put(OperationInfo.class, (Object)boi.getOperationInfo());
        exchange.setOneWay(isOneway);
        if (!RMConstants.getCreateSequenceResponseAction().equals(action)) {
            LOG.fine("Changing requestor role from " + message.get((Object)"org.apache.cxf.client") + " to false");
            Object originalRequestorRole = message.get((Object)"org.apache.cxf.client");
            if (null != originalRequestorRole) {
                message.put("org.apache.cxf.client.original", originalRequestorRole);
            }
            message.put("org.apache.cxf.client", (Object)Boolean.FALSE);
        }
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator it = chain.getIterator();
        boolean bareIn = false;
        boolean wrappedIn = false;
        while (it.hasNext() && !wrappedIn && !bareIn) {
            PhaseInterceptor pi = (PhaseInterceptor)it.next();
            if (WrappedInInterceptor.class.getName().equals(pi.getId())) {
                wrappedIn = true;
                it.remove();
                LOG.fine("Removed WrappedInInterceptor from chain.");
                continue;
            }
            if (!BareInInterceptor.class.getName().equals(pi.getId())) continue;
            bareIn = true;
        }
        if (!bareIn) {
            chain.add((Interceptor)new BareInInterceptor());
            LOG.fine("Added BareInInterceptor to chain.");
        }
    }

    private RMManager getManager(SoapMessage message) {
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator it = chain.getIterator();
        while (it.hasNext()) {
            Interceptor i = (Interceptor)it.next();
            if (!(i instanceof AbstractRMInterceptor)) continue;
            return ((AbstractRMInterceptor)i).getManager();
        }
        return null;
    }

    static {
        LOG = LogUtils.getL7dLogger(RMSoapInterceptor.class);
        WS_RM_PACKAGE = PackageUtils.getPackageName(SequenceType.class);
    }
}

