/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;

public class RMMessage {
    private CachedOutputStream content;
    private long messageNumber;
    private String to;

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(long mn) {
        this.messageNumber = mn;
    }

    public byte[] getContent() {
        byte[] bytes = null;
        try {
            bytes = this.content != null ? this.content.getBytes() : null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytes;
    }

    public void setContent(byte[] c) {
        this.content = new CachedOutputStream();
        this.content.holdTempFile();
        try {
            this.content.write(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setContent(InputStream in) throws IOException {
        this.content = new CachedOutputStream();
        this.content.holdTempFile();
        IOUtils.copy((InputStream)in, (OutputStream)this.content);
    }

    public void setContent(CachedOutputStream c) {
        this.content = c;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String t) {
        this.to = t;
    }

    public InputStream getInputStream() throws IOException {
        return this.content != null ? this.content.getInputStream() : null;
    }

    public CachedOutputStream getCachedOutputStream() {
        return this.content;
    }

    public int getSize() {
        return this.content != null ? this.content.size() : -1;
    }
}

