/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.bus;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.test.TestUtilities;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BusShutdownTest
extends Assert {
    @BeforeClass
    public static void setKeepAliveProperty() {
        TestUtilities.setKeepAliveSystemProperty((boolean)false);
    }

    @AfterClass
    public static void cleanKeepAliveProperty() {
        TestUtilities.recoverKeepAliveSystemProperty();
    }

    @Test
    public void testStartWorkShutdownWork() throws Exception {
        URL wsdlUrl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        BusShutdownTest.assertNotNull((String)"wsdl resource was not found", (Object)wsdlUrl);
        String serverAddr = "http://localhost:40000/greeter/port";
        this.makeTwoWayCallOnNewBus(wsdlUrl, serverAddr);
        String workaroundHangWithDifferentAddr = serverAddr;
        this.makeTwoWayCallOnNewBus(wsdlUrl, workaroundHangWithDifferentAddr);
    }

    private void makeTwoWayCallOnNewBus(URL wsdlUrl, String address) {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus();
        SpringBusFactory.setDefaultBus((Bus)bus);
        this.createService(address);
        this.doWork(wsdlUrl, address);
        bus.shutdown(false);
    }

    private void doWork(URL wsdlUrl, String address) {
        SOAPService service = new SOAPService(wsdlUrl);
        BusShutdownTest.assertNotNull((Object)service);
        Greeter greeter = service.getSoapPort();
        InvocationHandler handler = Proxy.getInvocationHandler(greeter);
        BindingProvider bp = (BindingProvider)handler;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        greeter.sayHi();
    }

    private void createService(String address) {
        GreeterImpl impl = new GreeterImpl();
        Endpoint.publish((String)address, (Object)impl);
    }
}

