/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.clustering;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.clustering.RandomStrategy;
import org.apache.cxf.clustering.SequentialStrategy;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.greeter_control.ClusteredGreeterService;
import org.apache.cxf.greeter_control.Control;
import org.apache.cxf.greeter_control.ControlService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.systest.clustering.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FailoverTest
extends AbstractBusClientServerTestBase {
    protected static final String REPLICA_A = "http://localhost:9051/SoapContext/ReplicatedPortA";
    protected static final String REPLICA_B = "http://localhost:9052/SoapContext/ReplicatedPortB";
    protected static final String REPLICA_C = "http://localhost:9053/SoapContext/ReplicatedPortC";
    protected static final String REPLICA_D = "http://localhost:9054/SoapContext/ReplicatedPortD";
    private static final Logger LOG = LogUtils.getLogger(FailoverTest.class);
    private static final String FAILOVER_CONFIG = "org/apache/cxf/systest/clustering/failover.xml";
    private Bus bus;
    private Control control;
    private Greeter greeter;
    private List<String> targets;
    private MAPAggregator mapAggregator;
    private MAPCodec mapCodec;

    @BeforeClass
    public static void startServers() throws Exception {
        FailoverTest.assertTrue((String)"server did not launch correctly", (boolean)FailoverTest.launchServer(Server.class));
    }

    @Before
    public void setUp() {
        this.targets = new ArrayList<String>();
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus(FAILOVER_CONFIG);
        BusFactory.setDefaultBus((Bus)this.bus);
    }

    @After
    public void tearDown() {
        if (null != this.control) {
            for (String address : this.targets) {
                FailoverTest.assertTrue((String)"Failed to stop greeter", (boolean)this.control.stopGreeter(address));
            }
        }
        this.targets = null;
        if (this.bus != null) {
            this.bus.shutdown(true);
        }
    }

    @Test
    public void testNoFailoverAcrossBindings() throws Exception {
        this.startTarget(REPLICA_D);
        this.setupGreeter();
        try {
            this.greeter.greetMe("fred");
            FailoverTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            this.verifyCurrentEndpoint(REPLICA_A);
        }
    }

    @Test
    public void testRevertExceptionOnUnsucessfulFailover() throws Exception {
        this.startTarget(REPLICA_B);
        this.startTarget(REPLICA_C);
        this.setupGreeter();
        this.stopTarget(REPLICA_C);
        this.stopTarget(REPLICA_B);
        try {
            this.greeter.greetMe("fred");
            FailoverTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            FailoverTest.assertTrue((String)("should revert to original exception when no failover: " + cause), (boolean)(cause instanceof ConnectException));
            this.verifyCurrentEndpoint(REPLICA_A);
        }
    }

    @Test
    public void testInitialFailoverOnPrimaryReplicaUnavailable() throws Exception {
        this.startTarget(REPLICA_C);
        this.setupGreeter();
        String response = null;
        response = this.greeter.greetMe("fred");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        this.verifyCurrentEndpoint(REPLICA_C);
        response = this.greeter.greetMe("joe");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
    }

    @Test
    public void testNoFailoverOnApplicationFault() throws Exception {
        this.startTarget(REPLICA_C);
        this.setupGreeter();
        this.greeter.pingMe();
        this.verifyCurrentEndpoint(REPLICA_C);
        this.startTarget(REPLICA_B);
        try {
            this.greeter.pingMe();
        }
        catch (PingMeFault pmf) {
            this.verifyCurrentEndpoint(REPLICA_C);
        }
    }

    @Test
    public void testFailoverOnCurrentReplicaDeath() throws Exception {
        this.startTarget(REPLICA_C);
        this.setupGreeter();
        String response = null;
        response = this.greeter.greetMe("fred");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        this.verifyCurrentEndpoint(REPLICA_C);
        this.startTarget(REPLICA_B);
        this.stopTarget(REPLICA_C);
        response = this.greeter.greetMe("joe");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_B));
        this.verifyCurrentEndpoint(REPLICA_B);
    }

    @Test
    public void testNoFailbackWhileCurrentReplicaLive() throws Exception {
        this.startTarget(REPLICA_C);
        this.setupGreeter();
        String response = null;
        response = this.greeter.greetMe("fred");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        this.verifyCurrentEndpoint(REPLICA_C);
        this.startTarget(REPLICA_A);
        response = this.greeter.greetMe("joe");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        this.verifyCurrentEndpoint(REPLICA_C);
        this.startTarget(REPLICA_B);
        response = this.greeter.greetMe("bob");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        this.verifyCurrentEndpoint(REPLICA_C);
        this.stopTarget(REPLICA_B);
        response = this.greeter.greetMe("john");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        this.verifyCurrentEndpoint(REPLICA_C);
        this.stopTarget(REPLICA_A);
        response = this.greeter.greetMe("mike");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        this.verifyCurrentEndpoint(REPLICA_C);
    }

    @Test
    public void testEndpointSpecificInterceptorsDoNotPersistAcrossFailover() throws Exception {
        this.startTarget(REPLICA_A);
        this.setupGreeter();
        String response = null;
        this.enableWSAForCurrentEndpoint();
        response = this.greeter.greetMe("fred");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_A));
        FailoverTest.assertTrue((String)"response expected to include WS-A messageID", (response.indexOf("message: urn:uuid") != -1 ? 1 : 0) != 0);
        this.verifyCurrentEndpoint(REPLICA_A);
        FailoverTest.assertTrue((String)"expected WSA enabled for current endpoint", (boolean)this.isWSAEnabledForCurrentEndpoint());
        this.stopTarget(REPLICA_A);
        this.startTarget(REPLICA_C);
        response = this.greeter.greetMe("mike");
        FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
        FailoverTest.assertTrue((String)("response from unexpected target: " + response), (boolean)response.endsWith(REPLICA_C));
        FailoverTest.assertTrue((String)"response not expected to include WS-A messageID", (response.indexOf("message: urn:uuid") == -1 ? 1 : 0) != 0);
        this.verifyCurrentEndpoint(REPLICA_C);
        FailoverTest.assertFalse((String)"unexpected WSA enabled for current endpoint", (boolean)this.isWSAEnabledForCurrentEndpoint());
    }

    @Test
    public void testDefaultSequentialStrategy() throws Exception {
        this.strategyTest(REPLICA_B, REPLICA_C, REPLICA_A, false);
    }

    @Test
    public void testExplicitSequentialStrategy() throws Exception {
        this.strategyTest(REPLICA_A, REPLICA_C, REPLICA_B, false);
    }

    @Test
    public void testRandomStrategy() throws Exception {
        this.strategyTest(REPLICA_A, REPLICA_B, REPLICA_C, true);
    }

    private void strategyTest(String activeReplica1, String activeReplica2, String inactiveReplica, boolean expectRandom) {
        this.startTarget(activeReplica1);
        this.startTarget(activeReplica2);
        boolean randomized = false;
        String prevEndpoint = null;
        for (int i = 0; i < 20; ++i) {
            Greeter g = REPLICA_A.equals(inactiveReplica) ? new ClusteredGreeterService().getReplicatedPortA() : (REPLICA_B.equals(inactiveReplica) ? new ClusteredGreeterService().getReplicatedPortB() : new ClusteredGreeterService().getReplicatedPortC());
            this.verifyStrategy(g, expectRandom ? RandomStrategy.class : SequentialStrategy.class);
            String response = g.greetMe("fred");
            FailoverTest.assertNotNull((String)"expected non-null response", (Object)response);
            String currEndpoint = this.getCurrentEndpoint(g);
            if (prevEndpoint != null && !currEndpoint.equals(prevEndpoint)) {
                randomized = true;
            }
            prevEndpoint = currEndpoint;
        }
        this.stopTarget(activeReplica1);
        this.stopTarget(activeReplica2);
        FailoverTest.assertEquals((String)"unexpected random/sequential distribution of failovers", (Object)expectRandom, (Object)randomized);
    }

    private void startTarget(String address) {
        ControlService cs = new ControlService();
        this.control = cs.getControlPort();
        LOG.info("starting replicated target: " + address);
        FailoverTest.assertTrue((String)"Failed to start greeter", (boolean)this.control.startGreeter(address));
        this.targets.add(address);
    }

    private void stopTarget(String address) {
        if (this.control != null && this.targets.contains(address)) {
            LOG.info("starting replicated target: " + address);
            FailoverTest.assertTrue((String)"Failed to start greeter", (boolean)this.control.stopGreeter(address));
            this.targets.remove(address);
        }
    }

    private void verifyCurrentEndpoint(String replica) {
        FailoverTest.assertEquals((String)"unexpected current endpoint", (Object)replica, (Object)this.getCurrentEndpoint(this.greeter));
    }

    private String getCurrentEndpoint(Object proxy) {
        return ClientProxy.getClient((Object)proxy).getEndpoint().getEndpointInfo().getAddress();
    }

    private void setupGreeter() {
        ClusteredGreeterService cs = new ClusteredGreeterService();
        this.greeter = cs.getReplicatedPortA();
        FailoverTest.assertTrue((String)"unexpected conduit slector", (boolean)(ClientProxy.getClient((Object)this.greeter).getConduitSelector() instanceof FailoverTargetSelector));
    }

    private void verifyStrategy(Object proxy, Class clz) {
        ConduitSelector conduitSelector = ClientProxy.getClient((Object)proxy).getConduitSelector();
        if (conduitSelector instanceof FailoverTargetSelector) {
            FailoverStrategy strategy = ((FailoverTargetSelector)conduitSelector).getStrategy();
            FailoverTest.assertTrue((String)"unexpected strategy", (boolean)clz.isInstance(strategy));
        } else {
            FailoverTest.fail((String)("unexpected conduit selector: " + conduitSelector));
        }
    }

    protected void enableWSAForCurrentEndpoint() {
        Endpoint provider = ClientProxy.getClient((Object)this.greeter).getEndpoint();
        this.mapAggregator = new MAPAggregator();
        this.mapCodec = new MAPCodec();
        provider.getInInterceptors().add(this.mapAggregator);
        provider.getInInterceptors().add(this.mapCodec);
        provider.getOutInterceptors().add(this.mapAggregator);
        provider.getOutInterceptors().add(this.mapCodec);
        provider.getInFaultInterceptors().add(this.mapAggregator);
        provider.getInFaultInterceptors().add(this.mapCodec);
        provider.getOutFaultInterceptors().add(this.mapAggregator);
        provider.getOutFaultInterceptors().add(this.mapCodec);
    }

    protected boolean isWSAEnabledForCurrentEndpoint() {
        Endpoint provider = ClientProxy.getClient((Object)this.greeter).getEndpoint();
        boolean enabledIn = provider.getInInterceptors().contains(this.mapAggregator) && provider.getInInterceptors().contains(this.mapCodec) && provider.getInFaultInterceptors().contains(this.mapAggregator) && provider.getInFaultInterceptors().contains(this.mapCodec);
        boolean enabledOut = provider.getOutInterceptors().contains(this.mapAggregator) && provider.getOutInterceptors().contains(this.mapCodec) && provider.getOutFaultInterceptors().contains(this.mapAggregator) && provider.getOutFaultInterceptors().contains(this.mapCodec);
        return enabledIn && enabledOut;
    }
}

