/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.systest.handlers.TestHandlerBase;
import org.apache.handlers.types.AddNumbers;
import org.apache.handlers.types.AddNumbersResponse;
import org.apache.handlers.types.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallNumberHandler
extends TestHandlerBase
implements LogicalHandler<LogicalMessageContext> {
    @Resource(name="handlerResource")
    String injectedString;

    public SmallNumberHandler() {
        this(true);
    }

    public SmallNumberHandler(boolean serverSide) {
        super(serverSide);
    }

    @Override
    public String getHandlerId() {
        return "SmallNumberHandler" + this.getId();
    }

    public final boolean handleMessage(LogicalMessageContext messageContext) {
        try {
            boolean outbound = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outbound) {
                JAXBContext jaxbContext;
                LogicalMessage msg = messageContext.getMessage();
                Object payload = msg.getPayload(jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class}));
                if (payload instanceof JAXBElement) {
                    payload = ((JAXBElement)payload).getValue();
                }
                if (payload instanceof AddNumbers) {
                    AddNumbers req = (AddNumbers)payload;
                    int a = req.getArg0();
                    int b = req.getArg1();
                    if (this.isSmall(a) && this.isSmall(b)) {
                        AddNumbersResponse resp2;
                        int answer = a + b;
                        AddNumbersResponse resp = new AddNumbersResponse();
                        resp.setReturn(answer);
                        msg.setPayload((Object)new ObjectFactory().createAddNumbersResponse(resp), jaxbContext);
                        Source src = msg.getPayload();
                        msg.setPayload(src);
                        payload = msg.getPayload(jaxbContext);
                        if (payload instanceof JAXBElement) {
                            payload = ((JAXBElement)payload).getValue();
                        }
                        if ((resp2 = (AddNumbersResponse)payload) == resp) {
                            throw new WebServiceException("Shouldn't be the same object");
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        catch (JAXBException ex) {
            throw new ProtocolException((Throwable)ex);
        }
    }

    public final boolean handleFault(LogicalMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext ctx) {
    }

    public void init(Map config) {
    }

    public void destroy() {
    }

    @PostConstruct
    public void doPostConstruct() {
        this.methodCalled("doPostConstruct");
    }

    public String getInjectedString() {
        return this.injectedString;
    }

    private boolean isSmall(int i) {
        return i > 0 && i <= 10;
    }
}

