/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.systest.handlers.TestHandlerBase;
import org.apache.handler_test.PingException;
import org.apache.handler_test.types.Ping;
import org.apache.handler_test.types.PingResponse;
import org.apache.handler_test.types.PingWithArgs;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHandler<T extends LogicalMessageContext>
extends TestHandlerBase
implements LogicalHandler<T> {
    private final JAXBContext jaxbCtx;

    public TestHandler() {
        this(true);
    }

    public TestHandler(boolean serverSide) {
        super(serverSide);
        try {
            this.jaxbCtx = JAXBContext.newInstance((String)PackageUtils.getPackageName(Ping.class));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getHandlerId() {
        return "handler" + this.getId();
    }

    public boolean handleMessage(T ctx) {
        this.methodCalled("handleMessage");
        this.printHandlerInfo("handleMessage", this.isOutbound((MessageContext)ctx));
        boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
        boolean ret = this.getHandleMessageRet();
        if (!this.isServerSideHandler()) {
            return true;
        }
        try {
            this.verifyJAXWSProperties((MessageContext)ctx);
        }
        catch (PingException e) {
            e.printStackTrace();
            throw new ProtocolException((Throwable)e);
        }
        Object obj = ctx.getMessage().getPayload(this.jaxbCtx);
        if (obj instanceof Ping || obj instanceof PingResponse) {
            ret = this.handlePingMessage(outbound, ctx);
        } else if (obj instanceof PingWithArgs) {
            ret = this.handlePingWithArgsMessage(outbound, ctx);
        }
        return ret;
    }

    private boolean handlePingWithArgsMessage(boolean outbound, T ctx) {
        LogicalMessage msg = ctx.getMessage();
        Object payload = msg.getPayload(this.jaxbCtx);
        this.addHandlerId(ctx.getMessage(), ctx, outbound);
        boolean ret = true;
        if (payload instanceof PingWithArgs) {
            String arg = ((PingWithArgs)payload).getHandlersCommand();
            StringTokenizer strtok = new StringTokenizer(arg, " ");
            String hid = "";
            String direction = "";
            String command = "";
            if (strtok.countTokens() >= 3) {
                hid = strtok.nextToken();
                direction = strtok.nextToken();
                command = strtok.nextToken();
            }
            if (!this.getHandlerId().equals(hid)) {
                return true;
            }
            if ("stop".equals(command)) {
                if (!outbound && "inbound".equals(direction)) {
                    PingResponse resp = new PingResponse();
                    resp.getHandlersInfo().addAll(this.getHandlerInfoList((MessageContext)ctx));
                    msg.setPayload((Object)resp, this.jaxbCtx);
                    ret = false;
                } else if (outbound && "outbound".equals(direction)) {
                    ret = false;
                }
            } else if ("throw".equals(command)) {
                String exceptionType = null;
                String exceptionText = "HandleMessage throws exception";
                if (strtok.hasMoreTokens()) {
                    exceptionType = strtok.nextToken();
                }
                if (strtok.hasMoreTokens()) {
                    exceptionText = strtok.nextToken();
                }
                if (exceptionType != null && !outbound && "inbound".equals(direction)) {
                    if ("RuntimeException".equals(exceptionType)) {
                        throw new RuntimeException(exceptionText);
                    }
                    if ("ProtocolException".equals(exceptionType)) {
                        throw new ProtocolException(exceptionText);
                    }
                } else if (exceptionType != null && outbound && "outbound".equals(direction)) {
                    if ("RuntimeException".equals(exceptionType)) {
                        throw new RuntimeException(exceptionText);
                    }
                    if ("ProtocolException".equals(exceptionType)) {
                        throw new ProtocolException(exceptionText);
                    }
                }
            }
        }
        return ret;
    }

    private boolean handlePingMessage(boolean outbound, T ctx) {
        LogicalMessage msg = ctx.getMessage();
        this.addHandlerId(msg, ctx, outbound);
        return this.getHandleMessageRet();
    }

    private void addHandlerId(LogicalMessage msg, T ctx, boolean outbound) {
        Object obj = msg.getPayload(this.jaxbCtx);
        if (obj instanceof PingResponse) {
            PingResponse origResp = (PingResponse)obj;
            PingResponse newResp = new PingResponse();
            newResp.getHandlersInfo().addAll(origResp.getHandlersInfo());
            newResp.getHandlersInfo().add(this.getHandlerId());
            msg.setPayload((Object)newResp, this.jaxbCtx);
        } else if (obj instanceof Ping || obj instanceof PingWithArgs) {
            this.getHandlerInfoList((MessageContext)ctx).add(this.getHandlerId());
        }
    }

    public boolean handleFault(T ctx) {
        this.methodCalled("handleFault");
        this.printHandlerInfo("handleFault", this.isOutbound((MessageContext)ctx));
        if (this.isServerSideHandler()) {
            if (!"handler2".equals(this.getHandlerId())) {
                return true;
            }
            DOMSource source = (DOMSource)ctx.getMessage().getPayload();
            Node node = source.getNode();
            HashMap<String, String> ns = new HashMap<String, String>();
            ns.put("s", "http://schemas.xmlsoap.org/soap/envelope/");
            XPathUtils xu = new XPathUtils(ns);
            String exceptionText = (String)xu.getValue("//s:Fault/faultstring/text()", node, XPathConstants.STRING);
            if ("handler2HandleFaultThrowsRunException".equals(exceptionText)) {
                throw new RuntimeException("handler2 HandleFault throws RuntimeException");
            }
            if ("handler2HandleFaultThrowsSOAPFaultException".equals(exceptionText)) {
                throw this.createSOAPFaultException("handler2 HandleFault throws SOAPFaultException");
            }
        }
        return true;
    }

    private SOAPFaultException createSOAPFaultException(String faultString) {
        try {
            SOAPFault fault = SOAPFactory.newInstance().createFault();
            fault.setFaultString(faultString);
            fault.setFaultCode(new QName("http://cxf.apache.org/faultcode", "Server"));
            return new SOAPFaultException(fault);
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }

    public void close(MessageContext arg0) {
        this.methodCalled("close");
    }

    public void init(Map arg0) {
        this.methodCalled("init");
    }

    public void destroy() {
        this.methodCalled("destroy");
    }

    public String toString() {
        return this.getHandlerId();
    }
}

