/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.handler_test.PingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestHandlerBase {
    private static final Logger LOG = LogUtils.getLogger(TestHandlerBase.class);
    private static int sid;
    private static int sinvokedOrder;
    private boolean handleMessageRet = true;
    private int invokeOrderOfHandleMessage;
    private int invokeOrderOfHandleFault;
    private int invokeOrderOfClose;
    private Map<String, Integer> methodCallCount = new HashMap<String, Integer>();
    private final int id = ++sid;
    private final boolean isServerSideHandler;

    public TestHandlerBase(boolean serverSide) {
        this.isServerSideHandler = serverSide;
    }

    protected void methodCalled(String methodName) {
        int val = 0;
        if (this.methodCallCount.keySet().contains(methodName)) {
            val = this.methodCallCount.get(methodName);
        }
        if ("handleMessage".equals(methodName)) {
            this.invokeOrderOfHandleMessage = ++sinvokedOrder;
        } else if ("handleFault".equals(methodName)) {
            this.invokeOrderOfHandleFault = ++sinvokedOrder;
        } else if ("close".equals(methodName)) {
            this.invokeOrderOfClose = ++sinvokedOrder;
        }
        this.methodCallCount.put(methodName, ++val);
    }

    public int getInvokeOrderOfHandleMessage() {
        return this.invokeOrderOfHandleMessage;
    }

    public int getInvokeOrderOfHandleFault() {
        return this.invokeOrderOfHandleFault;
    }

    public int getInvokeOrderOfClose() {
        return this.invokeOrderOfClose;
    }

    public int getId() {
        return this.id;
    }

    public abstract String getHandlerId();

    public boolean isCloseInvoked() {
        return this.methodCallCount.containsKey("close");
    }

    public boolean isDestroyInvoked() {
        return this.methodCallCount.containsKey("destroy");
    }

    public boolean isHandleFaultInvoked() {
        return this.methodCallCount.containsKey("handleFault");
    }

    public int getHandleFaultInvoked() {
        return this.getMethodCallCount("handleFault");
    }

    public int getCloseInvoked() {
        return this.getMethodCallCount("close");
    }

    public boolean isHandleMessageInvoked() {
        return this.methodCallCount.containsKey("handleMessage");
    }

    public int getHandleMessageInvoked() {
        return this.getMethodCallCount("handleMessage");
    }

    public boolean isInitInvoked() {
        return this.methodCallCount.containsKey("init");
    }

    public boolean isPostConstructInvoked() {
        return this.methodCallCount.containsKey("doPostConstruct");
    }

    public void setHandleMessageRet(boolean ret) {
        this.handleMessageRet = ret;
    }

    public boolean getHandleMessageRet() {
        return this.handleMessageRet;
    }

    public boolean isServerSideHandler() {
        return this.isServerSideHandler;
    }

    public void verifyJAXWSProperties(MessageContext ctx) throws PingException {
        if (!this.isServerSideHandler() || this.isOutbound(ctx)) {
            // empty if block
        }
    }

    protected void printHandlerInfo(String methodName, boolean outbound) {
        String info = this.getHandlerId() + " " + (outbound ? "outbound" : "inbound") + " " + methodName + "   " + Thread.currentThread().getName();
        LOG.info(info);
    }

    protected List<String> getHandlerInfoList(MessageContext ctx) {
        ArrayList<String> handlerInfoList = null;
        if (ctx.containsKey((Object)"handler.info")) {
            handlerInfoList = CastUtils.cast((List)((List)ctx.get((Object)"handler.info")));
        } else {
            handlerInfoList = new ArrayList();
            ctx.put((Object)"handler.info", handlerInfoList);
            ctx.setScope("handler.info", MessageContext.Scope.APPLICATION);
        }
        return handlerInfoList;
    }

    protected boolean isOutbound(MessageContext ctx) {
        return (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
    }

    private int getMethodCallCount(String methodName) {
        int ret = 0;
        if (this.methodCallCount.containsKey(methodName)) {
            ret = this.methodCallCount.get(methodName);
        }
        return ret;
    }
}

