/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import javax.xml.ws.http.HTTPException;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.systest.jaxws.ServerXMLBinding;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.headers.HeaderTester;
import org.apache.headers.XMLHeaderService;
import org.apache.headers.types.InHeader;
import org.apache.headers.types.InHeaderResponse;
import org.apache.headers.types.InoutHeader;
import org.apache.headers.types.InoutHeaderResponse;
import org.apache.headers.types.OutHeader;
import org.apache.headers.types.OutHeaderResponse;
import org.apache.headers.types.SOAPHeaderData;
import org.apache.hello_world_xml_http.bare.types.MyComplexStructType;
import org.apache.hello_world_xml_http.mixed.Greeter;
import org.apache.hello_world_xml_http.mixed.XMLService;
import org.apache.hello_world_xml_http.mixed.types.SayHi;
import org.apache.hello_world_xml_http.mixed.types.SayHiResponse;
import org.apache.hello_world_xml_http.wrapped.PingMeFault;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ClientServerXMLTest
extends AbstractBusClientServerTestBase {
    private final QName barePortName = new QName("http://apache.org/hello_world_xml_http/bare", "XMLPort");
    private final QName wrapServiceName = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLService");
    private final QName mixedServiceName = new QName("http://apache.org/hello_world_xml_http/mixed", "XMLService");
    private final QName wrapPortName = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLPort");
    private final QName mixedPortName = new QName("http://apache.org/hello_world_xml_http/mixed", "XMLPort");
    private final QName wrapFakePortName = new QName("http://apache.org/hello_world_xml_http/wrapped", "FakePort");

    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerXMLTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerXMLTest.launchServer(ServerXMLBinding.class));
    }

    @Test
    public void testBareBasicConnection() throws Exception {
        org.apache.hello_world_xml_http.bare.XMLService service = new org.apache.hello_world_xml_http.bare.XMLService();
        ClientServerXMLTest.assertNotNull((Object)service);
        String response1 = "Hello ";
        String response2 = "Bonjour";
        try {
            org.apache.hello_world_xml_http.bare.Greeter greeter = (org.apache.hello_world_xml_http.bare.Greeter)service.getPort(this.barePortName, org.apache.hello_world_xml_http.bare.Greeter.class);
            String username = System.getProperty("user.name");
            String reply = greeter.greetMe(username);
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerXMLTest.assertEquals((Object)(response1 + username), (Object)reply);
            reply = greeter.sayHi();
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerXMLTest.assertEquals((Object)response2, (Object)reply);
            MyComplexStructType argument = new MyComplexStructType();
            MyComplexStructType retVal = null;
            String str1 = "this is element 1";
            String str2 = "this is element 2";
            int int1 = 42;
            argument.setElem1(str1);
            argument.setElem2(str2);
            argument.setElem3(int1);
            retVal = greeter.sendReceiveData(argument);
            ClientServerXMLTest.assertEquals((Object)str1, (Object)retVal.getElem1());
            ClientServerXMLTest.assertEquals((Object)str2, (Object)retVal.getElem2());
            ClientServerXMLTest.assertEquals((Object)int1, (Object)retVal.getElem3());
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testBareGetGreetMe() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9031/XMLService/XMLPort/greetMe/requestType/cxf");
        httpConnection.connect();
        ClientServerXMLTest.assertEquals((Object)200, (Object)httpConnection.getResponseCode());
        ClientServerXMLTest.assertEquals((Object)"text/xml; charset=utf-8", (Object)httpConnection.getContentType());
        ClientServerXMLTest.assertEquals((Object)"OK", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getInputStream();
        ClientServerXMLTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        ClientServerXMLTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("ns2", "http://apache.org/hello_world_xml_http/bare/types");
        XPathUtils xu = new XPathUtils(ns);
        String response = (String)xu.getValue("//ns2:responseType/text()", (Node)doc, XPathConstants.STRING);
        ClientServerXMLTest.assertEquals((Object)"Hello cxf", (Object)response);
    }

    @Test
    public void testWrapBasicConnection() throws Exception {
        org.apache.hello_world_xml_http.wrapped.XMLService service = new org.apache.hello_world_xml_http.wrapped.XMLService(((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_xml_wrapped.wsdl"), this.wrapServiceName);
        ClientServerXMLTest.assertNotNull((Object)service);
        String response1 = new String("Hello ");
        String response2 = new String("Bonjour");
        try {
            org.apache.hello_world_xml_http.wrapped.Greeter greeter = (org.apache.hello_world_xml_http.wrapped.Greeter)service.getPort(this.wrapPortName, org.apache.hello_world_xml_http.wrapped.Greeter.class);
            String username = System.getProperty("user.name");
            String reply = greeter.greetMe(username);
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerXMLTest.assertEquals((Object)(response1 + username), (Object)reply);
            reply = greeter.sayHi();
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerXMLTest.assertEquals((Object)response2, (Object)reply);
            greeter.greetMeOneWay(System.getProperty("user.name"));
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testMixedConnection() throws Exception {
        XMLService service = new XMLService(((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_xml_mixed.wsdl"), this.mixedServiceName);
        ClientServerXMLTest.assertNotNull((Object)service);
        String response1 = new String("Hello ");
        String response2 = new String("Bonjour");
        try {
            Greeter greeter = (Greeter)service.getPort(this.mixedPortName, Greeter.class);
            String username = System.getProperty("user.name");
            String reply = greeter.greetMe(username);
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerXMLTest.assertEquals((Object)(response1 + username), (Object)reply);
            SayHi request = new SayHi();
            SayHiResponse response = greeter.sayHi1(request);
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)response);
            ClientServerXMLTest.assertEquals((Object)response2, (Object)response.getResponseType());
            greeter.greetMeOneWay(System.getProperty("user.name"));
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testAddPort() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_xml_wrapped.wsdl");
        Service service = Service.create((URL)url, (QName)this.wrapServiceName);
        ClientServerXMLTest.assertNotNull((Object)service);
        service.addPort(this.wrapFakePortName, "http://cxf.apache.org/bindings/xformat", "http://localhost:9032/XMLService/XMLPort");
        String response1 = new String("Hello ");
        String response2 = new String("Bonjour");
        org.apache.hello_world_xml_http.wrapped.Greeter greeter = (org.apache.hello_world_xml_http.wrapped.Greeter)service.getPort(this.wrapPortName, org.apache.hello_world_xml_http.wrapped.Greeter.class);
        try {
            String username = System.getProperty("user.name");
            String reply = greeter.greetMe(username);
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerXMLTest.assertEquals((Object)(response1 + username), (Object)reply);
            reply = greeter.sayHi();
            ClientServerXMLTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerXMLTest.assertEquals((Object)response2, (Object)reply);
            BindingProvider bp = (BindingProvider)greeter;
            Map responseContext = bp.getResponseContext();
            Integer responseCode = (Integer)responseContext.get(Message.RESPONSE_CODE);
            ClientServerXMLTest.assertEquals((Object)200, (Object)responseCode);
            greeter.greetMeOneWay(System.getProperty("user.name"));
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testXMLFault() throws Exception {
        org.apache.hello_world_xml_http.wrapped.XMLService service = new org.apache.hello_world_xml_http.wrapped.XMLService(((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_xml_wrapped.wsdl"), this.wrapServiceName);
        ClientServerXMLTest.assertNotNull((Object)service);
        org.apache.hello_world_xml_http.wrapped.Greeter greeter = (org.apache.hello_world_xml_http.wrapped.Greeter)service.getPort(this.wrapPortName, org.apache.hello_world_xml_http.wrapped.Greeter.class);
        try {
            greeter.pingMe();
            ClientServerXMLTest.fail((String)"did not catch expected PingMeFault exception");
        }
        catch (PingMeFault ex) {
            ClientServerXMLTest.assertEquals((String)"minor value", (Object)1, (Object)ex.getFaultInfo().getMinor());
            ClientServerXMLTest.assertEquals((String)"major value", (Object)2, (Object)ex.getFaultInfo().getMajor());
            BindingProvider bp = (BindingProvider)greeter;
            Map responseContext = bp.getResponseContext();
            String contentType = (String)responseContext.get("Content-Type");
            ClientServerXMLTest.assertEquals((Object)"text/xml; charset=utf-8", (Object)contentType);
            Integer responseCode = (Integer)responseContext.get(Message.RESPONSE_CODE);
            ClientServerXMLTest.assertEquals((Object)500, (Object)responseCode);
        }
        org.apache.hello_world_xml_http.wrapped.Greeter greeterFault = service.getXMLFaultPort();
        try {
            greeterFault.pingMe();
            ClientServerXMLTest.fail((String)"did not catch expected runtime exception");
        }
        catch (HTTPException ex) {
            ClientServerXMLTest.assertTrue((String)"check expected message of exception", (ex.getCause().getMessage().indexOf("test throw out runtime exception") >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testXMLBindingOfSoapHeaderWSDL() throws Exception {
        XMLHeaderService service = new XMLHeaderService();
        HeaderTester port = service.getXMLPort9000();
        try {
            this.verifyInHeader(port);
            this.verifyInOutHeader(port);
            this.verifyOutHeader(port);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public void verifyInHeader(HeaderTester proxy) throws Exception {
        InHeader me = new InHeader();
        me.setRequestType("InHeaderRequest");
        SOAPHeaderData headerInfo = new SOAPHeaderData();
        headerInfo.setMessage("message");
        headerInfo.setOriginator("originator");
        InHeaderResponse resp = proxy.inHeader(me, headerInfo);
        ClientServerXMLTest.assertNotNull((Object)resp);
        ClientServerXMLTest.assertEquals((String)"check returned response type", (Object)"requestType=InHeaderRequest\nheaderData.message=message\nheaderData.getOriginator=originator", (Object)resp.getResponseType());
    }

    public void verifyInOutHeader(HeaderTester proxy) throws Exception {
        InoutHeader me = new InoutHeader();
        me.setRequestType("InoutHeaderRequest");
        SOAPHeaderData headerInfo = new SOAPHeaderData();
        headerInfo.setMessage("inoutMessage");
        headerInfo.setOriginator("inoutOriginator");
        Holder holder = new Holder();
        holder.value = headerInfo;
        InoutHeaderResponse resp = proxy.inoutHeader(me, holder);
        ClientServerXMLTest.assertNotNull((Object)resp);
        ClientServerXMLTest.assertEquals((String)"check return value", (Object)"requestType=InoutHeaderRequest", (Object)resp.getResponseType());
        ClientServerXMLTest.assertEquals((String)"check inout value", (Object)"message=inoutMessage", (Object)((SOAPHeaderData)holder.value).getMessage());
        ClientServerXMLTest.assertEquals((String)"check inout value", (Object)"orginator=inoutOriginator", (Object)((SOAPHeaderData)holder.value).getOriginator());
    }

    public void verifyOutHeader(HeaderTester proxy) throws Exception {
        OutHeader me = new OutHeader();
        me.setRequestType("OutHeaderRequest");
        Holder outHeaderHolder = new Holder();
        Holder soapHeaderHolder = new Holder();
        proxy.outHeader(me, outHeaderHolder, soapHeaderHolder);
        ClientServerXMLTest.assertNotNull((Object)outHeaderHolder.value);
        ClientServerXMLTest.assertNotNull((Object)soapHeaderHolder.value);
        ClientServerXMLTest.assertEquals((String)"check out value", (Object)"requestType=OutHeaderRequest", (Object)((OutHeaderResponse)outHeaderHolder.value).getResponseType());
        ClientServerXMLTest.assertEquals((String)"check out value", (Object)"message=outMessage", (Object)((SOAPHeaderData)soapHeaderHolder.value).getMessage());
        ClientServerXMLTest.assertEquals((String)"check out value", (Object)"orginator=outOriginator", (Object)((SOAPHeaderData)soapHeaderHolder.value).getOriginator());
    }
}

