/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.util.concurrent.Executor;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Response;
import org.apache.cxf.greeter_control.AbstractGreeterImpl;
import org.apache.cxf.greeter_control.BasicGreeterService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JaxwsExecutorTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JaxwsExecutorTest.assertTrue((String)"server did not launch correctly", (boolean)JaxwsExecutorTest.launchServer(Server.class));
    }

    @Test
    public void testUseCustomExecutorOnClient() throws Exception {
        BasicGreeterService service = new BasicGreeterService();
        class CustomExecutor
        implements Executor {
            private int count;

            CustomExecutor() {
            }

            public void execute(Runnable command) {
                ++this.count;
                command.run();
            }

            public int getCount() {
                return this.count;
            }
        }
        CustomExecutor executor = new CustomExecutor();
        service.setExecutor((Executor)executor);
        JaxwsExecutorTest.assertSame((Object)executor, (Object)service.getExecutor());
        Greeter proxy = service.getGreeterPort();
        JaxwsExecutorTest.assertEquals((Object)0, (Object)executor.getCount());
        Response response = proxy.greetMeAsync("cxf");
        for (int waitCount = 0; !response.isDone() && waitCount < 10; ++waitCount) {
            Thread.sleep(100L);
        }
        JaxwsExecutorTest.assertTrue((String)"Response still not received.", (boolean)response.isDone());
        JaxwsExecutorTest.assertEquals((Object)1, (Object)executor.getCount());
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            Endpoint.publish((String)address, (Object)((Object)implementor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }

        @WebService(serviceName="BasicGreeterService", portName="GreeterPort", endpointInterface="org.apache.cxf.greeter_control.Greeter", targetNamespace="http://cxf.apache.org/greeter_control", wsdlLocation="testutils/greeter_control.wsdl")
        public class GreeterImpl
        extends AbstractGreeterImpl {
        }
    }
}

