/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.io.InputStream;
import java.net.URL;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.helpers.IOUtils;
import org.apache.hello_world.Greeter;
import org.apache.hello_world.GreeterImpl;
import org.apache.hello_world.services.SOAPService;
import org.junit.Assert;
import org.junit.Test;

public class OASISCatalogTest
extends Assert {
    private final QName serviceName = new QName("http://apache.org/hello_world/services", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world/services", "SoapPort");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWSDLPublishWithCatalogs() throws Exception {
        Endpoint ep = Endpoint.publish(null, (Object)new GreeterImpl());
        try {
            URL url = new URL("http://localhost:9000/SoapContext/SoapPort?xsd=testutils/hello_world_schema2.xsd");
            OASISCatalogTest.assertNotNull((Object)url.getContent());
            url = new URL("http://localhost:9000/SoapContext/SoapPort?xsd=testutils/hello_world_schema.xsd");
            String result = IOUtils.toString((InputStream)((InputStream)url.getContent()));
            OASISCatalogTest.assertTrue((boolean)result.contains("xsd=testutils/hello_world_schema2.xsd"));
            url = new URL("http://localhost:9000/SoapContext/SoapPort?wsdl=testutils/hello_world_messages_catalog.wsdl");
            result = IOUtils.toString((InputStream)((InputStream)url.getContent()));
            OASISCatalogTest.assertTrue((boolean)result.contains("xsd=testutils/hello_world_schema.xsd"));
        }
        finally {
            ep.stop();
        }
    }

    @Test
    public void testClientWithDefaultCatalog() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/catalog/hello_world_services.wsdl");
        OASISCatalogTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        OASISCatalogTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        OASISCatalogTest.assertNotNull((Object)greeter);
    }

    @Test
    public void testClientWithoutCatalog() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/catalog/hello_world_services.wsdl");
        OASISCatalogTest.assertNotNull((Object)wsdl);
        Bus bus = BusFactory.getDefaultBus();
        OASISCatalogManager catalog = new OASISCatalogManager();
        bus.setExtension((Object)catalog, OASISCatalogManager.class);
        try {
            SOAPService service = new SOAPService(wsdl, this.serviceName);
            service.getPort(this.portName, Greeter.class);
            OASISCatalogTest.fail((String)"Test did not fail as expected");
        }
        catch (WebServiceException e) {
            // empty catch block
        }
        URL jaxwscatalog = ((Object)((Object)this)).getClass().getResource("/META-INF/jax-ws-catalog.xml");
        OASISCatalogTest.assertNotNull((Object)jaxwscatalog);
        catalog.loadCatalog(jaxwscatalog);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        OASISCatalogTest.assertNotNull((Object)greeter);
    }

    @Test
    public void testWSDLLocatorWithDefaultCatalog() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/catalog/hello_world_services.wsdl");
        OASISCatalogTest.assertNotNull((Object)wsdl);
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        CatalogWSDLLocator wsdlLocator = new CatalogWSDLLocator(wsdl.toString(), OASISCatalogManager.getCatalogManager(null));
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.readWSDL((WSDLLocator)wsdlLocator);
    }

    @Test
    public void testWSDLLocatorWithoutCatalog() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/catalog/hello_world_services.wsdl");
        OASISCatalogTest.assertNotNull((Object)wsdl);
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        OASISCatalogManager catalog = new OASISCatalogManager();
        CatalogWSDLLocator wsdlLocator = new CatalogWSDLLocator(wsdl.toString(), catalog);
        try {
            wsdlReader.readWSDL((WSDLLocator)wsdlLocator);
            OASISCatalogTest.fail((String)"Test did not fail as expected");
        }
        catch (WSDLException e) {
            // empty catch block
        }
    }
}

