/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.js;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.cxf.systest.js.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.SOAPService;
import org.apache.hello_world_soap_http.SOAPServiceTest1;
import org.junit.BeforeClass;
import org.junit.Test;

public class JSClientServerTest
extends AbstractBusClientServerTestBase {
    private static final String NS = "http://apache.org/hello_world_soap_http";

    @BeforeClass
    public static void startServers() throws Exception {
        JSClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JSClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testJSMessageMode() throws Exception {
        QName serviceName = new QName(NS, "SOAPService");
        QName portName = new QName(NS, "SoapPort");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        JSClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, serviceName);
        JSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("TestGreetMeResponse");
        String response2 = new String("TestSayHiResponse");
        try {
            Greeter greeter = (Greeter)service.getPort(portName, Greeter.class);
            String greeting = greeter.greetMe("TestGreetMeRequest");
            JSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
            JSClientServerTest.assertEquals((Object)response1, (Object)greeting);
            String reply = greeter.sayHi();
            JSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
            JSClientServerTest.assertEquals((Object)response2, (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            ex.printStackTrace();
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testJSPayloadMode() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        JSClientServerTest.assertNotNull((Object)wsdl);
        QName serviceName = new QName(NS, "SOAPService_Test1");
        QName portName = new QName(NS, "SoapPort_Test1");
        SOAPServiceTest1 service = new SOAPServiceTest1(wsdl, serviceName);
        JSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("TestGreetMeResponse");
        String response2 = new String("TestSayHiResponse");
        try {
            Greeter greeter = (Greeter)service.getPort(portName, Greeter.class);
            String greeting = greeter.greetMe("TestGreetMeRequest");
            JSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
            JSClientServerTest.assertEquals((Object)response1, (Object)greeting);
            String reply = greeter.sayHi();
            JSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
            JSClientServerTest.assertEquals((Object)response2, (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            ex.printStackTrace();
            throw (Exception)ex.getCause();
        }
    }
}

