/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.systest.provider.AttachmentServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttachmentProviderXMLClientServerTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        AttachmentProviderXMLClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)AttachmentProviderXMLClientServerTest.launchServer(AttachmentServer.class, (boolean)true));
    }

    @Test
    @Ignore(value="REVISIT: I do not think it is valid to use Provider to receive a StreamSource with attachement")
    public void testRequestWithAttachment() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL("http://localhost:9033/XMLServiceAttachment").openConnection();
        connection.setRequestMethod("POST");
        String ct = "multipart/related; type=\"text/xml\"; start=\"rootPart\"; boundary=\"----=_Part_4_701508.1145579811786\"";
        connection.addRequestProperty("Content-Type", ct);
        connection.setDoOutput(true);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("attachmentData");
        IOUtils.copy((InputStream)is, (OutputStream)connection.getOutputStream());
        connection.getOutputStream().close();
        is.close();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        AttachmentProviderXMLClientServerTest.assertEquals((String)"wrong content type", (Object)"application/xml+custom", (Object)connection.getContentType());
        Document result = builder.parse(connection.getInputStream());
        AttachmentProviderXMLClientServerTest.assertNotNull((String)"result must not be null", (Object)result);
        connection.getInputStream().close();
        NodeList resList = result.getDocumentElement().getElementsByTagName("att");
        AttachmentProviderXMLClientServerTest.assertEquals((String)"Two attachments must've been encoded", (Object)2, (Object)resList.getLength());
        this.verifyAttachment(resList, "foo", "foobar");
        this.verifyAttachment(resList, "bar", "barbaz");
    }

    private void verifyAttachment(NodeList atts, String contentId, String value) {
        for (int i = 0; i < atts.getLength(); ++i) {
            Element expElem = (Element)atts.item(i);
            String child = expElem.getFirstChild().getNodeValue();
            String contentIdVal = expElem.getAttribute("contentId");
            if (!contentId.equals(contentIdVal) || !Base64Utility.encode((byte[])value.getBytes()).equals(child) && !Base64Utility.encode((byte[])(value + "\n").getBytes()).equals(child)) continue;
            return;
        }
        AttachmentProviderXMLClientServerTest.fail((String)("No encoded attachment with id " + contentId + " found"));
    }
}

