/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.annotation.Resource;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(serviceName="AttachmentStreamSourceXMLProvider")
@ServiceMode(value=Service.Mode.PAYLOAD)
@BindingType(value="http://cxf.apache.org/bindings/xformat")
public class AttachmentStreamSourceXMLProvider
implements Provider<StreamSource> {
    @Resource
    protected WebServiceContext wsContext;

    public StreamSource invoke(StreamSource source) {
        MessageContext mc = this.wsContext.getMessageContext();
        String httpMethod = (String)mc.get((Object)"javax.xml.ws.http.request.method");
        if ("POST".equals(httpMethod)) {
            int count = 0;
            DOMResult result = new DOMResult();
            try {
                Transformer transformer = XMLUtils.newTransformer();
                transformer.transform(source, result);
                count = Integer.parseInt(((Document)result.getNode()).getDocumentElement().getAttribute("count"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            Map dataHandlers = CastUtils.cast((Map)((Map)mc.get((Object)"javax.xml.ws.binding.attachments.inbound")));
            StringBuilder buf = new StringBuilder();
            buf.append("<response>");
            int i = 0;
            for (Map.Entry entry : dataHandlers.entrySet()) {
                if (i++ > count) break;
                try {
                    InputStream is = ((DataHandler)entry.getValue()).getInputStream();
                    ByteArrayOutputStream bous = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)bous);
                    buf.append("<att contentId=\"" + (String)entry.getKey() + "\">");
                    buf.append(Base64Utility.encode((byte[])bous.toByteArray()));
                    buf.append("</att>");
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            buf.append("</response>");
            HashMap respHeaders = CastUtils.cast((Map)((Map)mc.get((Object)"javax.xml.ws.http.response.headers")));
            if (respHeaders == null) {
                respHeaders = new HashMap();
                mc.put((Object)"javax.xml.ws.http.response.headers", respHeaders);
            }
            ArrayList<String> contentTypeValues = new ArrayList<String>();
            contentTypeValues.add("application/xml+custom");
            respHeaders.put("Content-Type", contentTypeValues);
            return new StreamSource(new StringReader(buf.toString()));
        }
        return source;
    }
}

