/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(portName="SoapPortProviderRPCLit3", serviceName="SOAPServiceProviderRPCLit", targetNamespace="http://apache.org/hello_world_rpclit", wsdlLocation="/wsdl/hello_world_rpc_lit.wsdl")
public class HWDOMSourcePayloadProvider
implements Provider<DOMSource> {
    private static QName sayHi = new QName("http://apache.org/hello_world_rpclit", "sayHi");
    private static QName greetMe = new QName("http://apache.org/hello_world_rpclit", "greetMe");
    private SOAPMessage sayHiResponse;
    private SOAPMessage greetMeResponse;
    private MessageFactory factory;

    public HWDOMSourcePayloadProvider() {
        try {
            this.factory = MessageFactory.newInstance();
            InputStream is = this.getClass().getResourceAsStream("resources/sayHiRpcLiteralResp.xml");
            this.sayHiResponse = this.factory.createMessage(null, is);
            is.close();
            is = this.getClass().getResourceAsStream("resources/GreetMeRpcLiteralResp.xml");
            this.greetMeResponse = this.factory.createMessage(null, is);
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DOMSource invoke(DOMSource request) {
        DOMSource response = new DOMSource();
        try {
            Node n = request.getNode();
            if (n.getLocalName().equals(sayHi.getLocalPart())) {
                response.setNode(this.sayHiResponse.getSOAPBody().extractContentAsDocument());
            } else if (n.getLocalName().equals(greetMe.getLocalPart())) {
                response.setNode(this.greetMeResponse.getSOAPBody().extractContentAsDocument());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

