/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(portName="SoapProviderPort", serviceName="SOAPProviderService", targetNamespace="http://apache.org/hello_world_soap_http", wsdlLocation="/wsdl/hello_world.wsdl")
@ServiceMode(value=Service.Mode.MESSAGE)
public class HWSoapMessageDocProvider
implements Provider<SOAPMessage> {
    private static QName sayHi = new QName("http://apache.org/hello_world_soap_http", "sayHi");
    private static QName greetMe = new QName("http://apache.org/hello_world_soap_http", "greetMe");
    private SOAPMessage sayHiResponse;
    private SOAPMessage greetMeResponse;

    public HWSoapMessageDocProvider() {
        try {
            MessageFactory factory = MessageFactory.newInstance();
            InputStream is = this.getClass().getResourceAsStream("resources/sayHiDocLiteralResp.xml");
            this.sayHiResponse = factory.createMessage(null, is);
            is.close();
            is = this.getClass().getResourceAsStream("resources/GreetMeDocLiteralResp.xml");
            this.greetMeResponse = factory.createMessage(null, is);
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SOAPMessage invoke(SOAPMessage request) {
        SOAPMessage response = null;
        try {
            SOAPBody body = request.getSOAPBody();
            Node n = body.getFirstChild();
            while (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            if (n.getLocalName().equals(sayHi.getLocalPart())) {
                response = this.sayHiResponse;
            } else if (n.getLocalName().equals(greetMe.getLocalPart())) {
                response = this.greetMeResponse;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

