/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.systest.provider.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_rpclit.GreeterRPCLit;
import org.apache.hello_world_rpclit.SOAPServiceRPCLit;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProviderRPCClientServerTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        ProviderRPCClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)ProviderRPCClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testSWA() throws Exception {
        SOAPFactory soapFac = SOAPFactory.newInstance();
        MessageFactory msgFac = MessageFactory.newInstance();
        SOAPConnectionFactory conFac = SOAPConnectionFactory.newInstance();
        SOAPMessage msg = msgFac.createMessage();
        QName sayHi = new QName("http://apache.org/hello_world_rpclit", "sayHiWAttach");
        msg.getSOAPBody().addChildElement(soapFac.createElement(sayHi));
        AttachmentPart ap1 = msg.createAttachmentPart();
        ap1.setContent((Object)"Attachment content", "text/plain");
        msg.addAttachmentPart(ap1);
        AttachmentPart ap2 = msg.createAttachmentPart();
        ap2.setContent((Object)"Attachment content - Part 2", "text/plain");
        msg.addAttachmentPart(ap2);
        SOAPConnection con = conFac.createConnection();
        URL endpoint = new URL("http://localhost:9008/SOAPServiceProviderRPCLit/SoapPortProviderRPCLit1");
        SOAPMessage response = con.call(msg, (Object)endpoint);
        QName sayHiResp = new QName("http://apache.org/hello_world_rpclit", "sayHiResponse");
        ProviderRPCClientServerTest.assertNotNull((Object)response.getSOAPBody().getChildElements(sayHiResp));
        ProviderRPCClientServerTest.assertEquals((Object)2, (Object)response.countAttachments());
    }

    private void doGreeterRPCLit(SOAPServiceRPCLit service, QName portName, int count) throws Exception {
        String response1 = new String("TestGreetMeResponse");
        String response2 = new String("TestSayHiResponse");
        try {
            GreeterRPCLit greeter = (GreeterRPCLit)service.getPort(portName, GreeterRPCLit.class);
            for (int idx = 0; idx < count; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                ProviderRPCClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                ProviderRPCClientServerTest.assertEquals((Object)response1, (Object)greeting);
                String reply = greeter.sayHi();
                ProviderRPCClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                ProviderRPCClientServerTest.assertEquals((Object)response2, (Object)reply);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testSOAPMessageModeRPC() throws Exception {
        QName serviceName = new QName("http://apache.org/hello_world_rpclit", "SOAPServiceProviderRPCLit");
        QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortProviderRPCLit1");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_rpc_lit.wsdl");
        ProviderRPCClientServerTest.assertNotNull((Object)wsdl);
        SOAPServiceRPCLit service = new SOAPServiceRPCLit(wsdl, serviceName);
        ProviderRPCClientServerTest.assertNotNull((Object)service);
        this.doGreeterRPCLit(service, portName, 2);
    }

    @Test
    public void testSOAPMessageModeWithDOMSourceData() throws Exception {
        QName serviceName = new QName("http://apache.org/hello_world_rpclit", "SOAPServiceProviderRPCLit");
        QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortProviderRPCLit2");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_rpc_lit.wsdl");
        ProviderRPCClientServerTest.assertNotNull((Object)wsdl);
        SOAPServiceRPCLit service = new SOAPServiceRPCLit(wsdl, serviceName);
        ProviderRPCClientServerTest.assertNotNull((Object)service);
        this.doGreeterRPCLit(service, portName, 2);
    }

    @Test
    public void testPayloadModeWithDOMSourceData() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_rpc_lit.wsdl");
        ProviderRPCClientServerTest.assertNotNull((Object)wsdl);
        QName serviceName = new QName("http://apache.org/hello_world_rpclit", "SOAPServiceProviderRPCLit");
        QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortProviderRPCLit3");
        SOAPServiceRPCLit service = new SOAPServiceRPCLit(wsdl, serviceName);
        ProviderRPCClientServerTest.assertNotNull((Object)service);
        this.doGreeterRPCLit(service, portName, 1);
    }

    @Test
    public void testPayloadModeWithSourceData() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_rpc_lit.wsdl");
        ProviderRPCClientServerTest.assertNotNull((Object)wsdl);
        QName serviceName = new QName("http://apache.org/hello_world_rpclit", "SOAPServiceProviderRPCLit");
        QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortProviderRPCLit8");
        SOAPServiceRPCLit service = new SOAPServiceRPCLit(wsdl, serviceName);
        ProviderRPCClientServerTest.assertNotNull((Object)service);
        String response1 = new String("TestGreetMeResponseServerLogicalHandlerServerSOAPHandler");
        try {
            GreeterRPCLit greeter = (GreeterRPCLit)service.getPort(portName, GreeterRPCLit.class);
            String greeting = greeter.greetMe("Milestone-0");
            ProviderRPCClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ProviderRPCClientServerTest.assertEquals((Object)response1, (Object)greeting);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testMessageModeWithSAXSourceData() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_rpc_lit.wsdl");
        ProviderRPCClientServerTest.assertNotNull((Object)wsdl);
        QName serviceName = new QName("http://apache.org/hello_world_rpclit", "SOAPServiceProviderRPCLit");
        QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortProviderRPCLit4");
        SOAPServiceRPCLit service = new SOAPServiceRPCLit(wsdl, serviceName);
        ProviderRPCClientServerTest.assertNotNull((Object)service);
        this.doGreeterRPCLit(service, portName, 1);
    }

    @Test
    public void testMessageModeWithStreamSourceData() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_rpc_lit.wsdl");
        ProviderRPCClientServerTest.assertNotNull((Object)wsdl);
        QName serviceName = new QName("http://apache.org/hello_world_rpclit", "SOAPServiceProviderRPCLit");
        QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortProviderRPCLit5");
        SOAPServiceRPCLit service = new SOAPServiceRPCLit(wsdl, serviceName);
        ProviderRPCClientServerTest.assertNotNull((Object)service);
        this.doGreeterRPCLit(service, portName, 1);
    }

    @Test
    public void testPayloadModeWithSAXSourceData() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_rpc_lit.wsdl");
        ProviderRPCClientServerTest.assertNotNull((Object)wsdl);
        QName serviceName = new QName("http://apache.org/hello_world_rpclit", "SOAPServiceProviderRPCLit");
        QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortProviderRPCLit6");
        SOAPServiceRPCLit service = new SOAPServiceRPCLit(wsdl, serviceName);
        ProviderRPCClientServerTest.assertNotNull((Object)service);
        this.doGreeterRPCLit(service, portName, 1);
    }
}

