/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.systest.provider.XMLServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_xml_http.wrapped.XMLService;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ProviderXMLClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLService");
    private final QName portName = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLProviderPort");

    @BeforeClass
    public static void startServers() throws Exception {
        ProviderXMLClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)ProviderXMLClientServerTest.launchServer(XMLServer.class));
    }

    @Test
    public void testDOMSourcePAYLOAD() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_xml_wrapped.wsdl");
        ProviderXMLClientServerTest.assertNotNull((Object)wsdl);
        XMLService service = new XMLService(wsdl, this.serviceName);
        ProviderXMLClientServerTest.assertNotNull((Object)service);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/messages/XML_GreetMeDocLiteralReq.xml");
        Document doc = XMLUtils.parse((InputStream)is);
        DOMSource reqMsg = new DOMSource(doc);
        ProviderXMLClientServerTest.assertNotNull((Object)reqMsg);
        Dispatch disp = service.createDispatch(this.portName, DOMSource.class, Service.Mode.PAYLOAD);
        DOMSource result = (DOMSource)disp.invoke((Object)reqMsg);
        ProviderXMLClientServerTest.assertNotNull((Object)result);
        Node respDoc = result.getNode();
        ProviderXMLClientServerTest.assertEquals((Object)"greetMeResponse", (Object)respDoc.getFirstChild().getLocalName());
        ProviderXMLClientServerTest.assertEquals((Object)"TestXMLBindingProviderMessage", (Object)respDoc.getFirstChild().getTextContent());
    }
}

