/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider.datasource;

import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.systest.provider.datasource.WebProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProvider<T>
implements WebProvider {
    static final Logger LOG = LogUtils.getLogger(AbstractProvider.class);
    protected WebServiceContext wsContext;

    public T invoke(T req) {
        MessageContext mc = this.wsContext.getMessageContext();
        String method = (String)mc.get((Object)"javax.xml.ws.http.request.method");
        LOG.info("method: " + method);
        T ret = null;
        if ("GET".equalsIgnoreCase(method)) {
            ret = this.get(req);
        } else if ("POST".equalsIgnoreCase(method)) {
            ret = this.post(req);
        }
        return ret;
    }

    protected T get(T req) {
        return req;
    }

    @Override
    public WebServiceContext getWebServiceContext() {
        return this.wsContext;
    }

    protected T post(T req) {
        return req;
    }

    @Override
    public void publish(String url) {
        Endpoint ep = Endpoint.create((String)"http://www.w3.org/2004/08/wsdl/http", (Object)this);
        ep.publish(url);
    }

    public void setWebServiceContext(WebServiceContext wsc) {
        this.wsContext = wsc;
    }
}

