/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider.datasource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.systest.provider.datasource.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DataSourceProviderTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(DataSourceProviderTest.class);
    private static final String BOUNDARY = "----=_Part_4_701508.1145579811786";
    private HttpURLConnection conn;
    private URL url;

    @BeforeClass
    public static void startServers() throws Exception {
        DataSourceProviderTest.assertTrue((String)"server did not launch correctly", (boolean)DataSourceProviderTest.launchServer(Server.class, (boolean)true));
    }

    @Before
    public void createConnection() throws Exception {
        this.url = new URL("http://localhost:9000/test/foo");
        this.conn = (HttpURLConnection)this.url.openConnection();
        this.conn.setDoOutput(true);
    }

    @Test
    public void invokeOnServer() throws Exception {
        this.url = new URL("http://localhost:9000/test/foo");
        this.conn = (HttpURLConnection)this.url.openConnection();
        this.printSource(new StreamSource(this.conn.getInputStream()));
    }

    @Test
    public void postAttachmentToServer() throws Exception {
        String contentType = "multipart/related; type=\"text/xml\"; start=\"attachmentData\"; boundary=\"----=_Part_4_701508.1145579811786\"";
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/attachmentBinaryData");
        DataSourceProviderTest.assertNotNull((String)"could not load test data", (Object)in);
        this.conn.setRequestMethod("POST");
        this.conn.addRequestProperty("Content-Type", contentType);
        OutputStream out = this.conn.getOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.close();
        MimeMultipart mm = DataSourceProviderTest.readAttachmentParts(this.conn.getRequestProperty("Content-Type"), this.conn.getInputStream());
        DataSourceProviderTest.assertEquals((String)"incorrect number of parts received by server", (Object)3, (Object)mm.getCount());
    }

    private void printSource(Source source) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult sr = new StreamResult(bos);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            Properties oprops = new Properties();
            oprops.put("omit-xml-declaration", "yes");
            trans.setOutputProperties(oprops);
            trans.transform(source, sr);
            DataSourceProviderTest.assertEquals((Object)bos.toString(), (Object)"<doc><response>Hello</response></doc>");
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MimeMultipart readAttachmentParts(String contentType, InputStream bais) throws MessagingException, IOException {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage mm = new MimeMessage(session, bais);
        mm.addHeaderLine("Content-Type:" + contentType);
        return (MimeMultipart)mm.getContent();
    }
}

