/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.ServiceContractResolver;

public class JarServiceContractResolver
implements ServiceContractResolver {
    private URI uri;

    public URI getContractLocation(QName qname) {
        int i;
        URI ns = null;
        try {
            ns = new URI(qname.getNamespaceURI()).normalize();
        }
        catch (URISyntaxException e2) {
            return null;
        }
        String[] hostStrings = ns.getHost().split("\\.");
        String[] pathStrings = ns.getPath().split("\\/");
        String local = qname.getLocalPart();
        StringBuffer path = new StringBuffer();
        for (i = hostStrings.length - 1; i >= 0; --i) {
            path.append(hostStrings[i]).append("/");
        }
        for (i = 1; i < pathStrings.length; ++i) {
            path.append(pathStrings[i]).append("/");
        }
        path.append(local).append(".wsdl");
        try {
            URL jarURL = this.getClass().getResource("/wsdl/hello_world_resolver.jar");
            JarFile jar = new JarFile(new File(jarURL.toURI()));
            JarEntry jarEntry = jar.getJarEntry(path.toString());
            this.uri = new URI("jar:" + jarURL + "!/" + jarEntry.toString());
            return this.uri;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

