/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.rest;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.customer.book.Book;
import org.apache.cxf.customer.book.BookService;
import org.apache.cxf.customer.book.BookServiceWrapped;
import org.apache.cxf.customer.book.GetAnotherBook;
import org.apache.cxf.customer.book.GetBook;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.systest.rest.BookServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class RestClientServerBookTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(RestClientServerBookTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        RestClientServerBookTest.assertTrue((String)"server did not launch correctly", (boolean)RestClientServerBookTest.launchServer(BookServer.class));
    }

    @Test
    public void testGetBookWithXmlRootElement() throws Exception {
        JaxWsProxyFactoryBean sf = new JaxWsProxyFactoryBean();
        sf.setServiceClass(BookService.class);
        sf.getServiceFactory().setWrapped(false);
        sf.getClientFactoryBean().setBindingId("http://apache.org/cxf/binding/http");
        sf.setAddress("http://localhost:9080/xml/");
        BookService bs = (BookService)sf.create();
        GetBook getBook = new GetBook();
        getBook.setId(123L);
        Book book = bs.getBook(getBook);
        RestClientServerBookTest.assertEquals((Object)book.getId(), (Object)123L);
        RestClientServerBookTest.assertEquals((Object)book.getName(), (Object)"CXF in Action");
    }

    @Test
    public void testGetBookWithOutXmlRootElement() throws Exception {
        JaxWsProxyFactoryBean sf = new JaxWsProxyFactoryBean();
        sf.setServiceClass(BookService.class);
        sf.getServiceFactory().setWrapped(false);
        sf.getClientFactoryBean().setBindingId("http://apache.org/cxf/binding/http");
        sf.setAddress("http://localhost:9080/xml/");
        BookService bs = (BookService)sf.create();
        GetAnotherBook getAnotherBook = new GetAnotherBook();
        getAnotherBook.setId(123L);
        Book book = bs.getAnotherBook(getAnotherBook);
        RestClientServerBookTest.assertEquals((Object)book.getId(), (Object)123L);
        RestClientServerBookTest.assertEquals((Object)book.getName(), (Object)"CXF in Action");
    }

    @Test
    public void testGetBookWrapped() throws Exception {
        JaxWsProxyFactoryBean sf = new JaxWsProxyFactoryBean();
        sf.setServiceClass(BookServiceWrapped.class);
        sf.getServiceFactory().setWrapped(true);
        sf.getClientFactoryBean().setBindingId("http://apache.org/cxf/binding/http");
        sf.setAddress("http://localhost:9080/xmlwrapped/");
        BookServiceWrapped bs = (BookServiceWrapped)sf.create();
        Book book = bs.getBook(123L);
        RestClientServerBookTest.assertEquals((Object)book.getId(), (Object)123L);
        RestClientServerBookTest.assertEquals((Object)book.getName(), (Object)"CXF in Action");
    }

    @Test
    public void testGetBookWrappedUsingURL() throws Exception {
        String endpointAddress = "http://localhost:9080/xmlwrapped/books/123";
        URL url = new URL(endpointAddress);
        InputStream in = url.openStream();
        RestClientServerBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123_xmlwrapped.txt");
        String expectedString = this.getStringFromInputStream(expected).trim();
        String newString = this.getStringFromInputStream(in).trim();
        RestClientServerBookTest.assertEquals((String)expectedString, (Object)expectedString, (Object)newString);
    }

    @Test
    public void testGetBooksJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/json/books";
        URL url = new URL(endpointAddress);
        InputStream in = url.openStream();
        RestClientServerBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_json_books.txt");
        RestClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBookJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/json/books/123";
        URL url = new URL(endpointAddress);
        InputStream in = url.openStream();
        RestClientServerBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_json_book123.txt");
        RestClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddBookJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/json/books";
        String inputFile = ((Object)((Object)this)).getClass().getResource("resources/add_book_json.txt").getFile();
        File input = new File(inputFile);
        PostMethod post = new PostMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/plain; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            RestClientServerBookTest.assertEquals((Object)200, (Object)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book_json.txt");
            RestClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }
}

