/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import java.io.InputStream;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.servlet.AbstractServletTest;
import org.apache.cxf.systest.servlet.GetMethodQueryWebRequest;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class CXFServletTest
extends AbstractServletTest {
    @Before
    public void setUp() throws Exception {
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
        super.setUp();
    }

    protected Bus createBus() throws BusException {
        return null;
    }

    @Test
    public void testPostInvokeServices() throws Exception {
        this.invoke("UTF-8");
        this.invoke("iso-8859-1");
    }

    private void invoke(String encoding) throws Exception {
        PostMethodWebRequest req = new PostMethodWebRequest("http://localhost/mycontext/services/greeter", ((Object)((Object)this)).getClass().getResourceAsStream("GreeterMessage.xml"), "text/xml; charset=" + encoding);
        ServletUnitClient client = this.newClient();
        WebResponse response = client.getResponse((WebRequest)req);
        client.setExceptionsThrownOnErrorStatus(false);
        CXFServletTest.assertEquals((Object)"text/xml", (Object)response.getContentType());
        CXFServletTest.assertTrue((boolean)encoding.equalsIgnoreCase(response.getCharacterSet()));
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        CXFServletTest.assertNotNull((Object)doc);
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:sayHiResponse", doc);
    }

    @Test
    public void testGetServiceList() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        WebResponse res = client.getResponse("http://localhost/mycontext/services");
        WebLink[] links = res.getLinks();
        CXFServletTest.assertEquals((String)"There should get two links for the service", (Object)2, (Object)links.length);
        CXFServletTest.assertEquals((Object)"http://localhost/mycontext/services/greeter?wsdl", (Object)links[0].getURLString());
        CXFServletTest.assertEquals((Object)"http://localhost/mycontext/services/greeter2?wsdl", (Object)links[1].getURLString());
        CXFServletTest.assertEquals((Object)"text/html", (Object)res.getContentType());
        res = client.getResponse("http://localhost/mycontext/services/");
        links = res.getLinks();
        CXFServletTest.assertEquals((String)"There should get two links for the service", (Object)2, (Object)links.length);
        CXFServletTest.assertEquals((Object)"http://localhost/mycontext/services/greeter?wsdl", (Object)links[0].getURLString());
        CXFServletTest.assertEquals((Object)"http://localhost/mycontext/services/greeter2?wsdl", (Object)links[1].getURLString());
        CXFServletTest.assertEquals((Object)"text/html", (Object)res.getContentType());
        CXFServletTest.assertNotNull((Object)BusFactory.getDefaultBus((boolean)false));
    }

    @Test
    public void testGetWSDL() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((Object)200, (Object)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        CXFServletTest.assertTrue((String)"the wsdl should contain the opertion greetMe", (boolean)res.getText().contains("<wsdl:operation name=\"greetMe\">"));
        CXFServletTest.assertTrue((String)"the soap address should changed", (boolean)res.getText().contains("<soap:address location=\"http://localhost/mycontext/services/greeter\""));
    }

    @Test
    public void testGetWSDLWithXMLBinding() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter2?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((Object)200, (Object)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        CXFServletTest.assertTrue((String)"the wsdl should contain the opertion greetMe", (boolean)res.getText().contains("<wsdl:operation name=\"greetMe\">"));
        CXFServletTest.assertTrue((String)"the http address should changed", (boolean)res.getText().contains("http://localhost/mycontext/services/greeter2\""));
    }

    @Test
    public void testInvalidServiceUrl() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        WebResponse res = client.getResponse("http://localhost/mycontext/services/NoSuchService");
        CXFServletTest.assertEquals((Object)404, (Object)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/html", (Object)res.getContentType());
    }

    @Test
    public void testServiceWsdlNotFound() throws Exception {
        GetMethodWebRequest req = new GetMethodWebRequest("http://localhost/mycontext/services/NoSuchService?wsdl");
        this.expectErrorCode((WebRequest)req, 404, "Response code 404 required for invalid WSDL url.");
    }

    @Test
    public void testGetImportedXSD() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((Object)200, (Object)res.getResponseCode());
        String text = res.getText();
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        CXFServletTest.assertTrue((boolean)text.contains("http://localhost/mycontext/services/greeter?wsdl=test_import.xsd"));
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter?wsdl=test_import.xsd");
        res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((Object)200, (Object)res.getResponseCode());
        text = res.getText();
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        CXFServletTest.assertTrue((String)"the xsd should contain the completType SimpleStruct", (boolean)text.contains("<complexType name=\"SimpleStruct\">"));
    }
}

