/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import java.io.InputStream;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.servlet.AbstractServletTest;
import org.apache.cxf.systest.servlet.GetMethodQueryWebRequest;
import org.junit.Test;
import org.w3c.dom.Document;

public class HttpBindingServletTest
extends AbstractServletTest {
    static final String JSON_CUSTOMER = "{\"jra.customer\":{\"jra.id\":\"123\",\"jra.name\":\"Dan Diephouse\"}}";

    protected String getConfiguration() {
        return "/org/apache/cxf/systest/servlet/web-restful.xml";
    }

    protected Bus createBus() throws BusException {
        return null;
    }

    @Test
    public void testServerFactoryRestService() throws Exception {
        this.testInvokingRestService("/services/serverFactory/restful");
    }

    @Test
    public void testEndpointRestService() throws Exception {
        this.testInvokingRestService("/services/endpoint/restful");
    }

    @Test
    public void testJsonService() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/serverFactory/json/customers");
        WebResponse response = client.getResponse((WebRequest)req);
        HttpBindingServletTest.assertTrue((String)"Can't get the right Json customers ", (response.getText().indexOf(JSON_CUSTOMER) > 0 ? 1 : 0) != 0);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/serverFactory/json/customers/123");
        response = client.getResponse((WebRequest)req);
        HttpBindingServletTest.assertEquals((String)"Can't get the right Json customer ", (Object)response.getText(), (Object)JSON_CUSTOMER);
    }

    private void testInvokingRestService(String serviceAddress) throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext" + serviceAddress + "/customers");
        WebResponse response = client.getResponse((WebRequest)req);
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        HttpBindingServletTest.assertNotNull((Object)doc);
        this.addNamespace("c", "http://cxf.apache.org/jra");
        this.assertValid("/c:customers", doc);
        this.assertValid("/c:customers/c:customer/c:id[text()='123']", doc);
        this.assertValid("/c:customers/c:customer/c:name[text()='Dan Diephouse']", doc);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext" + serviceAddress + "/customers/123");
        response = client.getResponse((WebRequest)req);
        doc = DOMUtils.readXml((InputStream)response.getInputStream());
        HttpBindingServletTest.assertNotNull((Object)doc);
        this.assertValid("/c:customer", doc);
        this.assertValid("/c:customer/c:id[text()='123']", doc);
        this.assertValid("/c:customer/c:name[text()='Dan Diephouse']", doc);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext" + serviceAddress + "/customers/0");
        response = client.getResponse((WebRequest)req);
        HttpBindingServletTest.assertEquals((String)"Expect the wrong response code", (Object)response.getResponseCode(), (Object)500);
        doc = DOMUtils.readXml((InputStream)response.getInputStream());
        HttpBindingServletTest.assertNotNull((Object)doc);
        this.assertValid("//c:CustomerNotFoundFault", doc);
        PostMethodWebRequest postReq = new PostMethodWebRequest("http://localhost/mycontext" + serviceAddress + "/customers", ((Object)((Object)this)).getClass().getResourceAsStream("add.xml"), "text/xml; charset=UTF-8");
        response = client.getResponse((WebRequest)postReq);
        doc = DOMUtils.readXml((InputStream)response.getInputStream());
        HttpBindingServletTest.assertNotNull((Object)doc);
        this.assertValid("/c:addCustomer", doc);
        PutMethodWebRequest putReq = new PutMethodWebRequest("http://localhost/mycontext" + serviceAddress + "/customers/123", ((Object)((Object)this)).getClass().getResourceAsStream("update.xml"), "text/xml; charset=UTF-8");
        response = client.getResponse((WebRequest)putReq);
        doc = DOMUtils.readXml((InputStream)response.getInputStream());
        HttpBindingServletTest.assertNotNull((Object)doc);
        this.assertValid("/c:updateCustomer", doc);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext" + serviceAddress + "/customers/123");
        response = client.getResponse((WebRequest)req);
        doc = DOMUtils.readXml((InputStream)response.getInputStream());
        HttpBindingServletTest.assertNotNull((Object)doc);
        this.assertValid("/c:customer", doc);
        this.assertValid("/c:customer/c:id[text()='123']", doc);
        this.assertValid("/c:customer/c:name[text()='Danno Manno']", doc);
    }
}

