/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.swa;

import java.io.InputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Holder;
import org.apache.cxf.swa.SwAService;
import org.apache.cxf.swa.SwAServiceInterface;
import org.apache.cxf.swa.types.DataStruct;
import org.apache.cxf.swa.types.OutputResponseAll;
import org.apache.cxf.swa.types.VoidRequest;
import org.apache.cxf.systest.swa.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClientServerSwaTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerSwaTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerSwaTest.launchServer(Server.class));
    }

    @Test
    public void testSwa() throws Exception {
        SwAService service = new SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        Holder textHolder = new Holder();
        Holder data = new Holder();
        ByteArrayDataSource source = new ByteArrayDataSource("foobar".getBytes(), "application/octet-stream");
        DataHandler handler = new DataHandler((DataSource)source);
        data.value = handler;
        textHolder.value = "Hi";
        port.echoData(textHolder, data);
        InputStream bis = null;
        bis = ((DataHandler)data.value).getDataSource().getInputStream();
        byte[] b = new byte[10];
        bis.read(b, 0, 10);
        String string = new String(b);
        ClientServerSwaTest.assertEquals((Object)"testfoobar", (Object)string);
        ClientServerSwaTest.assertEquals((Object)"Hi", (Object)textHolder.value);
    }

    @Test
    public void testSwaWithHeaders() throws Exception {
        SwAService service = new SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        Holder textHolder = new Holder();
        Holder headerHolder = new Holder();
        Holder data = new Holder();
        ByteArrayDataSource source = new ByteArrayDataSource("foobar".getBytes(), "application/octet-stream");
        DataHandler handler = new DataHandler((DataSource)source);
        data.value = handler;
        textHolder.value = "Hi";
        headerHolder.value = "Header";
        port.echoDataWithHeader(textHolder, data, headerHolder);
        InputStream bis = null;
        bis = ((DataHandler)data.value).getDataSource().getInputStream();
        byte[] b = new byte[10];
        bis.read(b, 0, 10);
        String string = new String(b);
        ClientServerSwaTest.assertEquals((Object)"testfoobar", (Object)string);
        ClientServerSwaTest.assertEquals((Object)"Hi", (Object)textHolder.value);
        ClientServerSwaTest.assertEquals((Object)"Header", (Object)headerHolder.value);
    }

    @Test
    public void testSwaDataStruct() throws Exception {
        SwAService service = new SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        Holder structHolder = new Holder();
        ByteArrayDataSource source = new ByteArrayDataSource("foobar".getBytes(), "application/octet-stream");
        DataHandler handler = new DataHandler((DataSource)source);
        DataStruct struct = new DataStruct();
        struct.setDataRef(handler);
        structHolder.value = struct;
        port.echoDataRef(structHolder);
        handler = ((DataStruct)structHolder.value).getDataRef();
        InputStream bis = null;
        bis = handler.getDataSource().getInputStream();
        byte[] b = new byte[10];
        bis.read(b, 0, 10);
        String string = new String(b);
        ClientServerSwaTest.assertEquals((Object)"testfoobar", (Object)string);
    }

    @Test
    public void testSwaTypes() throws Exception {
        SwAService service = new SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        URL url1 = ((Object)((Object)this)).getClass().getResource("resources/attach.text");
        URL url2 = ((Object)((Object)this)).getClass().getResource("resources/attach.html");
        URL url3 = ((Object)((Object)this)).getClass().getResource("resources/attach.xml");
        URL url4 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg1");
        URL url5 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg2");
        DataHandler dh1 = new DataHandler(url1);
        DataHandler dh2 = new DataHandler(url2);
        DataHandler dh3 = new DataHandler(url3);
        Holder attach1 = new Holder();
        attach1.value = dh1;
        Holder attach2 = new Holder();
        attach2.value = dh2;
        Holder attach3 = new Holder();
        attach3.value = new StreamSource(dh3.getInputStream());
        Holder attach4 = new Holder();
        Holder attach5 = new Holder();
        attach4.value = ImageIO.read(url4);
        attach5.value = ImageIO.read(url5);
        VoidRequest request = new VoidRequest();
        OutputResponseAll response = port.echoAllAttachmentTypes(request, attach1, attach2, attach3, attach4, attach5);
        ClientServerSwaTest.assertNotNull((Object)response);
    }
}

