/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.type_test;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.Holder;
import org.apache.cxf.systest.type_test.AbstractTypeTestClient;
import org.apache.type_test.types1.AnonymousStruct;
import org.apache.type_test.types1.BoundedArray;
import org.apache.type_test.types1.ChoiceArray;
import org.apache.type_test.types1.ColourEnum;
import org.apache.type_test.types1.CompoundArray;
import org.apache.type_test.types1.DerivedStructBaseEmpty;
import org.apache.type_test.types1.Document;
import org.apache.type_test.types1.EmptyAll;
import org.apache.type_test.types1.EmptyChoice;
import org.apache.type_test.types1.EmptyStruct;
import org.apache.type_test.types1.ExtColourEnum;
import org.apache.type_test.types1.ExtendsSimpleContent;
import org.apache.type_test.types1.ExtendsSimpleType;
import org.apache.type_test.types1.FixedArray;
import org.apache.type_test.types1.NestedArray;
import org.apache.type_test.types1.NestedStruct;
import org.apache.type_test.types1.RecursiveStruct;
import org.apache.type_test.types1.RecursiveStructArray;
import org.apache.type_test.types1.RecursiveUnion;
import org.apache.type_test.types1.RecursiveUnionData;
import org.apache.type_test.types1.SimpleAll;
import org.apache.type_test.types1.SimpleChoice;
import org.apache.type_test.types1.SimpleContent1;
import org.apache.type_test.types1.SimpleContent2;
import org.apache.type_test.types1.SimpleContent3;
import org.apache.type_test.types1.SimpleStruct;
import org.apache.type_test.types1.StructWithList;
import org.apache.type_test.types1.StructWithNillables;
import org.apache.type_test.types1.StructWithOptionals;
import org.apache.type_test.types1.StructWithUnion;
import org.apache.type_test.types1.UnboundedArray;
import org.apache.type_test.types1.UnionSimpleContent;
import org.apache.type_test.types2.ExtBase64Binary;
import org.apache.type_test.types3.ChoiceWithSubstitutionGroup;
import org.apache.type_test.types3.ChoiceWithSubstitutionGroupAbstract;
import org.apache.type_test.types3.ChoiceWithSubstitutionGroupNil;
import org.apache.type_test.types3.ObjectFactory;
import org.apache.type_test.types3.RecElNextType;
import org.apache.type_test.types3.RecElType;
import org.apache.type_test.types3.RecInnerNextType;
import org.apache.type_test.types3.RecInnerType;
import org.apache.type_test.types3.RecMostInnerNextType;
import org.apache.type_test.types3.RecMostInnerType;
import org.apache.type_test.types3.RecOuterNextType;
import org.apache.type_test.types3.RecOuterType;
import org.apache.type_test.types3.SgBaseTypeA;
import org.apache.type_test.types3.SgDerivedTypeB;
import org.apache.type_test.types3.SgDerivedTypeC;
import org.apache.type_test.types3.StructWithMultipleSubstitutionGroups;
import org.apache.type_test.types3.StructWithSubstitutionGroup;
import org.apache.type_test.types3.StructWithSubstitutionGroupAbstract;
import org.apache.type_test.types3.StructWithSubstitutionGroupNil;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeTestClient2
extends AbstractTypeTestClient {
    protected <T> boolean equalsNilable(T x, T y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        return x.equals(y);
    }

    protected <T> boolean notNull(T x, T y) {
        return x != null && y != null;
    }

    @Test
    public void testEmptyStruct() throws Exception {
        EmptyStruct x = new EmptyStruct();
        EmptyStruct yOrig = new EmptyStruct();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        EmptyStruct ret = testDocLiteral ? docClient.testEmptyStruct(x, y, z) : (testXMLBinding ? xmlClient.testEmptyStruct(x, y, z) : rpcClient.testEmptyStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testEmptyStruct(): Null value for inout param", (boolean)this.notNull(x, y.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyStruct(): Null value for out param", (boolean)this.notNull(yOrig, z.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyStruct(): Null return value", (boolean)this.notNull(x, ret));
        }
        DerivedStructBaseEmpty derivedX = new DerivedStructBaseEmpty();
        derivedX.setVarFloatExt(-3.14f);
        derivedX.setVarStringExt("DerivedStruct-x");
        derivedX.setAttrString("DerivedAttr-x");
        DerivedStructBaseEmpty derivedY = new DerivedStructBaseEmpty();
        derivedY.setVarFloatExt(1.414f);
        derivedY.setVarStringExt("DerivedStruct-y");
        derivedY.setAttrString("DerivedAttr-y");
        y = new Holder((Object)derivedY);
        z = new Holder();
        ret = testDocLiteral ? docClient.testEmptyStruct((EmptyStruct)derivedX, y, z) : (testXMLBinding ? xmlClient.testEmptyStruct((EmptyStruct)derivedX, y, z) : rpcClient.testEmptyStruct((EmptyStruct)derivedX, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testEmptyStruct(): Null value for inout param", (boolean)this.notNull(derivedX, y.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyStruct(): Null value for out param", (boolean)this.notNull(derivedY, z.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyStruct(): Null return value", (boolean)this.notNull(derivedX, ret));
        }
    }

    protected boolean equals(SimpleStruct x, SimpleStruct y) {
        return Double.compare(x.getVarFloat(), y.getVarFloat()) == 0 && x.getVarInt().compareTo(y.getVarInt()) == 0 && x.getVarString().equals(y.getVarString()) && this.equalsNilable(x.getVarAttrString(), y.getVarAttrString());
    }

    @Test
    public void testSimpleStruct() throws Exception {
        SimpleStruct x = new SimpleStruct();
        x.setVarFloat((double)3.14f);
        x.setVarInt(new BigInteger("42"));
        x.setVarString("Hello There");
        SimpleStruct yOrig = new SimpleStruct();
        yOrig.setVarFloat((double)1.414f);
        yOrig.setVarInt(new BigInteger("13"));
        yOrig.setVarString("Cheerio");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SimpleStruct ret = testDocLiteral ? docClient.testSimpleStruct(x, y, z) : (testXMLBinding ? xmlClient.testSimpleStruct(x, y, z) : rpcClient.testSimpleStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testSimpleStruct(): Incorrect value for inout param", (boolean)this.equals(x, (SimpleStruct)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testSimpleStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (SimpleStruct)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testSimpleStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(StructWithNillables x, StructWithNillables y) {
        return this.equalsNilable(x.getVarFloat(), y.getVarFloat()) && this.equalsNilable(x.getVarInt(), x.getVarInt()) && this.equalsNilable(x.getVarString(), y.getVarString()) && this.equalsNilable(x.getVarStruct(), y.getVarStruct());
    }

    @Test
    public void testStructWithNillables() throws Exception {
        StructWithNillables x = new StructWithNillables();
        StructWithNillables yOrig = new StructWithNillables();
        yOrig.setVarFloat(new Float(1.414f));
        yOrig.setVarInt(new Integer(13));
        yOrig.setVarString("Cheerio");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithNillables ret = testDocLiteral ? docClient.testStructWithNillables(x, y, z) : (testXMLBinding ? xmlClient.testStructWithNillables(x, y, z) : rpcClient.testStructWithNillables(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testStructWithNillables(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithNillables)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithNillables(): Incorrect value for out param", (boolean)this.equals(yOrig, (StructWithNillables)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithNillables(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(AnonymousStruct x, AnonymousStruct y) {
        return x.getVarFloat() == y.getVarFloat() && x.getVarInt() == y.getVarInt() && x.getVarString().equals(y.getVarString());
    }

    @Test
    public void testAnonymousStruct() throws Exception {
        AnonymousStruct x = new AnonymousStruct();
        x.setVarInt(100);
        x.setVarString("hello");
        x.setVarFloat(1.1f);
        AnonymousStruct yOrig = new AnonymousStruct();
        yOrig.setVarInt(11);
        yOrig.setVarString("world");
        yOrig.setVarFloat(10.1f);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        AnonymousStruct ret = testDocLiteral ? docClient.testAnonymousStruct(x, y, z) : (testXMLBinding ? xmlClient.testAnonymousStruct(x, y, z) : rpcClient.testAnonymousStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testAnonymousStruct(): Incorrect value for inout param", (boolean)this.equals(x, (AnonymousStruct)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testAnonymousStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (AnonymousStruct)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testAnonymousStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(NestedStruct x, NestedStruct y) {
        return x.getVarInt() == y.getVarInt() && x.getVarFloat().compareTo(y.getVarFloat()) == 0 && x.getVarString().equals(y.getVarString()) && this.equalsNilable(x.getVarEmptyStruct(), y.getVarEmptyStruct()) && this.equalsNilableStruct(x.getVarStruct(), y.getVarStruct());
    }

    protected boolean equalsNilable(EmptyStruct x, EmptyStruct y) {
        if (x == null) {
            return y == null;
        }
        return y != null;
    }

    protected boolean equalsNilableStruct(SimpleStruct x, SimpleStruct y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        return this.equals(x, y);
    }

    @Test
    public void testNestedStruct() throws Exception {
        SimpleStruct xs = new SimpleStruct();
        xs.setVarFloat(30.14);
        xs.setVarInt(new BigInteger("420"));
        xs.setVarString("NESTED Hello There");
        NestedStruct x = new NestedStruct();
        x.setVarFloat(new BigDecimal("3.14"));
        x.setVarInt(42);
        x.setVarString("Hello There");
        x.setVarEmptyStruct(new EmptyStruct());
        x.setVarStruct(xs);
        SimpleStruct ys = new SimpleStruct();
        ys.setVarFloat(10.414);
        ys.setVarInt(new BigInteger("130"));
        ys.setVarString("NESTED Cheerio");
        NestedStruct yOrig = new NestedStruct();
        yOrig.setVarFloat(new BigDecimal("1.414"));
        yOrig.setVarInt(13);
        yOrig.setVarString("Cheerio");
        yOrig.setVarEmptyStruct(new EmptyStruct());
        yOrig.setVarStruct(ys);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        NestedStruct ret = testDocLiteral ? docClient.testNestedStruct(x, y, z) : (testXMLBinding ? xmlClient.testNestedStruct(x, y, z) : rpcClient.testNestedStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testNestedStruct(): Incorrect value for inout param", (boolean)this.equals(x, (NestedStruct)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testNestedStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (NestedStruct)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testNestedStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testFixedArray() throws Exception {
        FixedArray x = new FixedArray();
        x.getItem().addAll(Arrays.asList(Integer.MIN_VALUE, 0, Integer.MAX_VALUE));
        FixedArray yOrig = new FixedArray();
        yOrig.getItem().addAll(Arrays.asList(-1, 0, 1));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        FixedArray ret = testDocLiteral ? docClient.testFixedArray(x, y, z) : (testXMLBinding ? xmlClient.testFixedArray(x, y, z) : rpcClient.testFixedArray(x, y, z));
        if (!this.perfTestOnly) {
            for (int i = 0; i < 3; ++i) {
                AbstractTypeTestClient2.assertEquals((String)"testFixedArray(): Incorrect value for inout param", x.getItem().get(i), ((FixedArray)y.value).getItem().get(i));
                AbstractTypeTestClient2.assertEquals((String)"testFixedArray(): Incorrect value for out param", yOrig.getItem().get(i), ((FixedArray)z.value).getItem().get(i));
                AbstractTypeTestClient2.assertEquals((String)"testFixedArray(): Incorrect return value", x.getItem().get(i), ret.getItem().get(i));
            }
        }
    }

    @Test
    public void testBoundedArray() throws Exception {
        BoundedArray x = new BoundedArray();
        x.getItem().addAll(Arrays.asList(Float.valueOf(-100.0f), Float.valueOf(0.0f), Float.valueOf(100.0f)));
        BoundedArray yOrig = new BoundedArray();
        yOrig.getItem().addAll(Arrays.asList(Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        BoundedArray ret = testDocLiteral ? docClient.testBoundedArray(x, y, z) : (testXMLBinding ? xmlClient.testBoundedArray(x, y, z) : rpcClient.testBoundedArray(x, y, z));
        if (!this.perfTestOnly) {
            float delta = 0.0f;
            int xSize = x.getItem().size();
            int ySize = ((BoundedArray)y.value).getItem().size();
            int zSize = ((BoundedArray)z.value).getItem().size();
            int retSize = ret.getItem().size();
            AbstractTypeTestClient2.assertTrue((String)"testBoundedArray() array size incorrect", (xSize == ySize && ySize == zSize && zSize == retSize && xSize == 3 ? 1 : 0) != 0);
            for (int i = 0; i < xSize; ++i) {
                AbstractTypeTestClient2.assertEquals((String)"testBoundedArray(): Incorrect value for inout param", (double)((Float)x.getItem().get(i)).floatValue(), (double)((Float)((BoundedArray)y.value).getItem().get(i)).floatValue(), (double)delta);
                AbstractTypeTestClient2.assertEquals((String)"testBoundedArray(): Incorrect value for out param", (double)((Float)yOrig.getItem().get(i)).floatValue(), (double)((Float)((BoundedArray)z.value).getItem().get(i)).floatValue(), (double)delta);
                AbstractTypeTestClient2.assertEquals((String)"testBoundedArray(): Incorrect return value", (double)((Float)x.getItem().get(i)).floatValue(), (double)((Float)ret.getItem().get(i)).floatValue(), (double)delta);
            }
        }
    }

    protected boolean equals(UnboundedArray x, UnboundedArray y) {
        List xx = x.getItem();
        List yy = y.getItem();
        if (xx.size() != yy.size()) {
            return false;
        }
        for (int i = 0; i < xx.size(); ++i) {
            if (((String)xx.get(i)).equals(yy.get(i))) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testUnboundedArray() throws Exception {
        UnboundedArray x = new UnboundedArray();
        x.getItem().addAll(Arrays.asList("AAA", "BBB", "CCC"));
        UnboundedArray yOrig = new UnboundedArray();
        yOrig.getItem().addAll(Arrays.asList("XXX", "YYY", "ZZZ"));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        UnboundedArray ret = testDocLiteral ? docClient.testUnboundedArray(x, y, z) : (testXMLBinding ? xmlClient.testUnboundedArray(x, y, z) : rpcClient.testUnboundedArray(x, y, z));
        if (!this.perfTestOnly) {
            for (int i = 0; i < 3; ++i) {
                AbstractTypeTestClient2.assertTrue((String)"testUnboundedArray(): Incorrect value for inout param", (boolean)this.equals(x, (UnboundedArray)y.value));
                AbstractTypeTestClient2.assertTrue((String)"testUnboundedArray(): Incorrect value for out param", (boolean)this.equals(yOrig, (UnboundedArray)z.value));
                AbstractTypeTestClient2.assertTrue((String)"testUnboundedArray(): Incorrect return value", (boolean)this.equals(x, ret));
            }
        }
    }

    protected boolean equals(CompoundArray x, CompoundArray y) {
        return ((Object)x.getArray1()).equals(y.getArray1()) && ((Object)x.getArray2()).equals(y.getArray2());
    }

    @Test
    public void testCompoundArray() throws Exception {
        CompoundArray x = new CompoundArray();
        x.getArray1().addAll(Arrays.asList("AAA", "BBB", "CCC"));
        x.getArray2().addAll(Arrays.asList("aaa", "bbb", "ccc"));
        CompoundArray yOrig = new CompoundArray();
        yOrig.getArray1().addAll(Arrays.asList("XXX", "YYY", "ZZZ"));
        yOrig.getArray2().addAll(Arrays.asList("xxx", "yyy", "zzz"));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        CompoundArray ret = testDocLiteral ? docClient.testCompoundArray(x, y, z) : (testXMLBinding ? xmlClient.testCompoundArray(x, y, z) : rpcClient.testCompoundArray(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testCompoundArray(): Incorrect value for inout param", (boolean)this.equals(x, (CompoundArray)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testCompoundArray(): Incorrect value for out param", (boolean)this.equals(yOrig, (CompoundArray)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testCompoundArray(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testNestedArray() throws Exception {
        String[][] xs = new String[][]{{"AAA", "BBB", "CCC"}, {"aaa", "bbb", "ccc"}, {"a_a_a", "b_b_b", "c_c_c"}};
        String[][] ys = new String[][]{{"XXX", "YYY", "ZZZ"}, {"xxx", "yyy", "zzz"}, {"x_x_x", "y_y_y", "z_z_z"}};
        NestedArray x = new NestedArray();
        NestedArray yOrig = new NestedArray();
        List xList = x.getSubarray();
        List yList = yOrig.getSubarray();
        for (int i = 0; i < 3; ++i) {
            UnboundedArray xx = new UnboundedArray();
            xx.getItem().addAll(Arrays.asList(xs[i]));
            xList.add(xx);
            UnboundedArray yy = new UnboundedArray();
            yy.getItem().addAll(Arrays.asList(ys[i]));
            yList.add(yy);
        }
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        NestedArray ret = testDocLiteral ? docClient.testNestedArray(x, y, z) : (testXMLBinding ? xmlClient.testNestedArray(x, y, z) : rpcClient.testNestedArray(x, y, z));
        if (!this.perfTestOnly) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    AbstractTypeTestClient2.assertEquals((String)"testNestedArray(): Incorrect value for inout param", ((UnboundedArray)x.getSubarray().get(i)).getItem().get(j), ((UnboundedArray)((NestedArray)y.value).getSubarray().get(i)).getItem().get(j));
                    AbstractTypeTestClient2.assertEquals((String)"testNestedArray(): Incorrect value for out param", ((UnboundedArray)yOrig.getSubarray().get(i)).getItem().get(j), ((UnboundedArray)((NestedArray)z.value).getSubarray().get(i)).getItem().get(j));
                    AbstractTypeTestClient2.assertEquals((String)"testNestedArray(): Incorrect return value", ((UnboundedArray)x.getSubarray().get(i)).getItem().get(j), ((UnboundedArray)ret.getSubarray().get(i)).getItem().get(j));
                }
            }
        }
    }

    protected void assertEquals(String msg, StructWithList x, StructWithList y) throws Exception {
        AbstractTypeTestClient2.assertTrue((String)msg, (x != null ? 1 : 0) != 0);
        AbstractTypeTestClient2.assertTrue((String)msg, (y != null ? 1 : 0) != 0);
        List xVar = x.getVarList();
        List yVar = y.getVarList();
        AbstractTypeTestClient2.assertTrue((xVar.size() == yVar.size() ? 1 : 0) != 0);
        for (int i = 0; i < xVar.size(); ++i) {
            AbstractTypeTestClient2.assertEquals((String)msg, xVar.get(i), yVar.get(i));
        }
        List xAttr = x.getAttribList();
        List yAttr = y.getAttribList();
        if (xAttr == null) {
            AbstractTypeTestClient2.assertTrue((String)msg, (yAttr == null ? 1 : 0) != 0);
        } else {
            AbstractTypeTestClient2.assertTrue((xAttr.size() == yAttr.size() ? 1 : 0) != 0);
            for (int i = 0; i < xAttr.size(); ++i) {
                AbstractTypeTestClient2.assertEquals((String)msg, xAttr.get(i), yAttr.get(i));
            }
        }
    }

    @Test
    public void testStructWithList() throws Exception {
        StructWithList x = new StructWithList();
        x.getVarList().add("I");
        x.getVarList().add("am");
        x.getVarList().add("StructWithList");
        StructWithList yOrig = new StructWithList();
        yOrig.getVarList().add("Does");
        yOrig.getVarList().add("StructWithList");
        yOrig.getVarList().add("work");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithList ret = testDocLiteral ? docClient.testStructWithList(x, y, z) : (testXMLBinding ? xmlClient.testStructWithList(x, y, z) : rpcClient.testStructWithList(x, y, z));
        if (!this.perfTestOnly) {
            this.assertEquals("testStructWithList(): Incorrect value for inout param", x, (StructWithList)y.value);
            this.assertEquals("testStructWithList(): Incorrect value for out param", yOrig, (StructWithList)z.value);
            this.assertEquals("testStructWithList(): Incorrect return value", x, ret);
        }
        x.getAttribList().add(1);
        x.getAttribList().add(2);
        x.getAttribList().add(3);
        y.value = yOrig;
        ret = testDocLiteral ? docClient.testStructWithList(x, y, z) : (testXMLBinding ? xmlClient.testStructWithList(x, y, z) : rpcClient.testStructWithList(x, y, z));
        if (!this.perfTestOnly) {
            this.assertEquals("testStructWithList(): Incorrect value for inout param", x, (StructWithList)y.value);
            this.assertEquals("testStructWithList(): Incorrect value for out param", yOrig, (StructWithList)z.value);
            this.assertEquals("testStructWithList(): Incorrect return value", x, ret);
        }
        yOrig.getAttribList().add(4);
        yOrig.getAttribList().add(5);
        yOrig.getAttribList().add(6);
        y.value = yOrig;
        ret = testDocLiteral ? docClient.testStructWithList(x, y, z) : (testXMLBinding ? xmlClient.testStructWithList(x, y, z) : rpcClient.testStructWithList(x, y, z));
        if (!this.perfTestOnly) {
            this.assertEquals("testStructWithList(): Incorrect value for inout param", x, (StructWithList)y.value);
            this.assertEquals("testStructWithList(): Incorrect value for out param", yOrig, (StructWithList)z.value);
            this.assertEquals("testStructWithList(): Incorrect return value", x, ret);
        }
    }

    protected void assertEquals(String msg, StructWithUnion x, StructWithUnion y) throws Exception {
        AbstractTypeTestClient2.assertTrue((String)msg, (x != null ? 1 : 0) != 0);
        AbstractTypeTestClient2.assertTrue((String)msg, (y != null ? 1 : 0) != 0);
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getVarUnion(), (Object)y.getVarUnion());
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getAttribUnion(), (Object)y.getAttribUnion());
    }

    @Test
    public void testStructWithUnion() throws Exception {
        StructWithUnion x = new StructWithUnion();
        x.setVarUnion("999");
        StructWithUnion yOrig = new StructWithUnion();
        yOrig.setVarUnion("-999");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithUnion ret = testDocLiteral ? docClient.testStructWithUnion(x, y, z) : (testXMLBinding ? xmlClient.testStructWithUnion(x, y, z) : rpcClient.testStructWithUnion(x, y, z));
        if (!this.perfTestOnly) {
            this.assertEquals("testStructWithUnion(): Incorrect value for inout param", x, (StructWithUnion)y.value);
            this.assertEquals("testStructWithUnion(): Incorrect value for out param", yOrig, (StructWithUnion)z.value);
            this.assertEquals("testStructWithUnion(): Incorrect return value", x, ret);
        }
        x.setAttribUnion("99");
        y.value = yOrig;
        ret = testDocLiteral ? docClient.testStructWithUnion(x, y, z) : (testXMLBinding ? xmlClient.testStructWithUnion(x, y, z) : rpcClient.testStructWithUnion(x, y, z));
        if (!this.perfTestOnly) {
            this.assertEquals("testStructWithUnion(): Incorrect value for inout param", x, (StructWithUnion)y.value);
            this.assertEquals("testStructWithUnion(): Incorrect value for out param", yOrig, (StructWithUnion)z.value);
            this.assertEquals("testStructWithUnion(): Incorrect return value", x, ret);
        }
        yOrig.setAttribUnion("-99");
        y.value = yOrig;
        ret = testDocLiteral ? docClient.testStructWithUnion(x, y, z) : (testXMLBinding ? xmlClient.testStructWithUnion(x, y, z) : rpcClient.testStructWithUnion(x, y, z));
        if (!this.perfTestOnly) {
            this.assertEquals("testStructWithUnion(): Incorrect value for inout param", x, (StructWithUnion)y.value);
            this.assertEquals("testStructWithUnion(): Incorrect value for out param", yOrig, (StructWithUnion)z.value);
            this.assertEquals("testStructWithUnion(): Incorrect return value", x, ret);
        }
    }

    @Test
    public void testEmptyChoice() throws Exception {
        EmptyChoice x = new EmptyChoice();
        EmptyChoice yOrig = new EmptyChoice();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        EmptyChoice ret = testDocLiteral ? docClient.testEmptyChoice(x, y, z) : (testXMLBinding ? xmlClient.testEmptyChoice(x, y, z) : rpcClient.testEmptyChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testEmptyChoice(): Null value for inout param", (boolean)this.notNull(x, y.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyChoice(): Null value for out param", (boolean)this.notNull(yOrig, z.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyChoice(): Null return value", (boolean)this.notNull(x, ret));
        }
    }

    protected boolean equals(SimpleChoice x, SimpleChoice y) {
        if (x.getVarFloat() != null && y.getVarFloat() != null) {
            return x.getVarFloat().compareTo(y.getVarFloat()) == 0;
        }
        if (x.getVarInt() != null && y.getVarInt() != null) {
            return x.getVarInt().compareTo(y.getVarInt()) == 0;
        }
        if (x.getVarString() != null && y.getVarString() != null) {
            return x.getVarString().equals(y.getVarString());
        }
        return false;
    }

    @Test
    public void testSimpleChoice() throws Exception {
        SimpleChoice x = new SimpleChoice();
        x.setVarFloat(Float.valueOf(-3.14f));
        SimpleChoice yOrig = new SimpleChoice();
        yOrig.setVarString("Cheerio");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SimpleChoice ret = testDocLiteral ? docClient.testSimpleChoice(x, y, z) : (testXMLBinding ? xmlClient.testSimpleChoice(x, y, z) : rpcClient.testSimpleChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testSimpleChoice(): Incorrect value for inout param", (boolean)this.equals(x, (SimpleChoice)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testSimpleChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (SimpleChoice)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testSimpleChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testEmptyAll() throws Exception {
        EmptyAll x = new EmptyAll();
        EmptyAll yOrig = new EmptyAll();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        EmptyAll ret = testDocLiteral ? docClient.testEmptyAll(x, y, z) : (testXMLBinding ? xmlClient.testEmptyAll(x, y, z) : rpcClient.testEmptyAll(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testEmptyAll(): Null value for inout param", (boolean)this.notNull(x, y.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyAll(): Null value for out param", (boolean)this.notNull(yOrig, z.value));
            AbstractTypeTestClient2.assertTrue((String)"testEmptyAll(): Null return value", (boolean)this.notNull(x, ret));
        }
    }

    protected boolean equals(SimpleAll x, SimpleAll y) {
        return x.getVarFloat() == y.getVarFloat() && x.getVarInt() == y.getVarInt() && x.getVarString().equals(y.getVarString()) && x.getVarAttrString().equals(y.getVarAttrString());
    }

    @Test
    public void testSimpleAll() throws Exception {
        SimpleAll x = new SimpleAll();
        x.setVarFloat(3.14f);
        x.setVarInt(42);
        x.setVarString("Hello There");
        x.setVarAttrString("Attr-x");
        SimpleAll yOrig = new SimpleAll();
        yOrig.setVarFloat(-9.14f);
        yOrig.setVarInt(10);
        yOrig.setVarString("Cheerio");
        yOrig.setVarAttrString("Attr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SimpleAll ret = testDocLiteral ? docClient.testSimpleAll(x, y, z) : (testXMLBinding ? xmlClient.testSimpleAll(x, y, z) : rpcClient.testSimpleAll(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testSimpleAll(): Incorrect value for inout param", (boolean)this.equals(x, (SimpleAll)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testSimpleAll(): Incorrect value for out param", (boolean)this.equals(yOrig, (SimpleAll)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testSimpleAll(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(StructWithOptionals x, StructWithOptionals y) {
        return this.equalsNilable(x.getVarFloat(), y.getVarFloat()) && this.equalsNilable(x.getVarInt(), x.getVarInt()) && this.equalsNilable(x.getVarString(), y.getVarString()) && this.equalsNilable(x.getVarStruct(), y.getVarStruct());
    }

    @Test
    public void testStructWithOptionals() throws Exception {
        StructWithOptionals x = new StructWithOptionals();
        StructWithOptionals yOrig = new StructWithOptionals();
        yOrig.setVarFloat(new Float(1.414f));
        yOrig.setVarInt(new Integer(13));
        yOrig.setVarString("Cheerio");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithOptionals ret = testDocLiteral ? docClient.testStructWithOptionals(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOptionals(x, y, z) : rpcClient.testStructWithOptionals(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testStructWithOptionals(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOptionals)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithOptionals(): Incorrect value for out param", (boolean)this.equals(yOrig, (StructWithOptionals)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithOptionals(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(RecursiveStruct x, RecursiveStruct y) {
        return x.getVarFloat() == y.getVarFloat() && x.getVarInt() == y.getVarInt() && x.getVarString().equals(y.getVarString()) && this.equals(x.getVarStructArray(), y.getVarStructArray());
    }

    @Test
    public void testRecursiveStruct() throws Exception {
        RecursiveStruct xtmp = new RecursiveStruct();
        xtmp.setVarFloat(0.14f);
        xtmp.setVarInt(4);
        xtmp.setVarString("tmp-x");
        xtmp.setVarStructArray(new RecursiveStructArray());
        RecursiveStruct ytmp = new RecursiveStruct();
        ytmp.setVarFloat(0.414f);
        ytmp.setVarInt(1);
        ytmp.setVarString("tmp-y");
        ytmp.setVarStructArray(new RecursiveStructArray());
        RecursiveStructArray arr = new RecursiveStructArray();
        arr.getItem().add(xtmp);
        arr.getItem().add(ytmp);
        RecursiveStruct x = new RecursiveStruct();
        x.setVarFloat(3.14f);
        x.setVarInt(42);
        x.setVarString("RecStruct-x");
        x.setVarStructArray(arr);
        RecursiveStruct yOrig = new RecursiveStruct();
        yOrig.setVarFloat(1.414f);
        yOrig.setVarInt(13);
        yOrig.setVarString("RecStruct-y");
        yOrig.setVarStructArray(arr);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RecursiveStruct ret = testDocLiteral ? docClient.testRecursiveStruct(x, y, z) : (testXMLBinding ? xmlClient.testRecursiveStruct(x, y, z) : rpcClient.testRecursiveStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveStruct(): Incorrect value for inout param", (boolean)this.equals(x, (RecursiveStruct)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (RecursiveStruct)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveStruct(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(RecursiveStructArray x, RecursiveStructArray y) {
        List xx = x.getItem();
        List yy = y.getItem();
        if (xx.isEmpty() && yy.isEmpty()) {
            return true;
        }
        if (xx.size() != yy.size()) {
            return false;
        }
        for (int i = 0; i < xx.size(); ++i) {
            if (this.equals((RecursiveStruct)xx.get(i), (RecursiveStruct)yy.get(i))) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testRecursiveStructArray() throws Exception {
        RecursiveStruct xtmp = new RecursiveStruct();
        xtmp.setVarFloat(0.14f);
        xtmp.setVarInt(4);
        xtmp.setVarString("tmp-x");
        xtmp.setVarStructArray(new RecursiveStructArray());
        RecursiveStruct ytmp = new RecursiveStruct();
        ytmp.setVarFloat(0.414f);
        ytmp.setVarInt(1);
        ytmp.setVarString("tmp-y");
        ytmp.setVarStructArray(new RecursiveStructArray());
        RecursiveStructArray x = new RecursiveStructArray();
        x.getItem().add(xtmp);
        x.getItem().add(ytmp);
        RecursiveStructArray yOrig = new RecursiveStructArray();
        yOrig.getItem().add(ytmp);
        yOrig.getItem().add(xtmp);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RecursiveStructArray ret = testDocLiteral ? docClient.testRecursiveStructArray(x, y, z) : (testXMLBinding ? xmlClient.testRecursiveStructArray(x, y, z) : rpcClient.testRecursiveStructArray(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveStructArray(): Incorrect value for inout param", (boolean)this.equals(x, (RecursiveStructArray)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveStructArray(): Incorrect value for out param", (boolean)this.equals(yOrig, (RecursiveStructArray)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveStructArray(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(RecursiveUnion x, RecursiveUnion y) {
        if (x.getVarString() != null && y.getVarString() != null) {
            return x.getVarString().equals(y.getVarString());
        }
        if (x.getVarChoice() != null && y.getVarChoice() != null) {
            return this.equals(x.getVarChoice(), y.getVarChoice());
        }
        return false;
    }

    @Test
    public void testRecursiveUnion() throws Exception {
        RecursiveUnion tmp1 = new RecursiveUnion();
        tmp1.setVarString("RecusiveUnion-1");
        RecursiveUnion tmp2 = new RecursiveUnion();
        tmp2.setVarString("RecusiveUnion-2");
        RecursiveUnionData xData = new RecursiveUnionData();
        ChoiceArray xChoice = new ChoiceArray();
        xChoice.getItem().add(tmp1);
        xChoice.getItem().add(tmp2);
        xData.setVarInt(5);
        xData.setVarChoiceArray(xChoice);
        RecursiveUnion x = new RecursiveUnion();
        x.setVarChoice(xData);
        RecursiveUnionData yData = new RecursiveUnionData();
        ChoiceArray yChoice = new ChoiceArray();
        yChoice.getItem().add(tmp1);
        yChoice.getItem().add(tmp2);
        yData.setVarInt(-5);
        yData.setVarChoiceArray(yChoice);
        RecursiveUnion yOrig = new RecursiveUnion();
        yOrig.setVarChoice(yData);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RecursiveUnion ret = testDocLiteral ? docClient.testRecursiveUnion(x, y, z) : (testXMLBinding ? xmlClient.testRecursiveUnion(x, y, z) : rpcClient.testRecursiveUnion(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveUnion(): Incorrect value for inout param", (boolean)this.equals(x, (RecursiveUnion)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveUnion(): Incorrect value for out param", (boolean)this.equals(yOrig, (RecursiveUnion)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveUnion(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(RecursiveUnionData x, RecursiveUnionData y) {
        return x.getVarInt() == y.getVarInt() && this.equals(x.getVarChoiceArray(), y.getVarChoiceArray());
    }

    @Test
    public void testRecursiveUnionData() throws Exception {
        RecursiveUnion tmp1 = new RecursiveUnion();
        tmp1.setVarString("RecusiveUnion-1");
        RecursiveUnion tmp2 = new RecursiveUnion();
        tmp2.setVarString("RecusiveUnion-2");
        RecursiveUnionData x = new RecursiveUnionData();
        ChoiceArray xChoice = new ChoiceArray();
        xChoice.getItem().add(tmp1);
        xChoice.getItem().add(tmp2);
        x.setVarInt(5);
        x.setVarChoiceArray(xChoice);
        RecursiveUnionData yOrig = new RecursiveUnionData();
        ChoiceArray yOrigchoice = new ChoiceArray();
        xChoice.getItem().add(tmp1);
        xChoice.getItem().add(tmp2);
        yOrig.setVarInt(-5);
        yOrig.setVarChoiceArray(yOrigchoice);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RecursiveUnionData ret = testDocLiteral ? docClient.testRecursiveUnionData(x, y, z) : (testXMLBinding ? xmlClient.testRecursiveUnionData(x, y, z) : rpcClient.testRecursiveUnionData(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveUnionData(): Incorrect value for inout param", (boolean)this.equals(x, (RecursiveUnionData)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveUnionData(): Incorrect value for out param", (boolean)this.equals(yOrig, (RecursiveUnionData)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecursiveUnionData(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(ChoiceArray x, ChoiceArray y) {
        List xx = x.getItem();
        List yy = y.getItem();
        if (xx.isEmpty() && yy.isEmpty()) {
            return true;
        }
        if (xx.size() != yy.size()) {
            return false;
        }
        for (int i = 0; i < xx.size(); ++i) {
            if (this.equals((RecursiveUnion)xx.get(i), (RecursiveUnion)yy.get(i))) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testChoiceArray() throws Exception {
        RecursiveUnion tmp1 = new RecursiveUnion();
        tmp1.setVarString("RecusiveUnion-1");
        RecursiveUnion tmp2 = new RecursiveUnion();
        tmp2.setVarString("RecusiveUnion-2");
        ChoiceArray x = new ChoiceArray();
        x.getItem().add(tmp1);
        x.getItem().add(tmp2);
        ChoiceArray yOrig = new ChoiceArray();
        yOrig.getItem().add(tmp2);
        yOrig.getItem().add(tmp1);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceArray ret = testDocLiteral ? docClient.testChoiceArray(x, y, z) : (testXMLBinding ? xmlClient.testChoiceArray(x, y, z) : rpcClient.testChoiceArray(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testChoiceArray(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceArray)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceArray(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceArray)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceArray(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    @Test
    public void testExtendsSimpleType() throws Exception {
        ExtendsSimpleType x = new ExtendsSimpleType();
        x.setValue("foo");
        ExtendsSimpleType yOriginal = new ExtendsSimpleType();
        yOriginal.setValue("bar");
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        ExtendsSimpleType ret = testDocLiteral ? docClient.testExtendsSimpleType(x, y, z) : (testXMLBinding ? xmlClient.testExtendsSimpleType(x, y, z) : rpcClient.testExtendsSimpleType(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertEquals((Object)x.getValue(), (Object)((ExtendsSimpleType)y.value).getValue());
            AbstractTypeTestClient2.assertEquals((Object)yOriginal.getValue(), (Object)((ExtendsSimpleType)z.value).getValue());
            AbstractTypeTestClient2.assertEquals((Object)x.getValue(), (Object)ret.getValue());
        }
    }

    @Test
    public void testExtendsSimpleContent() throws Exception {
        ExtendsSimpleContent x = new ExtendsSimpleContent();
        x.setValue("foo");
        ExtendsSimpleContent yOriginal = new ExtendsSimpleContent();
        yOriginal.setValue("bar");
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        ExtendsSimpleContent ret = testDocLiteral ? docClient.testExtendsSimpleContent(x, y, z) : (testXMLBinding ? xmlClient.testExtendsSimpleContent(x, y, z) : rpcClient.testExtendsSimpleContent(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertEquals((Object)x.getValue(), (Object)((ExtendsSimpleContent)y.value).getValue());
            AbstractTypeTestClient2.assertEquals((Object)yOriginal.getValue(), (Object)((ExtendsSimpleContent)z.value).getValue());
            AbstractTypeTestClient2.assertEquals((Object)x.getValue(), (Object)ret.getValue());
        }
    }

    protected void equals(String msg, Document x, Document y) throws Exception {
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getValue(), (Object)y.getValue());
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getID(), (Object)y.getID());
    }

    @Test
    public void testDocument() throws Exception {
        Document x = new Document();
        x.setValue("content-x");
        x.setID("Hello There");
        Document yOrig = new Document();
        yOrig.setID("Cheerio");
        yOrig.setValue("content-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        Document ret = testDocLiteral ? docClient.testDocument(x, y, z) : (testXMLBinding ? xmlClient.testDocument(x, y, z) : rpcClient.testDocument(x, y, z));
        if (!this.perfTestOnly) {
            this.equals("testDocument(): Incorrect value for inout param", x, (Document)y.value);
            this.equals("testDocument(): Incorrect value for out param", yOrig, (Document)z.value);
            this.equals("testDocument(): Incorrect return value", x, ret);
        }
        x = new Document();
        yOrig = new Document();
        x.setValue("content-x");
        yOrig.setValue("content-y");
        x.setID(null);
        yOrig.setID(null);
        y = new Holder((Object)yOrig);
        z = new Holder();
        ret = testDocLiteral ? docClient.testDocument(x, y, z) : (testXMLBinding ? xmlClient.testDocument(x, y, z) : rpcClient.testDocument(x, y, z));
        if (!this.perfTestOnly) {
            this.equals("testDocument(): Incorrect value for inout param", x, (Document)y.value);
            this.equals("testDocument(): Incorrect value for out param", yOrig, (Document)z.value);
            this.equals("testDocument(): Incorrect return value", x, ret);
            AbstractTypeTestClient2.assertNull((Object)((Document)y.value).getID());
            AbstractTypeTestClient2.assertNull((Object)ret.getID());
        }
    }

    protected boolean equals(ExtColourEnum x, ExtColourEnum y) {
        return x.getAttrib1().equals(y.getAttrib1()) && x.getAttrib2().equals(y.getAttrib2()) && x.getValue().equals((Object)y.getValue());
    }

    @Test
    public void testExtColourEnum() throws Exception {
        ExtColourEnum x = new ExtColourEnum();
        x.setAttrib1(new Integer(1));
        x.setAttrib2("Ax");
        x.setValue(ColourEnum.fromValue((String)"RED"));
        ExtColourEnum yOrig = new ExtColourEnum();
        yOrig.setAttrib1(new Integer(10));
        yOrig.setAttrib2("Ay");
        yOrig.setValue(ColourEnum.fromValue((String)"GREEN"));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ExtColourEnum ret = testDocLiteral ? docClient.testExtColourEnum(x, y, z) : (testXMLBinding ? xmlClient.testExtColourEnum(x, y, z) : rpcClient.testExtColourEnum(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testExtColourEnum(): Incorrect value for inout param", (boolean)this.equals(x, (ExtColourEnum)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testExtColourEnum(): Incorrect value for out param", (boolean)this.equals(yOrig, (ExtColourEnum)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testExtColourEnum(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ExtBase64Binary x, ExtBase64Binary y) {
        return x.getId() == y.getId() && Arrays.equals(x.getValue(), y.getValue());
    }

    @Test
    public void testExtBase64Binary() throws Exception {
        ExtBase64Binary x1 = new ExtBase64Binary();
        x1.setValue("base64a".getBytes());
        x1.setId(Integer.valueOf(1));
        ExtBase64Binary y1 = new ExtBase64Binary();
        y1.setValue("base64b".getBytes());
        y1.setId(Integer.valueOf(2));
        Holder y1Holder = new Holder((Object)y1);
        Holder z1 = new Holder();
        ExtBase64Binary ret = testDocLiteral ? docClient.testExtBase64Binary(x1, y1Holder, z1) : (testXMLBinding ? xmlClient.testExtBase64Binary(x1, y1Holder, z1) : rpcClient.testExtBase64Binary(x1, y1Holder, z1));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testExtBase64Binary(): Incorrect value for inout param", (boolean)this.equals(x1, (ExtBase64Binary)y1Holder.value));
            AbstractTypeTestClient2.assertTrue((String)"testExtBase64Binary(): Incorrect value for out param", (boolean)this.equals(y1, (ExtBase64Binary)z1.value));
            AbstractTypeTestClient2.assertTrue((String)"testExtBase64Binary(): Incorrect return value", (boolean)this.equals(x1, ret));
        }
    }

    protected boolean equals(StructWithSubstitutionGroup x, StructWithSubstitutionGroup y) {
        if (!x.getSg01BaseElementA().isNil() && !y.getSg01BaseElementA().isNil()) {
            SgBaseTypeA xTypeA = (SgBaseTypeA)x.getSg01BaseElementA().getValue();
            SgBaseTypeA yTypeA = (SgBaseTypeA)y.getSg01BaseElementA().getValue();
            return this.equals(xTypeA, yTypeA);
        }
        return false;
    }

    @Test
    public void testStructWithSubstitutionGroup() throws Exception {
        SgBaseTypeA baseA = new SgBaseTypeA();
        baseA.setVarInt(new BigInteger("1"));
        SgDerivedTypeB derivedB = new SgDerivedTypeB();
        derivedB.setVarInt(new BigInteger("32"));
        derivedB.setVarString("foo");
        ObjectFactory objectFactory = new ObjectFactory();
        StructWithSubstitutionGroup x = new StructWithSubstitutionGroup();
        JAXBElement elementA = objectFactory.createSg01BaseElementA(baseA);
        x.setSg01BaseElementA(elementA);
        StructWithSubstitutionGroup yOrig = new StructWithSubstitutionGroup();
        JAXBElement elementB = objectFactory.createSg01DerivedElementB(derivedB);
        yOrig.setSg01BaseElementA(elementB);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithSubstitutionGroup ret = testDocLiteral ? docClient.testStructWithSubstitutionGroup(x, y, z) : (testXMLBinding ? xmlClient.testStructWithSubstitutionGroup(x, y, z) : rpcClient.testStructWithSubstitutionGroup(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroup(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithSubstitutionGroup)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroup(): Incorrect value for out param", (boolean)this.equals(yOrig, (StructWithSubstitutionGroup)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroup(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(StructWithSubstitutionGroupAbstract x, StructWithSubstitutionGroupAbstract y) {
        if (x.getSg03AbstractBaseElementA() != null && y.getSg03AbstractBaseElementA() != null) {
            SgBaseTypeA xTypeA = (SgBaseTypeA)x.getSg03AbstractBaseElementA().getValue();
            SgBaseTypeA yTypeA = (SgBaseTypeA)y.getSg03AbstractBaseElementA().getValue();
            return this.equals(xTypeA, yTypeA);
        }
        return false;
    }

    @Test
    public void testStructWithSubstitutionGroupAbstract() throws Exception {
        SgDerivedTypeB derivedB = new SgDerivedTypeB();
        derivedB.setVarInt(new BigInteger("32"));
        derivedB.setVarString("foo");
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement elementB = objectFactory.createSg03DerivedElementB(derivedB);
        SgDerivedTypeC derivedC = new SgDerivedTypeC();
        derivedC.setVarInt(new BigInteger("32"));
        derivedC.setVarFloat((double)3.14f);
        JAXBElement elementC = objectFactory.createSg03DerivedElementC(derivedC);
        StructWithSubstitutionGroupAbstract x = new StructWithSubstitutionGroupAbstract();
        x.setSg03AbstractBaseElementA(elementC);
        StructWithSubstitutionGroupAbstract yOrig = new StructWithSubstitutionGroupAbstract();
        yOrig.setSg03AbstractBaseElementA(elementB);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithSubstitutionGroupAbstract ret = testDocLiteral ? docClient.testStructWithSubstitutionGroupAbstract(x, y, z) : (testXMLBinding ? xmlClient.testStructWithSubstitutionGroupAbstract(x, y, z) : rpcClient.testStructWithSubstitutionGroupAbstract(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroupAbstract(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithSubstitutionGroupAbstract)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroupAbstract(): Incorrect value for out param", (boolean)this.equals(yOrig, (StructWithSubstitutionGroupAbstract)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroupAbstract(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(StructWithSubstitutionGroupNil x, StructWithSubstitutionGroupNil y) {
        if (x.getSg04NillableBaseElementA().isNil()) {
            return y.getSg04NillableBaseElementA().isNil();
        }
        if (y.getSg04NillableBaseElementA().isNil()) {
            return false;
        }
        SgBaseTypeA xTypeA = (SgBaseTypeA)x.getSg04NillableBaseElementA().getValue();
        SgBaseTypeA yTypeA = (SgBaseTypeA)y.getSg04NillableBaseElementA().getValue();
        return this.equals(xTypeA, yTypeA);
    }

    @Test
    public void testStructWithSubstitutionGroupNil() throws Exception {
        StructWithSubstitutionGroupNil x = new StructWithSubstitutionGroupNil();
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement element = objectFactory.createSg04NillableBaseElementA(null);
        x.setSg04NillableBaseElementA(element);
        StructWithSubstitutionGroupNil yOrig = new StructWithSubstitutionGroupNil();
        element = objectFactory.createSg04NillableBaseElementA(null);
        yOrig.setSg04NillableBaseElementA(element);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithSubstitutionGroupNil ret = testDocLiteral ? docClient.testStructWithSubstitutionGroupNil(x, y, z) : (testXMLBinding ? xmlClient.testStructWithSubstitutionGroupNil(x, y, z) : rpcClient.testStructWithSubstitutionGroupNil(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroupNil(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithSubstitutionGroupNil)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroupNil(): Incorrect value for out param", (boolean)this.equals(yOrig, (StructWithSubstitutionGroupNil)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithSubstitutionGroupNil(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(StructWithMultipleSubstitutionGroups x, StructWithMultipleSubstitutionGroups y) {
        SgBaseTypeA yTypeA;
        SgBaseTypeA xTypeA;
        if (Double.compare(x.getVarFloat(), y.getVarFloat()) != 0) {
            return false;
        }
        if (x.getVarInt().compareTo(y.getVarInt()) != 0) {
            return false;
        }
        if (!x.getVarString().equals(y.getVarString())) {
            return false;
        }
        if (x.getSg01BaseElementA().isNil()) {
            if (!y.getSg01BaseElementA().isNil()) {
                return false;
            }
        } else {
            if (y.getSg01BaseElementA().isNil()) {
                return false;
            }
            xTypeA = (SgBaseTypeA)x.getSg01BaseElementA().getValue();
            if (!this.equals(xTypeA, yTypeA = (SgBaseTypeA)y.getSg01BaseElementA().getValue())) {
                return false;
            }
        }
        if (x.getSg02BaseElementA().isNil()) {
            return y.getSg02BaseElementA().isNil();
        }
        if (y.getSg02BaseElementA().isNil()) {
            return false;
        }
        xTypeA = (SgBaseTypeA)x.getSg02BaseElementA().getValue();
        yTypeA = (SgBaseTypeA)y.getSg02BaseElementA().getValue();
        return this.equals(xTypeA, yTypeA);
    }

    @Test
    public void testStructWithMultipleSubstitutionGroups() throws Exception {
        SgBaseTypeA baseA = new SgBaseTypeA();
        baseA.setVarInt(new BigInteger("1"));
        SgDerivedTypeB derivedB = new SgDerivedTypeB();
        derivedB.setVarInt(new BigInteger("32"));
        derivedB.setVarString("y-SgDerivedTypeB");
        SgDerivedTypeC derivedC = new SgDerivedTypeC();
        derivedC.setVarInt(new BigInteger("1"));
        derivedC.setVarFloat((double)3.14f);
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement x1 = objectFactory.createSg01DerivedElementB(derivedB);
        JAXBElement x2 = objectFactory.createSg02BaseElementA(baseA);
        JAXBElement y1 = objectFactory.createSg01DerivedElementB(derivedB);
        JAXBElement y2 = objectFactory.createSg02DerivedElementC(derivedC);
        StructWithMultipleSubstitutionGroups x = new StructWithMultipleSubstitutionGroups();
        x.setVarFloat((double)111.1f);
        x.setVarInt(new BigInteger("100"));
        x.setVarString("x-varString");
        x.setSg01BaseElementA(x1);
        x.setSg02BaseElementA(x2);
        StructWithMultipleSubstitutionGroups yOrig = new StructWithMultipleSubstitutionGroups();
        yOrig.setVarFloat((double)1.1f);
        yOrig.setVarInt(new BigInteger("10"));
        yOrig.setVarString("y-varString");
        yOrig.setSg01BaseElementA(y1);
        yOrig.setSg02BaseElementA(y2);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithMultipleSubstitutionGroups ret = testDocLiteral ? docClient.testStructWithMultipleSubstitutionGroups(x, y, z) : (testXMLBinding ? xmlClient.testStructWithMultipleSubstitutionGroups(x, y, z) : rpcClient.testStructWithMultipleSubstitutionGroups(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testStructWithMultipleSubstitutionGroups(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithMultipleSubstitutionGroups)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithMultipleSubstitutionGroups(): Incorrect value for out param", (boolean)this.equals(yOrig, (StructWithMultipleSubstitutionGroups)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testStructWithMultipleSubstitutionGroups(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ChoiceWithSubstitutionGroupAbstract x, ChoiceWithSubstitutionGroupAbstract y) {
        if (x.getVarInt() != null && y.getVarInt() != null && x.getVarInt().equals(y.getVarInt())) {
            return true;
        }
        if (!x.getSg03AbstractBaseElementA().isNil() && !y.getSg03AbstractBaseElementA().isNil()) {
            SgBaseTypeA xTypeA = (SgBaseTypeA)x.getSg03AbstractBaseElementA().getValue();
            SgBaseTypeA yTypeA = (SgBaseTypeA)y.getSg03AbstractBaseElementA().getValue();
            return this.equals(xTypeA, yTypeA);
        }
        return false;
    }

    @Test
    public void testChoiceWithSubstitutionGroupAbstract() throws Exception {
        SgDerivedTypeB derivedB = new SgDerivedTypeB();
        derivedB.setVarInt(new BigInteger("32"));
        derivedB.setVarString("foo");
        SgDerivedTypeC derivedC = new SgDerivedTypeC();
        derivedC.setVarInt(new BigInteger("32"));
        derivedC.setVarFloat((double)3.14f);
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement elementB = objectFactory.createSg03DerivedElementB(derivedB);
        JAXBElement elementC = objectFactory.createSg03DerivedElementC(derivedC);
        ChoiceWithSubstitutionGroupAbstract x = new ChoiceWithSubstitutionGroupAbstract();
        x.setSg03AbstractBaseElementA(elementC);
        ChoiceWithSubstitutionGroupAbstract yOrig = new ChoiceWithSubstitutionGroupAbstract();
        yOrig.setSg03AbstractBaseElementA(elementB);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceWithSubstitutionGroupAbstract ret = testDocLiteral ? docClient.testChoiceWithSubstitutionGroupAbstract(x, y, z) : (testXMLBinding ? xmlClient.testChoiceWithSubstitutionGroupAbstract(x, y, z) : rpcClient.testChoiceWithSubstitutionGroupAbstract(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroupAbstract(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithSubstitutionGroupAbstract)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroupAbstract(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceWithSubstitutionGroupAbstract)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroupAbstract(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ChoiceWithSubstitutionGroupNil x, ChoiceWithSubstitutionGroupNil y) {
        if (x.getVarInt() != null) {
            if (y.getVarInt() == null) {
                return false;
            }
            if (x.getVarInt().isNil()) {
                return y.getVarInt().isNil();
            }
            if (y.getVarInt().isNil()) {
                return false;
            }
            return ((BigInteger)x.getVarInt().getValue()).equals(y.getVarInt().getValue());
        }
        if (y.getVarInt() != null) {
            return false;
        }
        if (x.getSg04NillableBaseElementA() != null) {
            if (y.getSg04NillableBaseElementA() == null) {
                return false;
            }
            if (x.getSg04NillableBaseElementA().isNil()) {
                return y.getSg04NillableBaseElementA().isNil();
            }
            if (y.getSg04NillableBaseElementA().isNil()) {
                return false;
            }
            SgBaseTypeA xTypeA = (SgBaseTypeA)x.getSg04NillableBaseElementA().getValue();
            SgBaseTypeA yTypeA = (SgBaseTypeA)y.getSg04NillableBaseElementA().getValue();
            return this.equals(xTypeA, yTypeA);
        }
        return y.getSg04NillableBaseElementA() == null;
    }

    @Test
    public void testChoiceWithSubstitutionGroupNil() throws Exception {
        ObjectFactory objectFactory = new ObjectFactory();
        ChoiceWithSubstitutionGroupNil x = new ChoiceWithSubstitutionGroupNil();
        JAXBElement varInt = objectFactory.createChoiceWithSubstitutionGroupNilVarInt(null);
        x.setVarInt(varInt);
        ChoiceWithSubstitutionGroupNil yOrig = new ChoiceWithSubstitutionGroupNil();
        JAXBElement elementA = objectFactory.createSg04NillableBaseElementA(null);
        yOrig.setSg04NillableBaseElementA(elementA);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceWithSubstitutionGroupNil ret = testDocLiteral ? docClient.testChoiceWithSubstitutionGroupNil(x, y, z) : (testXMLBinding ? xmlClient.testChoiceWithSubstitutionGroupNil(x, y, z) : rpcClient.testChoiceWithSubstitutionGroupNil(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroupNil(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithSubstitutionGroupNil)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroupNil(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceWithSubstitutionGroupNil)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroupNil(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(SgBaseTypeA x, SgBaseTypeA y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        if (x.getVarInt().compareTo(y.getVarInt()) != 0) {
            return false;
        }
        if (x instanceof SgDerivedTypeC) {
            if (y instanceof SgDerivedTypeC) {
                SgDerivedTypeC xTypeC = (SgDerivedTypeC)x;
                SgDerivedTypeC yTypeC = (SgDerivedTypeC)y;
                return this.equals(xTypeC, yTypeC);
            }
            return false;
        }
        if (x instanceof SgDerivedTypeB) {
            if (y instanceof SgDerivedTypeB) {
                SgDerivedTypeB xTypeB = (SgDerivedTypeB)x;
                SgDerivedTypeB yTypeB = (SgDerivedTypeB)y;
                return this.equals(xTypeB, yTypeB);
            }
            return false;
        }
        return true;
    }

    protected boolean equals(SgDerivedTypeB x, SgDerivedTypeB y) {
        return x.getVarString().equals(y.getVarString());
    }

    protected boolean equals(SgDerivedTypeC x, SgDerivedTypeC y) {
        return Double.compare(x.getVarFloat(), y.getVarFloat()) == 0;
    }

    protected boolean equals(ChoiceWithSubstitutionGroup x, ChoiceWithSubstitutionGroup y) {
        if (x.getVarInt() != null && y.getVarInt() != null && x.getVarInt().compareTo(y.getVarInt()) == 0) {
            return true;
        }
        if (!x.getSg01BaseElementA().isNil() && !y.getSg01BaseElementA().isNil()) {
            SgBaseTypeA xTypeA = (SgBaseTypeA)x.getSg01BaseElementA().getValue();
            SgBaseTypeA yTypeA = (SgBaseTypeA)y.getSg01BaseElementA().getValue();
            return this.equals(xTypeA, yTypeA);
        }
        return false;
    }

    @Test
    public void testChoiceWithSubstitutionGroup() throws Exception {
        SgBaseTypeA baseA = new SgBaseTypeA();
        baseA.setVarInt(new BigInteger("1"));
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement elementA = objectFactory.createSg01BaseElementA(baseA);
        SgDerivedTypeB derivedB = new SgDerivedTypeB();
        derivedB.setVarInt(new BigInteger("32"));
        derivedB.setVarString("SgDerivedTypeB");
        JAXBElement elementB = objectFactory.createSg01DerivedElementB(derivedB);
        ChoiceWithSubstitutionGroup x = new ChoiceWithSubstitutionGroup();
        x.setSg01BaseElementA(elementA);
        ChoiceWithSubstitutionGroup yOrig = new ChoiceWithSubstitutionGroup();
        yOrig.setSg01BaseElementA(elementB);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        AbstractTypeTestClient2.assertTrue((String)"yoo: ", (boolean)this.equals((ChoiceWithSubstitutionGroup)y.value, (ChoiceWithSubstitutionGroup)y.value));
        ChoiceWithSubstitutionGroup ret = testDocLiteral ? docClient.testChoiceWithSubstitutionGroup(x, y, z) : (testXMLBinding ? xmlClient.testChoiceWithSubstitutionGroup(x, y, z) : rpcClient.testChoiceWithSubstitutionGroup(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroup(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithSubstitutionGroup)y.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroup(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceWithSubstitutionGroup)z.value));
            AbstractTypeTestClient2.assertTrue((String)"testChoiceWithSubstitutionGroup(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(RecElNextType x, RecElNextType y) {
        List xx = x.getRecEl();
        List yy = y.getRecEl();
        if (xx.size() != yy.size()) {
            return false;
        }
        for (int i = 0; i < xx.size(); ++i) {
            if (this.equals((RecElType)xx.get(i), (RecElType)yy.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(RecElType x, RecElType y) {
        return x.getVarInt() == y.getVarInt() && this.equals(x.getRecElNext(), y.getRecElNext());
    }

    @Test
    public void testRecElType() throws Exception {
        RecElType x = new RecElType();
        RecElType y = new RecElType();
        RecElNextType xn = new RecElNextType();
        RecElNextType yn = new RecElNextType();
        y.setVarInt(123);
        y.setRecElNext(yn);
        xn.getRecEl().add(y);
        x.setVarInt(456);
        x.setRecElNext(xn);
        Holder yh = new Holder((Object)y);
        Holder zh = new Holder();
        RecElType ret = testDocLiteral ? docClient.testRecElType(x, yh, zh) : (testXMLBinding ? xmlClient.testRecElType(x, yh, zh) : rpcClient.testRecElType(x, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testRecElType(): Incorrect value for inout param", (boolean)this.equals(x, (RecElType)yh.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecElType(): Incorrect value for inout param", (boolean)this.equals(y, (RecElType)zh.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecElType(): Incorrect value for inout param", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(RecMostInnerType x, RecMostInnerType y) {
        return x.getVarInt() == y.getVarInt() && this.equals(x.getRecMostInnerNext(), y.getRecMostInnerNext());
    }

    protected boolean equals(RecMostInnerNextType x, RecMostInnerNextType y) {
        List xx = x.getRecMostInner();
        List yy = y.getRecMostInner();
        if (xx.size() != yy.size()) {
            return false;
        }
        for (int i = 0; i < xx.size(); ++i) {
            if (this.equals((RecMostInnerType)xx.get(i), (RecMostInnerType)yy.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(RecInnerType x, RecInnerType y) {
        List mitx = x.getRecMostInner();
        List mity = y.getRecMostInner();
        if (mitx.size() != mity.size()) {
            return false;
        }
        for (int i = 0; i < mitx.size(); ++i) {
            if (this.equals((RecMostInnerType)mitx.get(i), (RecMostInnerType)mity.get(i))) continue;
            return false;
        }
        return x.getVarInt() == y.getVarInt() && this.equals(x.getRecInnerNext(), y.getRecInnerNext());
    }

    protected boolean equals(RecInnerNextType x, RecInnerNextType y) {
        List xx = x.getRecInner();
        List yy = y.getRecInner();
        if (xx.size() != yy.size()) {
            return false;
        }
        for (int i = 0; i < xx.size(); ++i) {
            if (this.equals((RecInnerType)xx.get(i), (RecInnerType)yy.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(RecOuterNextType x, RecOuterNextType y) {
        List xx = x.getRecOuter();
        List yy = y.getRecOuter();
        if (xx.size() != yy.size()) {
            return false;
        }
        for (int i = 0; i < xx.size(); ++i) {
            if (this.equals((RecOuterType)xx.get(i), (RecOuterType)yy.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(RecOuterType x, RecOuterType y) {
        int i;
        List mitx = x.getRecMostInner();
        List mity = y.getRecMostInner();
        List itx = x.getRecInner();
        List ity = y.getRecInner();
        if (mitx.size() != mity.size() || itx.size() != ity.size()) {
            return false;
        }
        for (i = 0; i < mitx.size(); ++i) {
            if (this.equals((RecMostInnerType)mitx.get(i), (RecMostInnerType)mity.get(i))) continue;
            return false;
        }
        for (i = 0; i < itx.size(); ++i) {
            if (this.equals((RecInnerType)itx.get(i), (RecInnerType)ity.get(i))) continue;
            return false;
        }
        return x.getVarInt() == y.getVarInt() && this.equals(x.getRecOuterNext(), y.getRecOuterNext());
    }

    @Test
    public void testRecOuterType() throws Exception {
        RecMostInnerType mitx = new RecMostInnerType();
        RecMostInnerType mity = new RecMostInnerType();
        RecMostInnerNextType mitxNext = new RecMostInnerNextType();
        RecMostInnerNextType mityNext = new RecMostInnerNextType();
        mitx.setRecMostInnerNext(mitxNext);
        mity.setRecMostInnerNext(mityNext);
        RecInnerType itx = new RecInnerType();
        RecInnerType ity = new RecInnerType();
        RecInnerNextType itxNext = new RecInnerNextType();
        RecInnerNextType ityNext = new RecInnerNextType();
        itx.setRecInnerNext(itxNext);
        ity.setRecInnerNext(ityNext);
        RecOuterType otx = new RecOuterType();
        RecOuterType oty = new RecOuterType();
        RecOuterNextType otxNext = new RecOuterNextType();
        RecOuterNextType otyNext = new RecOuterNextType();
        otx.setRecOuterNext(otxNext);
        oty.setRecOuterNext(otyNext);
        mitx.setVarInt(11);
        mity.setVarInt(12);
        mitxNext.getRecMostInner().add(mity);
        itx.setVarInt(21);
        ity.setVarInt(22);
        itxNext.getRecInner().add(ity);
        itx.getRecMostInner().add(mitx);
        otx.setVarInt(31);
        oty.setVarInt(32);
        otxNext.getRecOuter().add(oty);
        otx.getRecInner().add(itx);
        otx.getRecMostInner().add(mitx);
        Holder yh = new Holder((Object)oty);
        Holder zh = new Holder();
        RecOuterType ret = testDocLiteral ? docClient.testRecOuterType(otx, yh, zh) : (testXMLBinding ? xmlClient.testRecOuterType(otx, yh, zh) : rpcClient.testRecOuterType(otx, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient2.assertTrue((String)"testRecOuterType(): Incorrect value for inout param", (boolean)this.equals(otx, (RecOuterType)yh.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecOuterType(): Incorrect value for inout param", (boolean)this.equals(oty, (RecOuterType)zh.value));
            AbstractTypeTestClient2.assertTrue((String)"testRecOuterType(): Incorrect value for inout param", (boolean)this.equals(ret, otx));
        }
    }

    protected void equals(String msg, SimpleContent1 x, SimpleContent1 y) throws Exception {
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getAttrib1A(), (Object)y.getAttrib1A());
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getAttrib1B(), (Object)y.getAttrib1B());
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getValue(), (Object)y.getValue());
    }

    @Test
    public void testSimpleContent1() throws Exception {
        SimpleContent1 x1 = new SimpleContent1();
        x1.setValue("foo");
        x1.setAttrib1A(new Byte(1));
        x1.setAttrib1B(new Short(2));
        SimpleContent1 y1 = new SimpleContent1();
        y1.setValue("bar");
        y1.setAttrib1A(new Byte(3));
        y1.setAttrib1B(new Short(4));
        Holder y1Holder = new Holder((Object)y1);
        Holder z1 = new Holder();
        SimpleContent1 ret = testDocLiteral ? docClient.testSimpleContent1(x1, y1Holder, z1) : (testXMLBinding ? xmlClient.testSimpleContent1(x1, y1Holder, z1) : rpcClient.testSimpleContent1(x1, y1Holder, z1));
        if (!this.perfTestOnly) {
            this.equals("testSimpleContent1(): Incorrect value for inout param", x1, (SimpleContent1)y1Holder.value);
            this.equals("testSimpleContent1(): Incorrect value for out param", y1, (SimpleContent1)z1.value);
            this.equals("testSimpleContent1(): Incorrect return value", x1, ret);
        }
    }

    protected void equals(String msg, SimpleContent2 x, SimpleContent2 y) throws Exception {
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getAttrib2A(), (Object)y.getAttrib2A());
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getAttrib2B(), (Object)y.getAttrib2B());
        this.equals(msg, (SimpleContent1)x, (SimpleContent1)y);
    }

    @Test
    public void testSimpleContent2() throws Exception {
        SimpleContent2 x2 = new SimpleContent2();
        x2.setValue("foo");
        x2.setAttrib1A(new Byte(1));
        x2.setAttrib1B(new Short(2));
        x2.setAttrib2A(new Integer(5));
        x2.setAttrib2B(new Long(6L));
        SimpleContent2 y2 = new SimpleContent2();
        y2.setValue("bar");
        y2.setAttrib1A(new Byte(3));
        y2.setAttrib1B(new Short(4));
        y2.setAttrib2A(new Integer(7));
        y2.setAttrib2B(new Long(8L));
        Holder y2Holder = new Holder((Object)y2);
        Holder z2 = new Holder();
        SimpleContent2 ret = testDocLiteral ? docClient.testSimpleContent2(x2, y2Holder, z2) : (testXMLBinding ? xmlClient.testSimpleContent2(x2, y2Holder, z2) : rpcClient.testSimpleContent2(x2, y2Holder, z2));
        if (!this.perfTestOnly) {
            this.equals("testSimpleContent2(): Incorrect value for inout param", x2, (SimpleContent2)y2Holder.value);
            this.equals("testSimpleContent2(): Incorrect value for out param", y2, (SimpleContent2)z2.value);
            this.equals("testSimpleContent2(): Incorrect return value", x2, ret);
        }
    }

    protected void equals(String msg, SimpleContent3 x, SimpleContent3 y) throws Exception {
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getAttrib3A(), (Object)y.getAttrib3A());
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.isAttrib3B(), (Object)y.isAttrib3B());
        this.equals(msg, (SimpleContent2)x, (SimpleContent2)y);
    }

    @Test
    public void testSimpleContent3() throws Exception {
        SimpleContent3 x3 = new SimpleContent3();
        x3.setValue("foo");
        x3.setAttrib1A(new Byte(1));
        x3.setAttrib1B(new Short(2));
        x3.setAttrib2A(new Integer(5));
        x3.setAttrib2B(new Long(6L));
        x3.setAttrib3A("xxx");
        x3.setAttrib3B(Boolean.TRUE);
        SimpleContent3 y3 = new SimpleContent3();
        y3.setValue("bar");
        y3.setAttrib1A(new Byte(3));
        y3.setAttrib1B(new Short(4));
        y3.setAttrib2A(new Integer(7));
        y3.setAttrib2B(new Long(8L));
        y3.setAttrib3A("yyy");
        y3.setAttrib3B(Boolean.FALSE);
        Holder y3Holder = new Holder((Object)y3);
        Holder z3 = new Holder();
        SimpleContent3 ret = testDocLiteral ? docClient.testSimpleContent3(x3, y3Holder, z3) : (testXMLBinding ? xmlClient.testSimpleContent3(x3, y3Holder, z3) : rpcClient.testSimpleContent3(x3, y3Holder, z3));
        if (!this.perfTestOnly) {
            this.equals("testSimpleContent3(): Incorrect value for inout param", x3, (SimpleContent3)y3Holder.value);
            this.equals("testSimpleContent3(): Incorrect value for out param", y3, (SimpleContent3)z3.value);
            this.equals("testSimpleContent3(): Incorrect return value", x3, ret);
        }
    }

    protected void assertEquals(String msg, UnionSimpleContent x, UnionSimpleContent y) throws Exception {
        AbstractTypeTestClient2.assertTrue((String)msg, (x != null ? 1 : 0) != 0);
        AbstractTypeTestClient2.assertTrue((String)msg, (y != null ? 1 : 0) != 0);
        AbstractTypeTestClient2.assertEquals((String)msg, (Object)x.getValue(), (Object)y.getValue());
    }

    @Test
    public void testUnionSimpleContent() throws Exception {
        UnionSimpleContent x = new UnionSimpleContent();
        x.setValue("5");
        UnionSimpleContent yOrig = new UnionSimpleContent();
        yOrig.setValue("-7");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        UnionSimpleContent ret = testDocLiteral ? docClient.testUnionSimpleContent(x, y, z) : (testXMLBinding ? xmlClient.testUnionSimpleContent(x, y, z) : rpcClient.testUnionSimpleContent(x, y, z));
        if (!this.perfTestOnly) {
            this.assertEquals("testUnionSimpleContent(): Incorrect value for inout param", x, (UnionSimpleContent)y.value);
            this.assertEquals("testUnionSimpleContent(): Incorrect value for out param", yOrig, (UnionSimpleContent)z.value);
            this.assertEquals("testUnionSimpleContent(): Incorrect return value", x, ret);
        }
    }
}

