/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.type_test;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.systest.type_test.AbstractTypeTestClient3;
import org.apache.type_test.types1.AnonymousType;
import org.apache.type_test.types1.DerivedChoiceBaseArray;
import org.apache.type_test.types1.DerivedEmptyBaseEmptyAll;
import org.apache.type_test.types1.DerivedStructBaseChoice;
import org.apache.type_test.types1.DerivedStructBaseStruct;
import org.apache.type_test.types1.EmptyAll;
import org.apache.type_test.types1.EmptyStruct;
import org.apache.type_test.types1.NestedStruct;
import org.apache.type_test.types1.OccuringAll;
import org.apache.type_test.types1.RecSeqB6918;
import org.apache.type_test.types1.RestrictedAllBaseAll;
import org.apache.type_test.types1.RestrictedStructBaseStruct;
import org.apache.type_test.types1.SimpleChoice;
import org.apache.type_test.types1.SimpleStruct;
import org.apache.type_test.types1.UnboundedArray;
import org.apache.type_test.types2.OccuringChoiceWithAnyAttribute;
import org.apache.type_test.types2.OccuringStructWithAnyAttribute;
import org.apache.type_test.types2.SimpleContentExtWithAnyAttribute;
import org.apache.type_test.types3.ArrayOfMRecSeqD;
import org.apache.type_test.types3.MRecSeqA;
import org.apache.type_test.types3.MRecSeqB;
import org.apache.type_test.types3.MRecSeqC;
import org.apache.type_test.types3.MRecSeqD;
import org.apache.type_test.types3.StructWithNillableChoice;
import org.apache.type_test.types3.StructWithNillableStruct;
import org.apache.type_test.types3.StructWithOccuringChoice;
import org.apache.type_test.types3.StructWithOccuringStruct;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeTestClient4
extends AbstractTypeTestClient3 {
    protected boolean equals(SimpleContentExtWithAnyAttribute x, SimpleContentExtWithAnyAttribute y) {
        if (!x.getValue().equals(y.getValue())) {
            return false;
        }
        if (!this.equalsNilable(x.getAttrib(), y.getAttrib())) {
            return false;
        }
        return this.equalsQNameStringPairs(x.getOtherAttributes(), y.getOtherAttributes());
    }

    @Test
    public void testSimpleContentExtWithAnyAttribute() throws Exception {
        QName xAt1Name = new QName("http://apache.org/type_test", "at_one");
        QName xAt2Name = new QName("http://apache.org/type_test", "at_two");
        QName yAt3Name = new QName("http://apache.org/type_test", "at_thr");
        QName yAt4Name = new QName("http://apache.org/type_test", "at_fou");
        SimpleContentExtWithAnyAttribute x = new SimpleContentExtWithAnyAttribute();
        x.setValue("foo");
        x.setAttrib(new Integer(2000));
        SimpleContentExtWithAnyAttribute y = new SimpleContentExtWithAnyAttribute();
        y.setValue("bar");
        y.setAttrib(new Integer(2001));
        Map xAttrMap = x.getOtherAttributes();
        xAttrMap.put(xAt1Name, "one");
        xAttrMap.put(xAt2Name, "two");
        Map yAttrMap = y.getOtherAttributes();
        yAttrMap.put(yAt3Name, "three");
        yAttrMap.put(yAt4Name, "four");
        Holder yh = new Holder((Object)y);
        Holder zh = new Holder();
        SimpleContentExtWithAnyAttribute ret = testDocLiteral ? docClient.testSimpleContentExtWithAnyAttribute(x, yh, zh) : (testXMLBinding ? xmlClient.testSimpleContentExtWithAnyAttribute(x, yh, zh) : rpcClient.testSimpleContentExtWithAnyAttribute(x, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testSimpleContentExtWithAnyAttribute(): Incorrect value for inout param", (boolean)this.equals(x, (SimpleContentExtWithAnyAttribute)yh.value));
            AbstractTypeTestClient4.assertTrue((String)"testSimpleContentExtWithAnyAttribute(): Incorrect value for out param", (boolean)this.equals(y, (SimpleContentExtWithAnyAttribute)zh.value));
            AbstractTypeTestClient4.assertTrue((String)"testSimpleContentExtWithAnyAttribute(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(OccuringAll x, OccuringAll y) {
        if (x.getVarAttrString() == null && y.getVarAttrString() == null) {
            return x.getVarInt() == null && y.getVarInt() == null;
        }
        if (!this.equalsNilable(x.getVarAttrString(), y.getVarAttrString())) {
            return false;
        }
        return x.getVarInt().compareTo(y.getVarInt()) == 0;
    }

    @Test
    public void testOccuringAll() throws Exception {
        OccuringAll x = new OccuringAll();
        x.setVarInt(new Integer(42));
        x.setVarAttrString("x_attr");
        OccuringAll yOrig = new OccuringAll();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        OccuringAll ret = testDocLiteral ? docClient.testOccuringAll(x, y, z) : (testXMLBinding ? xmlClient.testOccuringAll(x, y, z) : rpcClient.testOccuringAll(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testOccuringAll(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringAll)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testOccuringAll(): Incorrect value for out param", (boolean)this.equals(yOrig, (OccuringAll)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testOccuringAll(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(OccuringStructWithAnyAttribute x, OccuringStructWithAnyAttribute y) {
        List yList;
        if (!this.equalsNilable(x.getAtString(), y.getAtString()) || !this.equalsNilable(x.getAtInt(), y.getAtInt())) {
            return false;
        }
        List xList = x.getVarStringAndVarInt();
        if (!this.equalsStringIntList(xList, yList = y.getVarStringAndVarInt())) {
            return false;
        }
        return this.equalsQNameStringPairs(x.getOtherAttributes(), y.getOtherAttributes());
    }

    private boolean equalsStringIntList(List<Serializable> xList, List<Serializable> yList) {
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (xList.get(i) instanceof String && yList.get(i) instanceof String) {
                if (xList.get(i).equals(yList.get(i))) continue;
                return false;
            }
            if (xList.get(i) instanceof Integer && yList.get(i) instanceof Integer) {
                Integer ix = (Integer)xList.get(i);
                Integer iy = (Integer)yList.get(i);
                if (iy.compareTo(ix) == 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Test
    public void testOccuringStructWithAnyAttribute() throws Exception {
        QName xAt1Name = new QName("http://apache.org/type_test", "at_one");
        QName xAt2Name = new QName("http://apache.org/type_test", "at_two");
        QName yAt3Name = new QName("http://apache.org/type_test", "at_thr");
        QName yAt4Name = new QName("http://apache.org/type_test", "at_fou");
        OccuringStructWithAnyAttribute x = new OccuringStructWithAnyAttribute();
        OccuringStructWithAnyAttribute y = new OccuringStructWithAnyAttribute();
        List xVarStringAndVarInt = x.getVarStringAndVarInt();
        xVarStringAndVarInt.add("x1");
        xVarStringAndVarInt.add(0);
        xVarStringAndVarInt.add("x2");
        xVarStringAndVarInt.add(1);
        x.setAtString("attribute");
        x.setAtInt(new Integer(2000));
        List yVarStringAndVarInt = y.getVarStringAndVarInt();
        yVarStringAndVarInt.add("there");
        yVarStringAndVarInt.add(1001);
        y.setAtString("another attribute");
        y.setAtInt(new Integer(2002));
        Map xAttrMap = x.getOtherAttributes();
        xAttrMap.put(xAt1Name, "one");
        xAttrMap.put(xAt2Name, "two");
        Map yAttrMap = y.getOtherAttributes();
        yAttrMap.put(yAt3Name, "three");
        yAttrMap.put(yAt4Name, "four");
        Holder yh = new Holder((Object)y);
        Holder zh = new Holder();
        OccuringStructWithAnyAttribute ret = testDocLiteral ? docClient.testOccuringStructWithAnyAttribute(x, yh, zh) : (testXMLBinding ? xmlClient.testOccuringStructWithAnyAttribute(x, yh, zh) : rpcClient.testOccuringStructWithAnyAttribute(x, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testOccuringStructWithAnyAttribute(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringStructWithAnyAttribute)yh.value));
            AbstractTypeTestClient4.assertTrue((String)"testOccuringStructWithAnyAttribute(): Incorrect value for inout param", (boolean)this.equals(y, (OccuringStructWithAnyAttribute)zh.value));
            AbstractTypeTestClient4.assertTrue((String)"testOccuringStructWithAnyAttribute(): Incorrect value for inout param", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(OccuringChoiceWithAnyAttribute x, OccuringChoiceWithAnyAttribute y) {
        List yList;
        if (!this.equalsNilable(x.getAtString(), y.getAtString()) || !this.equalsNilable(x.getAtInt(), y.getAtInt())) {
            return false;
        }
        List xList = x.getVarStringOrVarInt();
        if (!this.equalsStringIntList(xList, yList = y.getVarStringOrVarInt())) {
            return false;
        }
        return this.equalsQNameStringPairs(x.getOtherAttributes(), y.getOtherAttributes());
    }

    @Test
    public void testOccuringChoiceWithAnyAttribute() throws Exception {
        QName xAt1Name = new QName("http://schemas.iona.com/type_test", "at_one");
        QName xAt2Name = new QName("http://schemas.iona.com/type_test", "at_two");
        QName yAt3Name = new QName("http://apache.org/type_test", "at_thr");
        QName yAt4Name = new QName("http://apache.org/type_test", "at_fou");
        OccuringChoiceWithAnyAttribute x = new OccuringChoiceWithAnyAttribute();
        OccuringChoiceWithAnyAttribute y = new OccuringChoiceWithAnyAttribute();
        List xVarStringOrVarInt = x.getVarStringOrVarInt();
        xVarStringOrVarInt.add("hello");
        xVarStringOrVarInt.add(1);
        x.setAtString("attribute");
        x.setAtInt(new Integer(2000));
        List yVarStringOrVarInt = y.getVarStringOrVarInt();
        yVarStringOrVarInt.add(1001);
        y.setAtString("the attribute");
        y.setAtInt(new Integer(2002));
        Map xAttrMap = x.getOtherAttributes();
        xAttrMap.put(xAt1Name, "one");
        xAttrMap.put(xAt2Name, "two");
        Map yAttrMap = y.getOtherAttributes();
        yAttrMap.put(yAt3Name, "three");
        yAttrMap.put(yAt4Name, "four");
        Holder yh = new Holder((Object)y);
        Holder zh = new Holder();
        OccuringChoiceWithAnyAttribute ret = testDocLiteral ? docClient.testOccuringChoiceWithAnyAttribute(x, yh, zh) : (testXMLBinding ? xmlClient.testOccuringChoiceWithAnyAttribute(x, yh, zh) : rpcClient.testOccuringChoiceWithAnyAttribute(x, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testOccuringChoiceWithAnyAttribute(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringChoiceWithAnyAttribute)yh.value));
            AbstractTypeTestClient4.assertTrue((String)"testOccuringChoiceWithAnyAttribute(): Incorrect value for out param", (boolean)this.equals(y, (OccuringChoiceWithAnyAttribute)zh.value));
            AbstractTypeTestClient4.assertTrue((String)"testOccuringChoiceWithAnyAttribute(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(MRecSeqA x, MRecSeqA y) {
        List xList = x.getSeqB();
        List yList = y.getSeqB();
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.equals((MRecSeqB)xList.get(i), (MRecSeqB)yList.get(i))) continue;
            return false;
        }
        return x.getVarIntA() == y.getVarIntA();
    }

    protected boolean equals(MRecSeqB x, MRecSeqB y) {
        return x.getVarIntB() == y.getVarIntB() && this.equals(x.getSeqA(), y.getSeqA());
    }

    @Test
    public void testMRecSeqA() throws Exception {
        MRecSeqA xA = new MRecSeqA();
        MRecSeqA yA = new MRecSeqA();
        MRecSeqA zA = new MRecSeqA();
        MRecSeqB xB = new MRecSeqB();
        MRecSeqB yB = new MRecSeqB();
        xA.setVarIntA(11);
        yA.setVarIntA(12);
        zA.setVarIntA(13);
        xB.setVarIntB(21);
        yB.setVarIntB(22);
        xB.setSeqA(yA);
        yB.setSeqA(zA);
        xA.getSeqB().add(xB);
        yA.getSeqB().add(yB);
        Holder yh = new Holder((Object)yA);
        Holder zh = new Holder();
        MRecSeqA ret = testDocLiteral ? docClient.testMRecSeqA(xA, yh, zh) : (testXMLBinding ? xmlClient.testMRecSeqA(xA, yh, zh) : rpcClient.testMRecSeqA(xA, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"test_MRecSeqA(): Incorrect value for inout param", (boolean)this.equals(xA, (MRecSeqA)yh.value));
            AbstractTypeTestClient4.assertTrue((String)"test_MRecSeqA(): Incorrect value for out param", (boolean)this.equals(yA, (MRecSeqA)zh.value));
            AbstractTypeTestClient4.assertTrue((String)"test_MRecSeqA(): Incorrect return value", (boolean)this.equals(ret, xA));
        }
    }

    protected boolean equals(MRecSeqC x, MRecSeqC y) {
        return x.getVarIntC() == y.getVarIntC() && this.equals(x.getSeqDs(), y.getSeqDs());
    }

    protected boolean equals(ArrayOfMRecSeqD x, ArrayOfMRecSeqD y) {
        List xList = x.getSeqD();
        List yList = y.getSeqD();
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.equals((MRecSeqD)xList.get(i), (MRecSeqD)yList.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(MRecSeqD x, MRecSeqD y) {
        return x.getVarIntD() == y.getVarIntD() && this.equals(x.getSeqC(), y.getSeqC());
    }

    @Test
    public void testMRecSeqC() throws Exception {
        MRecSeqC xC = new MRecSeqC();
        MRecSeqC yC = new MRecSeqC();
        MRecSeqC zC = new MRecSeqC();
        ArrayOfMRecSeqD xDs = new ArrayOfMRecSeqD();
        ArrayOfMRecSeqD yDs = new ArrayOfMRecSeqD();
        ArrayOfMRecSeqD zDs = new ArrayOfMRecSeqD();
        MRecSeqD xD = new MRecSeqD();
        MRecSeqD yD = new MRecSeqD();
        xC.setVarIntC(11);
        yC.setVarIntC(12);
        zC.setVarIntC(13);
        xD.setVarIntD(21);
        yD.setVarIntD(22);
        xDs.getSeqD().add(xD);
        yDs.getSeqD().add(yD);
        xC.setSeqDs(xDs);
        yC.setSeqDs(yDs);
        zC.setSeqDs(zDs);
        xD.setSeqC(yC);
        yD.setSeqC(zC);
        Holder yh = new Holder((Object)yC);
        Holder zh = new Holder();
        MRecSeqC ret = testDocLiteral ? docClient.testMRecSeqC(xC, yh, zh) : (testXMLBinding ? xmlClient.testMRecSeqC(xC, yh, zh) : rpcClient.testMRecSeqC(xC, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"test_MRecSeqC(): Incorrect value for inout param", (boolean)this.equals(xC, (MRecSeqC)yh.value));
            AbstractTypeTestClient4.assertTrue((String)"test_MRecSeqC(): Incorrect value for out param", (boolean)this.equals(yC, (MRecSeqC)zh.value));
            AbstractTypeTestClient4.assertTrue((String)"test_MRecSeqC(): Incorrect return value", (boolean)this.equals(ret, xC));
        }
    }

    protected boolean equals(StructWithNillableChoice x, StructWithNillableChoice y) {
        if (x.getVarInteger() != y.getVarInteger()) {
            return false;
        }
        if (x.getVarString() != null) {
            return x.getVarString().equals(y.getVarString());
        }
        if (x.getVarInt() != null) {
            return x.getVarInt() == y.getVarInt();
        }
        return y.getVarInt() == null && y.getVarString() == null;
    }

    protected boolean isNormalized(StructWithNillableChoice x) {
        return x == null || x.getVarInt() == null && x.getVarString() == null;
    }

    @Test
    public void testStructWithNillableChoice() throws Exception {
        StructWithNillableChoice x = new StructWithNillableChoice();
        x.setVarInteger(2);
        x.setVarInt(Integer.valueOf(3));
        StructWithNillableChoice yOriginal = new StructWithNillableChoice();
        yOriginal.setVarInteger(1);
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        StructWithNillableChoice ret = testDocLiteral ? docClient.testStructWithNillableChoice(x, y, z) : (testXMLBinding ? xmlClient.testStructWithNillableChoice(x, y, z) : rpcClient.testStructWithNillableChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithNillableChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithNillableChoice)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect form for out param", (boolean)this.isNormalized((StructWithNillableChoice)z.value));
        }
        y = new Holder((Object)x);
        x = yOriginal;
        yOriginal = (StructWithNillableChoice)y.value;
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithNillableChoice(x, y, z) : (testXMLBinding ? xmlClient.testStructWithNillableChoice(x, y, z) : rpcClient.testStructWithNillableChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithNillableChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithNillableChoice)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect form for inout param", (boolean)this.isNormalized((StructWithNillableChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableChoice(): Incorrect return form", (boolean)this.isNormalized(ret));
        }
    }

    protected boolean equals(StructWithOccuringChoice x, StructWithOccuringChoice y) {
        if (x.getVarInteger() != y.getVarInteger()) {
            AbstractTypeTestClient4.fail((String)(x.getVarInteger() + " != " + y.getVarInteger()));
            return false;
        }
        List xList = x.getVarIntOrVarString();
        List yList = y.getVarIntOrVarString();
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (xList.get(i) instanceof Integer && yList.get(i) instanceof Integer) {
                Integer ix = (Integer)xList.get(i);
                Integer iy = (Integer)yList.get(i);
                if (iy.compareTo(ix) == 0) continue;
                return false;
            }
            if (xList.get(i) instanceof String && yList.get(i) instanceof String) {
                String sy;
                String sx = (String)xList.get(i);
                if (sx.equals(sy = (String)yList.get(i))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected boolean isNormalized(StructWithOccuringChoice x) {
        return x == null || x.getVarIntOrVarString().size() == 0;
    }

    @Test
    public void testStructWithOccuringChoice() throws Exception {
        StructWithOccuringChoice x = new StructWithOccuringChoice();
        x.setVarInteger(2);
        x.getVarIntOrVarString().add(3);
        x.getVarIntOrVarString().add("hello");
        StructWithOccuringChoice yOriginal = new StructWithOccuringChoice();
        yOriginal.setVarInteger(1);
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        StructWithOccuringChoice ret = testDocLiteral ? docClient.testStructWithOccuringChoice(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringChoice(x, y, z) : rpcClient.testStructWithOccuringChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringChoice)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect form for out param", (boolean)this.isNormalized((StructWithOccuringChoice)z.value));
        }
        yOriginal.getVarIntOrVarString().add("world");
        y = new Holder((Object)yOriginal);
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithOccuringChoice(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringChoice(x, y, z) : rpcClient.testStructWithOccuringChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringChoice)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
        y = new Holder((Object)x);
        x = yOriginal;
        yOriginal = (StructWithOccuringChoice)y.value;
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithOccuringChoice(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringChoice(x, y, z) : rpcClient.testStructWithOccuringChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringChoice)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
        x.getVarIntOrVarString().clear();
        y = new Holder((Object)yOriginal);
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithOccuringChoice(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringChoice(x, y, z) : rpcClient.testStructWithOccuringChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringChoice)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect form for inout param", (boolean)this.isNormalized((StructWithOccuringChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringChoice(): Incorrect return form", (boolean)this.isNormalized(ret));
        }
    }

    protected boolean equals(StructWithNillableStruct x, StructWithNillableStruct y) {
        if (x.getVarInteger() != y.getVarInteger()) {
            AbstractTypeTestClient4.fail((String)(x.getVarInteger() + " != " + y.getVarInteger()));
            return false;
        }
        if (x.getVarInt() == null) {
            if (x.getVarFloat() == null) {
                return y.getVarInt() == null && y.getVarFloat() == null;
            }
            return false;
        }
        if (x.getVarFloat() == null || y.getVarInt() == null || y.getVarFloat() == null) {
            return false;
        }
        return x.getVarFloat().compareTo(y.getVarFloat()) == 0 && x.getVarInt() == y.getVarInt();
    }

    protected boolean isNormalized(StructWithNillableStruct x) {
        return x.getVarInt() == null && x.getVarFloat() == null;
    }

    @Test
    public void testStructWithNillableStruct() throws Exception {
        StructWithNillableStruct x = new StructWithNillableStruct();
        x.setVarInteger(100);
        x.setVarInt(Integer.valueOf(101));
        x.setVarFloat(Float.valueOf(101.5f));
        StructWithNillableStruct yOriginal = new StructWithNillableStruct();
        yOriginal.setVarInteger(200);
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        StructWithNillableStruct ret = testDocLiteral ? docClient.testStructWithNillableStruct(x, y, z) : (testXMLBinding ? xmlClient.testStructWithNillableStruct(x, y, z) : rpcClient.testStructWithNillableStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithNillableStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithNillableStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect form for out param", (boolean)this.isNormalized((StructWithNillableStruct)z.value));
        }
        yOriginal.setVarInt(null);
        yOriginal.setVarFloat(null);
        y = new Holder((Object)yOriginal);
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithNillableStruct(x, y, z) : (testXMLBinding ? xmlClient.testStructWithNillableStruct(x, y, z) : rpcClient.testStructWithNillableStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithNillableStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithNillableStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect form for out param", (boolean)this.isNormalized((StructWithNillableStruct)z.value));
        }
        y = new Holder((Object)x);
        x = yOriginal;
        yOriginal = (StructWithNillableStruct)y.value;
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithNillableStruct(x, y, z) : (testXMLBinding ? xmlClient.testStructWithNillableStruct(x, y, z) : rpcClient.testStructWithNillableStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithNillableStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithNillableStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect form for inout param", (boolean)this.isNormalized((StructWithNillableStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithNillableStruct(): Incorrect return form", (boolean)this.isNormalized(ret));
        }
    }

    protected boolean equals(StructWithOccuringStruct x, StructWithOccuringStruct y) {
        int ySize;
        if (x.getVarInteger() != y.getVarInteger()) {
            return false;
        }
        List xList = x.getVarIntAndVarFloat();
        List yList = y.getVarIntAndVarFloat();
        int xSize = xList == null ? 0 : xList.size();
        int n = ySize = yList == null ? 0 : yList.size();
        if (xSize != ySize) {
            return false;
        }
        for (int i = 0; i < xSize; ++i) {
            if (xList.get(i) instanceof Integer && yList.get(i) instanceof Integer) {
                if (((Integer)xList.get(i)).compareTo((Integer)yList.get(i)) == 0) continue;
                return false;
            }
            if (xList.get(i) instanceof Float && yList.get(i) instanceof Float) {
                if (((Float)xList.get(i)).compareTo((Float)yList.get(i)) == 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected boolean isNormalized(StructWithOccuringStruct x) {
        return x.getVarIntAndVarFloat() != null;
    }

    @Test
    public void testStructWithOccuringStruct() throws Exception {
        StructWithOccuringStruct x = new StructWithOccuringStruct();
        x.setVarInteger(100);
        x.getVarIntAndVarFloat().add(101);
        x.getVarIntAndVarFloat().add(Float.valueOf(101.5f));
        x.getVarIntAndVarFloat().add(102);
        x.getVarIntAndVarFloat().add(Float.valueOf(102.5f));
        StructWithOccuringStruct yOriginal = new StructWithOccuringStruct();
        yOriginal.setVarInteger(200);
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        StructWithOccuringStruct ret = testDocLiteral ? docClient.testStructWithOccuringStruct(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringStruct(x, y, z) : rpcClient.testStructWithOccuringStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect form for out param", (boolean)this.isNormalized((StructWithOccuringStruct)z.value));
        }
        yOriginal.getVarIntAndVarFloat().add(201);
        yOriginal.getVarIntAndVarFloat().add(Float.valueOf(202.5f));
        y = new Holder((Object)yOriginal);
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithOccuringStruct(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringStruct(x, y, z) : rpcClient.testStructWithOccuringStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testStructWithOccuringStruct2() throws Exception {
        StructWithOccuringStruct x = new StructWithOccuringStruct();
        x.setVarInteger(100);
        x.getVarIntAndVarFloat().add(101);
        x.getVarIntAndVarFloat().add(Float.valueOf(101.5f));
        x.getVarIntAndVarFloat().add(102);
        x.getVarIntAndVarFloat().add(Float.valueOf(102.5f));
        StructWithOccuringStruct yOriginal = new StructWithOccuringStruct();
        yOriginal.setVarInteger(200);
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        y = new Holder((Object)x);
        x = yOriginal;
        yOriginal = (StructWithOccuringStruct)y.value;
        z = new Holder();
        StructWithOccuringStruct ret = testDocLiteral ? docClient.testStructWithOccuringStruct(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringStruct(x, y, z) : rpcClient.testStructWithOccuringStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
        x.getVarIntAndVarFloat().clear();
        y = new Holder((Object)yOriginal);
        z = new Holder();
        ret = testDocLiteral ? docClient.testStructWithOccuringStruct(x, y, z) : (testXMLBinding ? xmlClient.testStructWithOccuringStruct(x, y, z) : rpcClient.testStructWithOccuringStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithOccuringStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithOccuringStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect return value", (boolean)this.equals(x, ret));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect form for inout param", (boolean)this.isNormalized((StructWithOccuringStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testStructWithOccuringStruct(): Incorrect return form", (boolean)this.isNormalized(ret));
        }
    }

    protected boolean equals(AnonymousType x, AnonymousType y) {
        return x.getFoo().getFoo().equals(y.getFoo().getFoo()) && x.getFoo().getBar().equals(y.getFoo().getBar());
    }

    @Test
    public void testAnonymousType() throws Exception {
        AnonymousType x = new AnonymousType();
        AnonymousType.Foo fx = new AnonymousType.Foo();
        fx.setFoo("hello");
        fx.setBar("there");
        x.setFoo(fx);
        AnonymousType yOrig = new AnonymousType();
        AnonymousType.Foo fy = new AnonymousType.Foo();
        fy.setFoo("good");
        fy.setBar("bye");
        yOrig.setFoo(fy);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        AnonymousType ret = testDocLiteral ? docClient.testAnonymousType(x, y, z) : (testXMLBinding ? xmlClient.testAnonymousType(x, y, z) : rpcClient.testAnonymousType(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testAnonymousType(): Incorrect value for inout param", (boolean)this.equals(x, (AnonymousType)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testAnonymousType(): Incorrect value for out param", (boolean)this.equals(yOrig, (AnonymousType)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testAnonymousType(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(RecSeqB6918 x, RecSeqB6918 y) {
        List xList = x.getNextSeqAndVarInt();
        List yList = y.getNextSeqAndVarInt();
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Object xo = xList.get(i);
            Object yo = yList.get(i);
            if (xo instanceof Integer) {
                if (yo instanceof Integer) {
                    if (((Integer)xo).compareTo((Integer)yo) == 0) continue;
                    return false;
                }
                return false;
            }
            if (!(xo instanceof RecSeqB6918)) continue;
            if (yo instanceof RecSeqB6918) {
                return this.equals((RecSeqB6918)xo, (RecSeqB6918)yo);
            }
            return false;
        }
        return true;
    }

    @Test
    public void testRecSeqB6918() throws Exception {
        RecSeqB6918 x = new RecSeqB6918();
        List theList = x.getNextSeqAndVarInt();
        theList.add(new Integer(6));
        theList.add(new RecSeqB6918());
        theList.add(new Integer(42));
        RecSeqB6918 yOrig = new RecSeqB6918();
        theList = yOrig.getNextSeqAndVarInt();
        theList.add(x);
        theList.add(new Integer(2));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RecSeqB6918 ret = testDocLiteral ? docClient.testRecSeqB6918(x, y, z) : (testXMLBinding ? xmlClient.testRecSeqB6918(x, y, z) : rpcClient.testRecSeqB6918(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testRecSeqB6918(): Incorrect value for inout param", (boolean)this.equals(x, (RecSeqB6918)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testRecSeqB6918(): Incorrect value for out param", (boolean)this.equals(yOrig, (RecSeqB6918)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testRecSeqB6918(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(RestrictedStructBaseStruct x, RestrictedStructBaseStruct y) {
        return x.getVarFloat() == y.getVarFloat() && x.getVarInt().equals(y.getVarInt()) && x.getVarAttrString().equals(y.getVarAttrString());
    }

    @Test
    public void testRestrictedStructBaseStruct() throws Exception {
        RestrictedStructBaseStruct x = new RestrictedStructBaseStruct();
        x.setVarFloat((double)3.14f);
        x.setVarInt(new BigInteger("42"));
        x.setVarAttrString("BaseStructAttr-x");
        RestrictedStructBaseStruct yOrig = new RestrictedStructBaseStruct();
        yOrig.setVarFloat((double)-9.14f);
        yOrig.setVarInt(new BigInteger("10"));
        yOrig.setVarAttrString("BaseStructAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RestrictedStructBaseStruct ret = testDocLiteral ? docClient.testRestrictedStructBaseStruct(x, y, z) : (testXMLBinding ? xmlClient.testRestrictedStructBaseStruct(x, y, z) : rpcClient.testRestrictedStructBaseStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testRestrictedStructBaseStruct(): Incorrect value for inout param", (boolean)this.equals(x, (RestrictedStructBaseStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testRestrictedStructBaseStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (RestrictedStructBaseStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testRestrictedStructBaseStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(RestrictedAllBaseAll x, RestrictedAllBaseAll y) {
        return x.getVarFloat() == y.getVarFloat() && x.getVarInt() == y.getVarInt() && x.getVarAttrString().equals(y.getVarAttrString());
    }

    @Test
    public void testRestrictedAllBaseAll() throws Exception {
        RestrictedAllBaseAll x = new RestrictedAllBaseAll();
        x.setVarFloat(3.14f);
        x.setVarInt(42);
        x.setVarAttrString("BaseAllAttr-x");
        RestrictedAllBaseAll yOrig = new RestrictedAllBaseAll();
        yOrig.setVarFloat(-9.14f);
        yOrig.setVarInt(10);
        yOrig.setVarAttrString("BaseAllAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RestrictedAllBaseAll ret = testDocLiteral ? docClient.testRestrictedAllBaseAll(x, y, z) : (testXMLBinding ? xmlClient.testRestrictedAllBaseAll(x, y, z) : rpcClient.testRestrictedAllBaseAll(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testRestrictedAllBaseAll(): Incorrect value for inout param", (boolean)this.equals(x, (RestrictedAllBaseAll)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testRestrictedAllBaseAll(): Incorrect value for out param", (boolean)this.equals(yOrig, (RestrictedAllBaseAll)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testRestrictedAllBaseAll(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testUnionWithStringList() throws Exception {
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<String> x = Arrays.asList("5");
            List<String> yOrig = Arrays.asList("I", "am", "SimpleList");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testUnionWithStringList(x, y, z) : xmlClient.testUnionWithStringList(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithStringList(): Incorrect value for inout param", x, (Object)y.value);
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithStringList(): Incorrect value for out param", yOrig, (Object)z.value);
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithStringList(): Incorrect return value", x, (Object)ret);
            }
        } else {
            Object[] x = new String[]{"5"};
            Object[] yOrig = new String[]{"I", "am", "SimpleList"};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            Object[] ret = rpcClient.testUnionWithStringList((String[])x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithStringList(): Incorrect value for inout param", (boolean)Arrays.equals(x, (Object[])y.value));
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithStringList(): Incorrect value for out param", (boolean)Arrays.equals(yOrig, (Object[])z.value));
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithStringList(): Incorrect return value", (boolean)Arrays.equals(x, ret));
            }
        }
    }

    @Test
    public void testUnionWithStringListRestriction() throws Exception {
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<String> x = Arrays.asList("5");
            List<String> yOrig = Arrays.asList("I", "am", "SimpleList");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testUnionWithStringListRestriction(x, y, z) : xmlClient.testUnionWithStringListRestriction(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithStringListRestriction(): Incorrect value for inout param", x, (Object)y.value);
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithStringListRestriction(): Incorrect value for out param", yOrig, (Object)z.value);
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithStringListRestriction(): Incorrect return value", x, (Object)ret);
            }
        } else {
            Object[] x = new String[]{"5"};
            Object[] yOrig = new String[]{"I", "am", "SimpleList"};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            Object[] ret = rpcClient.testUnionWithStringListRestriction((String[])x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithStringListRestriction(): Incorrect value for inout param", (boolean)Arrays.equals(x, (Object[])y.value));
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithStringListRestriction(): Incorrect value for out param", (boolean)Arrays.equals(yOrig, (Object[])z.value));
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithStringListRestriction(): Incorrect return value", (boolean)Arrays.equals(x, ret));
            }
        }
    }

    @Test
    public void testUnionWithAnonList() throws Exception {
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<String> x = Arrays.asList("5");
            List<String> yOrig = Arrays.asList("-1E4", "1267.43233E12", "12.78e-2", "12", "-0", "INF");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testUnionWithAnonList(x, y, z) : xmlClient.testUnionWithAnonList(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithAnonList(): Incorrect value for inout param", x, (Object)y.value);
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithAnonList(): Incorrect value for out param", yOrig, (Object)z.value);
                AbstractTypeTestClient4.assertEquals((String)"testUnionWithAnonList(): Incorrect return value", x, (Object)ret);
            }
        } else {
            Object[] x = new String[]{"5"};
            Object[] yOrig = new String[]{"-1E4", "1267.43233E12", "12.78e-2", "12", "-0", "INF"};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            Object[] ret = rpcClient.testUnionWithStringListRestriction((String[])x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithAnonList(): Incorrect value for inout param", (boolean)Arrays.equals(x, (Object[])y.value));
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithAnonList(): Incorrect value for out param", (boolean)Arrays.equals(yOrig, (Object[])z.value));
                AbstractTypeTestClient4.assertTrue((String)"testUnionWithAnonList(): Incorrect return value", (boolean)Arrays.equals(x, ret));
            }
        }
    }

    @Test
    public void testAnyURIRestriction() throws Exception {
        String x = new String("http://cxf.apache.org/");
        String yOrig = new String("http://www.iona.com/info/services/oss/");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testAnyURIRestriction(x, y, z) : (testXMLBinding ? xmlClient.testAnyURIRestriction(x, y, z) : rpcClient.testAnyURIRestriction(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertEquals((String)"testString(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient4.assertEquals((String)"testString(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient4.assertEquals((String)"testString(): Incorrect return value", (Object)x, (Object)ret);
        }
        if (testDocLiteral || testXMLBinding) {
            yOrig = new String("http://www.iona.com/info/services/oss/info_services_oss_train.html");
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testAnyURIRestriction(x, y, z) : xmlClient.testAnyURIRestriction(x, y, z);
                AbstractTypeTestClient4.fail((String)"maxLength=50 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testInheritanceNestedStruct() throws Exception {
        DerivedStructBaseStruct xs = new DerivedStructBaseStruct();
        xs.setVarFloat((double)3.14f);
        xs.setVarInt(new BigInteger("42"));
        xs.setVarString("BaseStruct-x");
        xs.setVarAttrString("BaseStructAttr-x");
        xs.setVarFloatExt(-3.14f);
        xs.setVarStringExt("DerivedStruct-x");
        xs.setAttrString1("DerivedAttr1-x");
        xs.setAttrString2("DerivedAttr2-x");
        DerivedStructBaseStruct ys = new DerivedStructBaseStruct();
        ys.setVarFloat((double)-9.14f);
        ys.setVarInt(new BigInteger("10"));
        ys.setVarString("BaseStruct-y");
        ys.setVarAttrString("BaseStructAttr-y");
        ys.setVarFloatExt(1.414f);
        ys.setVarStringExt("DerivedStruct-y");
        ys.setAttrString1("DerivedAttr1-y");
        ys.setAttrString2("DerivedAttr2-y");
        NestedStruct x = new NestedStruct();
        x.setVarFloat(new BigDecimal("3.14"));
        x.setVarInt(42);
        x.setVarString("Hello There");
        x.setVarEmptyStruct(new EmptyStruct());
        x.setVarStruct((SimpleStruct)xs);
        NestedStruct yOrig = new NestedStruct();
        yOrig.setVarFloat(new BigDecimal("1.414"));
        yOrig.setVarInt(13);
        yOrig.setVarString("Cheerio");
        yOrig.setVarEmptyStruct(new EmptyStruct());
        yOrig.setVarStruct((SimpleStruct)ys);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        NestedStruct ret = testDocLiteral ? docClient.testNestedStruct(x, y, z) : (testXMLBinding ? xmlClient.testNestedStruct(x, y, z) : rpcClient.testNestedStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testNestedStruct(): Incorrect value for inout param", (boolean)this.equals(x, (NestedStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testNestedStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (NestedStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testNestedStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testInheritanceSimpleStructDerivedStruct() throws Exception {
        DerivedStructBaseStruct x = new DerivedStructBaseStruct();
        x.setVarFloat((double)3.14f);
        x.setVarInt(new BigInteger("42"));
        x.setVarString("BaseStruct-x");
        x.setVarAttrString("BaseStructAttr-x");
        x.setVarFloatExt(-3.14f);
        x.setVarStringExt("DerivedStruct-x");
        x.setAttrString1("DerivedAttr1-x");
        x.setAttrString2("DerivedAttr2-x");
        DerivedStructBaseStruct yOrig = new DerivedStructBaseStruct();
        yOrig.setVarFloat((double)-9.14f);
        yOrig.setVarInt(new BigInteger("10"));
        yOrig.setVarString("BaseStruct-y");
        yOrig.setVarAttrString("BaseStructAttr-y");
        yOrig.setVarFloatExt(1.414f);
        yOrig.setVarStringExt("DerivedStruct-y");
        yOrig.setAttrString1("DerivedAttr1-y");
        yOrig.setAttrString2("DerivedAttr2-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SimpleStruct ret = testDocLiteral ? docClient.testSimpleStruct((SimpleStruct)x, y, z) : (testXMLBinding ? xmlClient.testSimpleStruct((SimpleStruct)x, y, z) : rpcClient.testSimpleStruct((SimpleStruct)x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceSimpleDerived(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedStructBaseStruct)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceSimpleDerived(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedStructBaseStruct)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceSimpleDerived(): Incorrect return value", (boolean)this.equals(x, (DerivedStructBaseStruct)ret));
        }
    }

    @Test
    public void testInheritanceSimpleChoiceDerivedStruct() throws Exception {
        DerivedStructBaseChoice x = new DerivedStructBaseChoice();
        x.setVarString("BaseChoice-x");
        x.setVarFloatExt(-3.14f);
        x.setVarStringExt("DerivedStruct-x");
        x.setAttrString("DerivedAttr-x");
        DerivedStructBaseChoice yOrig = new DerivedStructBaseChoice();
        yOrig.setVarFloat(Float.valueOf(-9.14f));
        yOrig.setVarFloatExt(1.414f);
        yOrig.setVarStringExt("DerivedStruct-y");
        yOrig.setAttrString("DerivedAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SimpleChoice ret = testDocLiteral ? docClient.testSimpleChoice((SimpleChoice)x, y, z) : (testXMLBinding ? xmlClient.testSimpleChoice((SimpleChoice)x, y, z) : rpcClient.testSimpleChoice((SimpleChoice)x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceSimpleChoiceDerivedStruct(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedStructBaseChoice)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceSimpleChoiceDerivedStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedStructBaseChoice)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceSimpleChoiceDerivedStruct(): Incorrect return value", (boolean)this.equals(x, (DerivedStructBaseChoice)ret));
        }
    }

    @Test
    public void testInheritanceUnboundedArrayDerivedChoice() throws Exception {
        DerivedChoiceBaseArray x = new DerivedChoiceBaseArray();
        x.getItem().addAll(Arrays.asList("AAA", "BBB", "CCC"));
        x.setVarStringExt("DerivedChoice-x");
        x.setAttrStringExt("DerivedAttr-x");
        DerivedChoiceBaseArray yOrig = new DerivedChoiceBaseArray();
        yOrig.getItem().addAll(Arrays.asList("XXX", "YYY", "ZZZ"));
        yOrig.setVarFloatExt(Float.valueOf(1.414f));
        yOrig.setAttrStringExt("DerivedAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        UnboundedArray ret = testDocLiteral ? docClient.testUnboundedArray((UnboundedArray)x, y, z) : (testXMLBinding ? xmlClient.testUnboundedArray((UnboundedArray)x, y, z) : rpcClient.testUnboundedArray((UnboundedArray)x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceUnboundedArrayDerivedChoice(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedChoiceBaseArray)y.value));
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceUnboundedArrayDerivedChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedChoiceBaseArray)z.value));
            AbstractTypeTestClient4.assertTrue((String)"testInheritanceUnboundedArrayDerivedChoice(): Incorrect return value", (boolean)this.equals(x, (DerivedChoiceBaseArray)ret));
        }
    }

    @Test
    public void testInheritanceEmptyAllDerivedEmpty() throws Exception {
        DerivedEmptyBaseEmptyAll x = new DerivedEmptyBaseEmptyAll();
        DerivedEmptyBaseEmptyAll yOrig = new DerivedEmptyBaseEmptyAll();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        EmptyAll ret = testDocLiteral ? docClient.testEmptyAll((EmptyAll)x, y, z) : (testXMLBinding ? xmlClient.testEmptyAll((EmptyAll)x, y, z) : rpcClient.testEmptyAll((EmptyAll)x, y, z));
        AbstractTypeTestClient4.assertNotNull((String)"testInheritanceEmptyAllDerivedEmpty()", (Object)y.value);
        AbstractTypeTestClient4.assertNotNull((String)"testInheritanceEmptyAllDerivedEmpty()", (Object)z.value);
        AbstractTypeTestClient4.assertNotNull((String)"testInheritanceEmptyAllDerivedEmpty()", (Object)ret);
    }
}

