/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addressing;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.systest.ws.addressing.MAPTestBase;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.junit.Test;

public class MAPTest
extends MAPTestBase {
    private static final String CONFIG = "org/apache/cxf/systest/ws/addressing/cxf" + ("HP-UX".equals(System.getProperty("os.name")) || "Windows XP".equals(System.getProperty("os.name")) ? "-hpux" : "") + ".xml";

    public String getConfigFileName() {
        return CONFIG;
    }

    @Test
    public void foo() {
    }

    @Test
    public void testUsingKeepAliveConnection() throws Exception {
        int i;
        if (!"HP-UX".equals(System.getProperty("os.name"))) {
            return;
        }
        int n = 100;
        for (i = 0; i < n; ++i) {
            this.greeter.greetMeOneWay("oneway on keep-alive connection");
        }
        for (i = 0; i < n; ++i) {
            MAPTest.assertNotNull((Object)this.greeter.greetMe("twoway on keep-alive connection"));
        }
        for (i = 0; i < 0; ++i) {
            try {
                this.greeter.testDocLitFault("BadRecordLitFault");
                MAPTest.fail((String)"expected fault from service");
                continue;
            }
            catch (BadRecordLitFault brlf) {
                continue;
            }
            catch (UndeclaredThrowableException ex) {
                throw (Exception)ex.getCause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayReadingPartialResponse() throws Exception {
        if (!"HP-UX".equals(System.getProperty("os.name"))) {
            return;
        }
        MAPTest.assertTrue((boolean)ConnectionHelper.isKeepAliveConnection(this.greeter));
        ConnectionHelper.setKeepAliveConnection(this.greeter, false);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DelayInterceptor
        extends AbstractPhaseInterceptor<Message> {
            long delay;

            DelayInterceptor() {
                super("receive");
                this.delay = 100L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (Exception exception) {
                }
                finally {
                    if (this.delay < 1000L) {
                        this.delay += 100L;
                    }
                }
            }
        }
        DelayInterceptor interceptor = new DelayInterceptor();
        staticBus.getInInterceptors().add(interceptor);
        int n = 100;
        try {
            for (int i = 0; i < n; ++i) {
                this.greeter.greetMeOneWay("delay reading partial reponse");
            }
            MAPTest.fail((String)"Expected SocketException not thrown");
        }
        catch (Exception ex) {
            Throwable t = ex.getCause();
            while (null != t.getCause()) {
                t = t.getCause();
            }
            MAPTest.assertTrue((String)("Unexpected exception type: " + t.getClass().getName()), (boolean)(t instanceof SocketException));
        }
        finally {
            ConnectionHelper.setKeepAliveConnection(this.greeter, true);
            staticBus.getInInterceptors().remove((Object)interceptor);
        }
    }
}

