/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addressing;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.systest.ws.addressing.GreeterImpl;
import org.apache.cxf.systest.ws.addressing.HeaderVerifier;
import org.apache.cxf.systest.ws.addressing.MAPVerifier;
import org.apache.cxf.systest.ws.addressing.VerificationCache;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends AbstractBusTestServerBase
implements VerificationCache {
    static final String ADDRESS = "http://localhost:9008/SoapContext/SoapPort";
    private String verified;

    protected void run() {
        SpringBusFactory factory = new SpringBusFactory();
        Bus bus = factory.createBus("org/apache/cxf/systest/ws/addressing/wsa_interceptors.xml");
        BusFactory.setDefaultBus((Bus)bus);
        this.setBus(bus);
        this.addVerifiers();
        GreeterImpl implementor = new GreeterImpl();
        implementor.verificationCache = this;
        Endpoint.publish((String)ADDRESS, (Object)implementor);
    }

    protected void addVerifiers() {
        MAPVerifier mapVerifier = new MAPVerifier();
        mapVerifier.verificationCache = this;
        HeaderVerifier headerVerifier = new HeaderVerifier();
        headerVerifier.verificationCache = this;
        Interceptor[] interceptors = new Interceptor[]{mapVerifier, headerVerifier};
        this.addInterceptors(this.getBus().getInInterceptors(), interceptors);
        this.addInterceptors(this.getBus().getInFaultInterceptors(), interceptors);
        this.addInterceptors(this.getBus().getOutInterceptors(), interceptors);
        this.addInterceptors(this.getBus().getOutFaultInterceptors(), interceptors);
    }

    private void addInterceptors(List<Interceptor> chain, Interceptor[] interceptors) {
        for (int i = 0; i < interceptors.length; ++i) {
            chain.add(interceptors[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Server s = new Server();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }

    @Override
    public void put(String verification) {
        if (verification != null) {
            this.verified = this.verified == null ? verification : this.verified + "; " + verification;
        }
    }

    protected boolean verify(Logger log) {
        if (this.verified != null) {
            System.out.println("MAP/Header verification failed: " + this.verified);
            log.log(Level.WARNING, "MAP/Header verification failed: {0}", this.verified);
        }
        return this.verified == null;
    }
}

