/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.neethi.Assertion;

public class PolicyLoggingInterceptor
extends AbstractPhaseInterceptor {
    private static final Logger LOG = LogUtils.getLogger(PolicyLoggingInterceptor.class);
    private Bus bus;

    PolicyLoggingInterceptor(boolean o) {
        super(o ? "post-stream" : "post-invoke");
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public void handleMessage(Message message) throws Fault {
        EndpointInfo ei = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
        BindingOperationInfo boi = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        LOG.fine("Getting effective server request policy for endpoint " + ei + " and binding operation " + boi);
        EffectivePolicy ep = ((PolicyEngine)this.bus.getExtension(PolicyEngine.class)).getEffectiveServerRequestPolicy(ei, boi);
        Iterator it = ep.getPolicy().getAlternatives();
        while (it.hasNext()) {
            Collection as = CastUtils.cast((Collection)((Collection)it.next()), Assertion.class);
            LOG.fine("Checking alternative with " + as.size() + " assertions.");
            for (Assertion a : as) {
                LOG.fine("Assertion: " + a.getClass().getName());
                HTTPServerPolicy p = (HTTPServerPolicy)JaxbAssertion.cast((Assertion)a, HTTPServerPolicy.class).getData();
                LOG.fine("server policy: " + PolicyUtils.toString((HTTPServerPolicy)p));
            }
        }
    }
}

