/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.rm;

import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;

@WebService(serviceName="ControlService", portName="ControlPort", endpointInterface="org.apache.cxf.greeter_control.Control", targetNamespace="http://cxf.apache.org/greeter_control")
public class ControlImpl
extends org.apache.cxf.greeter_control.ControlImpl {
    private static final Logger LOG = LogUtils.getLogger(ControlImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startGreeter(String cfgResource) {
        String derbyHome = System.getProperty("derby.system.home");
        try {
            System.setProperty("derby.system.home", derbyHome + "-server");
            SpringBusFactory bf = new SpringBusFactory();
            this.greeterBus = bf.createBus(cfgResource);
            BusFactory.setDefaultBus((Bus)this.greeterBus);
            LOG.info("Initialised bus " + this.greeterBus + " with cfg file resource: " + cfgResource);
            LOG.fine("greeterBus inInterceptors: " + this.greeterBus.getInInterceptors());
            LoggingInInterceptor logIn = new LoggingInInterceptor();
            LoggingOutInterceptor logOut = new LoggingOutInterceptor();
            this.greeterBus.getInInterceptors().add(logIn);
            this.greeterBus.getOutInterceptors().add(logOut);
            this.greeterBus.getOutFaultInterceptors().add(logOut);
            Endpoint.publish((String)this.address, (Object)this.implementor);
            LOG.info("Published greeter endpoint.");
        }
        finally {
            if (derbyHome != null) {
                System.setProperty("derby.system.home", derbyHome);
            } else {
                System.clearProperty("derby.system.home");
            }
        }
        return true;
    }
}

